/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.LayoutUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;

public class LogicalImageDatasetSection
extends TabContent {
    private final AbstractExternalData dataset;

    public LogicalImageDatasetSection(ScreeningViewContext viewContext, AbstractExternalData dataset) {
        super("Images", (IViewContext)viewContext, (IIdHolder)dataset);
        this.dataset = dataset;
        this.setIds(DisplayTypeIDGenerator.LOGICAL_IMAGE_DATASET_SECTION);
    }

    private ScreeningViewContext getViewContext() {
        return (ScreeningViewContext)this.viewContext;
    }

    protected void showContent() {
        ScreeningViewContext context = this.getViewContext();
        this.add((Component)new Text(context.getMessage("load_in_progress", new Object[0])));
        ((IScreeningClientServiceAsync)context.getService()).getImageDatasetInfo(this.dataset.getCode(), this.dataset.getDataStore().getCode(), null, this.createDisplayCallback());
    }

    private AsyncCallback<LogicalImageInfo> createDisplayCallback() {
        return new AbstractAsyncCallback<LogicalImageInfo>((IViewContext)this.getViewContext()){

            protected void process(LogicalImageInfo imageInfo) {
                LogicalImageDatasetSection.this.removeAll();
                LogicalImageDatasetSection.this.setLayout((Layout)new RowLayout());
                LogicalImageDatasetSection.this.setScrollMode(Style.Scroll.AUTO);
                Widget viewerWidget = LogicalImageDatasetSection.this.createImageViewerWidget(imageInfo);
                LogicalImageDatasetSection.this.add(viewerWidget, (LayoutData)LayoutUtils.createRowLayoutSurroundingData());
                LogicalImageDatasetSection.this.layout();
            }
        };
    }

    private Widget createImageViewerWidget(LogicalImageInfo imageInfo) {
        Experiment experiment = this.dataset.getExperiment();
        String experimentPermId = experiment.getPermId();
        String identifier = experiment.getIdentifier();
        LogicalImageReference logicalImageReference = new LogicalImageReference(this.dataset.getCode(), this.dataset.getDataStore().getCode(), this.dataset.getDataStore().getHostUrl(), imageInfo.getImageParameters());
        LogicalImageViewer viewer = new LogicalImageViewer(logicalImageReference, (IViewContext<IScreeningClientServiceAsync>)this.getViewContext(), identifier, experimentPermId, true);
        Widget viewerWidget = viewer.getViewerWidget(imageInfo.getChannelStacks(), "LogicalImageDatasetSection");
        return viewerWidget;
    }
}

