/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.Constants;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ChannelChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.DefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.IDefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LazyImageSeriesFrame;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageClickHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageRefreshHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageChannelsReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.image.TileImage;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.image.TileImageInitializer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesGrid;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesGridInitializer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageChannelStack;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.TileLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.reveregroup.gwt.imagepreloader.FitImageLoadEvent;
import com.reveregroup.gwt.imagepreloader.FitImageLoadHandler;
import java.util.ArrayList;
import java.util.List;

public class LogicalImageViewer {
    static final int TILE_SPACING = 3;
    private static final String NO_IMAGES_AVAILABLE_MSG = "No images available";
    private static final int ONE_IMAGE_SIZE_PX = 120;
    private static final int ADJUST_COLORS_AND_REFRESH_BUTTON_WIDTH_PX = 80;
    private final LogicalImageReference logicalImageReference;
    private final IViewContext<IScreeningClientServiceAsync> viewContext;
    private final IDefaultChannelState channelState;
    private final String experimentIdentifier;
    private final String experimentPermId;
    private final boolean showColorAdjustmentButton;
    private String currentlySelectedChannelCode;
    private LogicalImageClickHandler logicalImageClickHandler;
    private LogicalImageRefreshHandler logicalImageRefreshHandler;

    public LogicalImageViewer(LogicalImageReference logicalImageReference, IViewContext<IScreeningClientServiceAsync> viewContext, String experimentIdentifier, String experimentPermId, boolean showColorAdjustmentButton) {
        this.logicalImageReference = logicalImageReference;
        this.viewContext = viewContext;
        this.experimentIdentifier = experimentIdentifier;
        this.experimentPermId = experimentPermId;
        this.channelState = this.createDefaultChannelState();
        this.showColorAdjustmentButton = showColorAdjustmentButton && this.isImageEditorEnabled();
    }

    public Widget getViewerWidget(List<ImageChannelStack> channelStackImages, String windowId) {
        if (this.logicalImageReference.isMultidimensional()) {
            return this.createSeriesImageWidget(channelStackImages, windowId + "series");
        }
        return this.getStaticImageWidget(windowId + "static");
    }

    public Widget getViewerWidget(String windowId) {
        if (this.logicalImageReference.isMultidimensional()) {
            return this.getSeriesImageWidget(windowId + "series");
        }
        return this.getStaticImageWidget(windowId + "static");
    }

    private Widget getSeriesImageWidget(final String windowId) {
        final LayoutContainer container = new LayoutContainer();
        container.add((Widget)new Text(this.viewContext.getMessage("load_in_progress", new Object[0])));
        container.setLayout((Layout)new FlowLayout());
        ((IScreeningClientServiceAsync)this.viewContext.getService()).getImageDatasetInfo(this.logicalImageReference.getDatasetCode(), this.logicalImageReference.getDatastoreCode(), this.logicalImageReference.tryGetWellLocation(), (AsyncCallback<LogicalImageInfo>)new AbstractAsyncCallback<LogicalImageInfo>(this.viewContext){

            protected void process(LogicalImageInfo imageInfo) {
                container.removeAll();
                List<ImageChannelStack> channelStackImages = imageInfo.getChannelStacks();
                if (channelStackImages.size() > 0) {
                    container.add(LogicalImageViewer.this.createSeriesImageWidget(channelStackImages, windowId));
                } else {
                    container.add((Widget)new Text(LogicalImageViewer.NO_IMAGES_AVAILABLE_MSG));
                }
                container.layout();
            }
        });
        return container;
    }

    private Widget createSeriesImageWidget(final List<ImageChannelStack> channelStackImages, String windowId) {
        final Button adjustColorsButton = this.createAdjustColorsButton();
        ChannelChooser.IChanneledViewerFactory viewerFactory = new ChannelChooser.IChanneledViewerFactory(){

            @Override
            public LayoutContainer create(LogicalImageChannelsReference channelReferences, ImageResolution resolution) {
                LogicalImageViewer.this.currentlySelectedChannelCode = LogicalImageViewer.getSelectedChannelCode(channelReferences);
                LogicalImageViewer.setAdjustColorsButtonState(adjustColorsButton, channelReferences.getChannelCodes());
                LazyImageSeriesFrame.ImagesDownloadListener downloadListener = new LazyImageSeriesFrame.ImagesDownloadListener(){

                    @Override
                    public void imagesDownloaded(LazyImageSeriesFrame frame) {
                        LogicalImageViewer.this.notifyImageRefresh();
                    }
                };
                int imageWidth = LogicalImageViewer.getImageWidth(LogicalImageViewer.this.logicalImageReference, resolution);
                int imageHeight = LogicalImageViewer.getImageHeight(LogicalImageViewer.this.logicalImageReference, resolution);
                LogicalImageSeriesGridInitializer initializer = new LogicalImageSeriesGridInitializer();
                initializer.setViewContext((IViewContext<IScreeningClientServiceAsync>)LogicalImageViewer.this.viewContext);
                initializer.setDisplayTypeId(LogicalImageViewer.this.createDisplayTypeId());
                initializer.setChannelStackImages(LogicalImageViewer.this.filterChannelStackImages(channelStackImages));
                initializer.setChannelReferences(channelReferences);
                initializer.setImageSize(new LogicalImageSize(imageWidth, imageHeight));
                initializer.setImageClickHandler(LogicalImageViewer.this.logicalImageClickHandler);
                initializer.setImageDownloadListener(downloadListener);
                return new LogicalImageSeriesGrid(initializer);
            }
        };
        return this.createViewerWithChannelChooser(viewerFactory, adjustColorsButton, windowId);
    }

    private List<ImageChannelStack> filterChannelStackImages(List<ImageChannelStack> channelStackImages) {
        TileLocation tileLocation = this.logicalImageReference.tryGetTileLocation();
        if (tileLocation == null) {
            return channelStackImages;
        }
        ArrayList<ImageChannelStack> filteredChannelStackImages = new ArrayList<ImageChannelStack>();
        for (ImageChannelStack channelStackImage : channelStackImages) {
            if (channelStackImage.getTileCol() != tileLocation.getColumn() || channelStackImage.getTileRow() != tileLocation.getRow()) continue;
            filteredChannelStackImages.add(channelStackImage);
        }
        return filteredChannelStackImages;
    }

    private LayoutContainer createViewerWithChannelChooser(ChannelChooser.IChanneledViewerFactory viewerFactory, final Button adjustColorsButton, String windowId) {
        final LayoutContainer container = LogicalImageViewer.createMainEmptyContainer();
        if (this.hasNoChannels()) {
            container.add((Widget)new Label(NO_IMAGES_AVAILABLE_MSG));
            return container;
        }
        final ChannelChooser channelChooser = new ChannelChooser(this.logicalImageReference, viewerFactory, this.channelState, windowId);
        channelChooser.addViewerTo(container, this.viewContext, new AsyncCallback<Void>(){

            public void onSuccess(Void result) {
                if (LogicalImageViewer.this.showColorAdjustmentButton) {
                    LayoutContainer buttonToolbar = new LayoutContainer();
                    buttonToolbar.setLayout((Layout)new ColumnLayout());
                    buttonToolbar.add((Widget)adjustColorsButton);
                    Button refreshButton = new Button(LogicalImageViewer.this.viewContext.getMessage("button_refresh", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent ce) {
                            LogicalImageViewer.this.updateDatasetAndRefresh(channelChooser);
                        }
                    });
                    buttonToolbar.add((Widget)refreshButton);
                    adjustColorsButton.setWidth(80);
                    refreshButton.setWidth(80);
                    RowData layoutData = new RowData();
                    layoutData.setMargins(new Margins(10, 2, 0, 2));
                    container.add((Widget)buttonToolbar, (LayoutData)layoutData);
                }
                container.layout();
            }

            public void onFailure(Throwable caught) {
            }
        });
        return container;
    }

    private Button createAdjustColorsButton() {
        Button adjustColorsButton = new Button(this.viewContext.getMessage("image_viewer_button", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                LogicalImageViewer.this.launchImageEditor();
            }
        });
        return adjustColorsButton;
    }

    private boolean hasNoChannels() {
        return this.logicalImageReference.getChannelsCodes().size() == 0;
    }

    private void updateDatasetAndRefresh(final ChannelChooser channelChooser) {
        ((IScreeningClientServiceAsync)this.viewContext.getService()).getImageDatasetReference(this.logicalImageReference.getDatasetCode(), this.logicalImageReference.getDatastoreCode(), (AsyncCallback<ImageDatasetEnrichedReference>)new AbstractAsyncCallback<ImageDatasetEnrichedReference>(this.viewContext){

            protected void process(ImageDatasetEnrichedReference refreshedDataset) {
                LogicalImageReference updatedLogicalImageReference = LogicalImageViewer.this.logicalImageReference.updateDatasets(refreshedDataset);
                channelChooser.refresh(updatedLogicalImageReference);
            }
        });
    }

    private static LayoutContainer createMainEmptyContainer() {
        LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new FlowLayout());
        return container;
    }

    private Widget getStaticImageWidget(String windowId) {
        final Button adjustColorsButton = this.createAdjustColorsButton();
        final FitImageLoadHandler downloadHandler = new FitImageLoadHandler(){

            public void imageLoaded(FitImageLoadEvent event) {
                LogicalImageViewer.this.notifyImageRefresh();
            }
        };
        ChannelChooser.IChanneledViewerFactory viewerFactory = new ChannelChooser.IChanneledViewerFactory(){

            @Override
            public LayoutContainer create(LogicalImageChannelsReference channelReferences, ImageResolution resolution) {
                LogicalImageViewer.this.currentlySelectedChannelCode = LogicalImageViewer.getSelectedChannelCode(channelReferences);
                LogicalImageViewer.setAdjustColorsButtonState(adjustColorsButton, channelReferences.getChannelCodes());
                String sessionId = LogicalImageViewer.getSessionId(LogicalImageViewer.this.viewContext);
                int imageWidth = LogicalImageViewer.getImageWidth(LogicalImageViewer.this.logicalImageReference, resolution);
                int imageHeight = LogicalImageViewer.getImageHeight(LogicalImageViewer.this.logicalImageReference, resolution);
                return LogicalImageViewer.createTilesGrid(channelReferences, sessionId, imageWidth, imageHeight, LogicalImageViewer.this.logicalImageClickHandler, downloadHandler);
            }
        };
        return this.createViewerWithChannelChooser(viewerFactory, adjustColorsButton, windowId);
    }

    private String createDisplayTypeId() {
        ScreeningDisplayTypeIDGenerator wellSearchChannelIdGenerator = ScreeningDisplayTypeIDGenerator.EXPERIMENT_CHANNEL;
        return wellSearchChannelIdGenerator.createID(this.experimentPermId);
    }

    private IDefaultChannelState createDefaultChannelState() {
        return new DefaultChannelState(this.viewContext, this.createDisplayTypeId());
    }

    public void launchImageEditor() {
        WellLocation wellLocation;
        URLMethodWithParameters urlParams = new URLMethodWithParameters(Constants.IMAGE_VIEWER_LAUNCH_SERVLET_NAME);
        String sessionToken = this.viewContext.getModel().getSessionContext().getSessionID();
        urlParams.addParameter("session", (Object)sessionToken);
        urlParams.addParameter("server-url", (Object)GWT.getHostPageBaseURL());
        urlParams.addParameter("experiment-id", (Object)this.experimentIdentifier);
        if (this.currentlySelectedChannelCode != null) {
            urlParams.addParameter("channel", (Object)this.currentlySelectedChannelCode);
        }
        if ((wellLocation = this.logicalImageReference.tryGetWellLocation()) != null) {
            String imagePointer = this.logicalImageReference.getDatasetCode() + ":" + wellLocation.getRow() + "." + wellLocation.getColumn();
            urlParams.addParameter("data-set-and-wells", (Object)imagePointer);
        } else {
            urlParams.addParameter("data-set-and-wells", (Object)this.logicalImageReference.getDatasetCode());
        }
        Window.open((String)urlParams.toString(), (String)"_blank", (String)"resizable=yes,scrollbars=yes,dependent=yes");
    }

    public boolean isImageEditorEnabled() {
        return "true".equals(this.viewContext.getPropertyOrNull("image-viewer-enabled"));
    }

    public void setLogicalImageClickHandler(LogicalImageClickHandler logicalImageClickHandler) {
        this.logicalImageClickHandler = logicalImageClickHandler;
    }

    public void setLogicalImageRefreshHandler(LogicalImageRefreshHandler logicalImageRefreshHandler) {
        this.logicalImageRefreshHandler = logicalImageRefreshHandler;
    }

    public static LayoutContainer createTilesGrid(LogicalImageChannelsReference channelReferences, String sessionId, int imageSizePx, LogicalImageClickHandler clickHandler, FitImageLoadHandler downloadHandler) {
        LogicalImageReference images = channelReferences.getBasicImage();
        return LogicalImageViewer.createTilesGrid(channelReferences, sessionId, LogicalImageViewer.getImageWidth(imageSizePx, images), LogicalImageViewer.getImageHeight(imageSizePx, images), clickHandler, downloadHandler);
    }

    private static LayoutContainer createTilesGrid(LogicalImageChannelsReference channelReferences, String sessionId, int logicalImageWidth, int logicalImageHeight, LogicalImageClickHandler clickHandler, FitImageLoadHandler downloadHandler) {
        TileLocation tileLocation = channelReferences.getBasicImage().tryGetTileLocation();
        if (tileLocation == null) {
            LogicalImageReference images = channelReferences.getBasicImage();
            TableLayout layout = new TableLayout(images.getTileColsNum());
            layout.setCellSpacing(3);
            LayoutContainer container = new LayoutContainer((Layout)layout);
            for (int row = 1; row <= images.getTileRowsNum(); ++row) {
                for (int col = 1; col <= images.getTileColsNum(); ++col) {
                    TileImageInitializer initializer = new TileImageInitializer();
                    initializer.setSessionId(sessionId);
                    initializer.setChannelReferences(channelReferences);
                    initializer.setImageWidth(logicalImageWidth);
                    initializer.setImageHeight(logicalImageHeight);
                    initializer.setImageClickHandler(clickHandler);
                    initializer.setImageLoadHandler(downloadHandler);
                    initializer.setTileRow(row);
                    initializer.setTileColumn(col);
                    container.add((Widget)new TileImage(initializer));
                }
            }
            return container;
        }
        TileImageInitializer initializer = new TileImageInitializer();
        initializer.setSessionId(sessionId);
        initializer.setChannelReferences(channelReferences);
        initializer.setImageWidth(logicalImageWidth);
        initializer.setImageHeight(logicalImageHeight);
        initializer.setImageClickHandler(clickHandler);
        initializer.setImageLoadHandler(downloadHandler);
        initializer.setTileRow(tileLocation.getRow());
        initializer.setTileColumn(tileLocation.getColumn());
        LayoutContainer container = new LayoutContainer((Layout)new FlowLayout());
        container.add((Widget)new TileImage(initializer));
        return container;
    }

    private static String getSelectedChannelCode(LogicalImageChannelsReference channelReferences) {
        String newChannelCode = null;
        List<String> channelCodes = channelReferences.getChannelCodes();
        if (channelCodes != null && !channelCodes.isEmpty()) {
            newChannelCode = channelCodes.get(0);
        }
        return newChannelCode;
    }

    private static void setAdjustColorsButtonState(Button adjustColorsButton, List<String> channelCodes) {
        boolean enabled = channelCodes != null && channelCodes.size() == 1;
        adjustColorsButton.setEnabled(enabled);
    }

    private static String getSessionId(IViewContext<?> viewContext) {
        return viewContext.getModel().getSessionContext().getSessionID();
    }

    private static int getImageHeight(LogicalImageReference images, ImageResolution resolution) {
        if (resolution == null) {
            return LogicalImageViewer.getImageHeight(120, images);
        }
        return resolution.getHeight();
    }

    private static int getImageWidth(LogicalImageReference images, ImageResolution resolution) {
        if (resolution == null) {
            return LogicalImageViewer.getImageWidth(120, images);
        }
        return resolution.getWidth();
    }

    private static int getImageHeight(int imageSizePx, LogicalImageReference images) {
        float imageSizeMultiplyFactor = LogicalImageViewer.getImageSizeMultiplyFactor(images);
        return (int)((float)imageSizePx * imageSizeMultiplyFactor);
    }

    private static int getImageWidth(int imageSizePx, LogicalImageReference images) {
        float imageSizeMultiplyFactor = LogicalImageViewer.getImageSizeMultiplyFactor(images);
        return (int)((float)imageSizePx * imageSizeMultiplyFactor);
    }

    private static float getImageSizeMultiplyFactor(LogicalImageReference images) {
        float dim = images.tryGetTileLocation() == null ? (float)Math.max(images.getTileRowsNum(), images.getTileColsNum()) : 1.0f;
        return 4.0f / dim;
    }

    private void notifyImageRefresh() {
        if (this.logicalImageRefreshHandler != null) {
            this.logicalImageRefreshHandler.onRefresh();
        }
    }
}

