/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ColumnIDUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Text;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class MaterialDisambiguationGrid
extends TypedTableGrid<Material> {
    private static final String BROWSER_ID = "openbis_material-disambiguation-grid";
    private final WellSearchCriteria searchCriteria;
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;

    public static void openTab(final IViewContext<IScreeningClientServiceAsync> viewContext, final WellSearchCriteria searchCriteria, final String nothingFoundRedirectionUrlOrNull) {
        boolean refreshAutomatically = false;
        final MaterialDisambiguationGrid grid = new MaterialDisambiguationGrid(viewContext, searchCriteria, refreshAutomatically);
        final AbstractTabItemFactory disambiguationTabFactory = MaterialDisambiguationGrid.createDisambiguationTab(viewContext, searchCriteria, grid);
        grid.refresh(new IDataRefreshCallback(){
            private boolean firstCall = true;

            public void postRefresh(boolean wasSuccessful) {
                if (!this.firstCall) {
                    return;
                }
                this.firstCall = false;
                if (grid.getRowNumber() == 0) {
                    if (nothingFoundRedirectionUrlOrNull != null) {
                        String url = URL.decodeQueryString((String)nothingFoundRedirectionUrlOrNull);
                        WindowUtils.redirect((String)url, (String)"_top");
                    } else {
                        AbstractTabItemFactory tabFactory = MaterialDisambiguationGrid.createNoResultsTab((IViewContext<IScreeningClientServiceAsync>)viewContext, searchCriteria);
                        DispatcherHelper.dispatchNaviEvent((AbstractTabItemFactory)tabFactory);
                    }
                } else if (grid.getRowNumber() == 1) {
                    List materials = grid.getContainedGridElements();
                    Material material = (Material)materials.get(0);
                    grid.openMaterialDetailViewer(material);
                } else {
                    DispatcherHelper.dispatchNaviEvent((AbstractTabItemFactory)disambiguationTabFactory);
                }
            }
        }, false);
    }

    private static AbstractTabItemFactory createNoResultsTab(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria searchCriteria) {
        boolean searchAllExperiments = searchCriteria.getExperimentCriteria().tryGetExperiment() == null;
        String msgDictKey = searchAllExperiments ? "WELL_SEARCH_NO_RESULTS_IN_ANY_EXP_FOUND" : "WELL_SEARCH_NO_RESULTS_IN_SELECTED_EXP_FOUND";
        Text component = new Text(viewContext.getMessage(msgDictKey, new Object[0]));
        return MaterialDisambiguationGrid.createSimpleTab(viewContext, (Component)component, "MATERIAL_DISAMBIGUATION_TITLE", "well-search-no-results");
    }

    private static AbstractTabItemFactory createSimpleTab(final IViewContext<?> viewContext, final Component component, final String titleDictKey, final String idSuffix) {
        return new AbstractTabItemFactory(){

            public ITabItem create() {
                return DefaultTabItem.createUnaware((String)this.getTabTitle(), (Component)component, (boolean)false, (IViewContext)viewContext);
            }

            public String getId() {
                return "openbis_" + idSuffix;
            }

            public HelpPageIdentifier getHelpPageIdentifier() {
                return null;
            }

            public String getTabTitle() {
                return viewContext.getMessage(titleDictKey, new Object[0]);
            }

            public String tryGetLink() {
                return null;
            }
        };
    }

    private static AbstractTabItemFactory createDisambiguationTab(final IViewContext<IScreeningClientServiceAsync> viewContext, final WellSearchCriteria searchCriteria, final MaterialDisambiguationGrid grid) {
        return new AbstractTabItemFactory(){
            private final String reportDate = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_MEDIUM).format(new Date());

            public ITabItem create() {
                return DefaultTabItem.create((String)this.getTabTitle(), (IDisposableComponent)grid.asDisposableWithoutToolbar(), (IViewContext)viewContext);
            }

            public String getId() {
                return "openbis_-MaterialDisambiguationGrid-" + this.reportDate;
            }

            public HelpPageIdentifier getHelpPageIdentifier() {
                return HelpPageIdentifier.createSpecific((String)"Material Disambiguation");
            }

            public String getTabTitle() {
                return viewContext.getMessage("MATERIAL_DISAMBIGUATION_TITLE", new Object[0]);
            }

            public String tryGetLink() {
                return ScreeningLinkExtractor.tryCreateWellsSearchLink(searchCriteria, false);
            }
        };
    }

    private MaterialDisambiguationGrid(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria searchCriteria, boolean refreshAutomatically) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, refreshAutomatically, (IDisplayTypeIDGenerator)ScreeningDisplayTypeIDGenerator.MATERIAL_DISAMBIGUATION_GRID);
        this.screeningViewContext = viewContext;
        this.searchCriteria = searchCriteria;
        this.setHeader(viewContext.getMessage("MATERIAL_DISAMBIGUATION_GRID_EXPLANATION", new Object[0]));
        this.linkToMaterialDetails();
        this.setBorders(true);
    }

    private void linkToMaterialDetails() {
        ICellListenerAndLinkGenerator<Material> listenerLinkGenerator = new ICellListenerAndLinkGenerator<Material>(){

            public String tryGetLink(Material material, ISerializableComparable value) {
                return ScreeningLinkExtractor.createMaterialDetailsLink((IEntityInformationHolder)material, MaterialDisambiguationGrid.this.searchCriteria.getExperimentCriteria());
            }

            public void handle(TableModelRowWithObject<Material> row, boolean specialKeyPressed) {
                Material material = (Material)row.getObjectOrNull();
                MaterialDisambiguationGrid.this.openMaterialDetailViewer(material);
            }
        };
        this.registerListenerAndLinkGenerator("CODE", (ICellListenerAndLinkGenerator)listenerLinkGenerator);
        String detailsLinkPropertyTypeName = this.screeningViewContext.getPropertyOrNull("material-details-property-type");
        if (detailsLinkPropertyTypeName != null) {
            String detailsLinkPropertyColumnId = ColumnIDUtils.getColumnIdForProperty((String)"property-", (String)detailsLinkPropertyTypeName);
            this.registerListenerAndLinkGenerator(detailsLinkPropertyColumnId, (ICellListenerAndLinkGenerator)listenerLinkGenerator);
        }
    }

    private void openMaterialDetailViewer(Material material) {
        ClientPluginFactory.openImagingMaterialViewer((IEntityInformationHolderWithPermId)material, this.searchCriteria.getExperimentCriteria(), this.searchCriteria.getAnalysisProcedureCriteria(), false, this.screeningViewContext);
    }

    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Material>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Material>> callback) {
        ((IScreeningClientServiceAsync)this.screeningViewContext.getService()).listMaterials((IResultSetConfig<String, TableModelRowWithObject<Material>>)resultSetConfig, this.searchCriteria, (AsyncCallback<TypedTableResultSet<Material>>)callback);
    }

    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Material>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((IScreeningClientServiceAsync)this.screeningViewContext.getService()).prepareExportMaterials(exportCriteria, (AsyncCallback<String>)callback);
    }

    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE");
    }
}

