/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureListenerHolder;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialReplicaSummaryViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSimpleFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class MaterialFeaturesFromAllExperimentsGrid
extends TypedTableGrid<MaterialSimpleFeatureVectorSummary> {
    private static final String ID = "material_features_from_all_experiments";
    private static final String PREFIX = "openbis_material_features_from_all_experiments";
    public static final String BROWSER_ID = "openbis_material_features_from_all_experiments_main";
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final IEntityInformationHolderWithPermId material;
    private final WellSearchCriteria.ExperimentSearchByProjectCriteria experimentSearchCriteria;
    private WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;
    private boolean computeRanks;

    public static IDisposableComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithPermId material, WellSearchCriteria.ExperimentSearchByProjectCriteria experimentSearchCriteria, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks) {
        return new MaterialFeaturesFromAllExperimentsGrid(viewContext, material, experimentSearchCriteria, analysisProcedureCriteria, computeRanks).asDisposableWithoutToolbar();
    }

    public static IDisposableComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithPermId material, WellSearchCriteria.ExperimentSearchByProjectCriteria experimentSearchCriteria, AnalysisProcedureListenerHolder analysisProcedureListenerHolder) {
        MaterialFeaturesFromAllExperimentsGrid grid = new MaterialFeaturesFromAllExperimentsGrid(viewContext, material, experimentSearchCriteria, null, false);
        analysisProcedureListenerHolder.setAnalysisProcedureListener(grid.createAnalysisProcedureListener());
        return grid.asDisposableWithoutToolbar();
    }

    MaterialFeaturesFromAllExperimentsGrid(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithPermId material, WellSearchCriteria.ExperimentSearchByProjectCriteria experimentSearchCriteria, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteriaOrNull, boolean computeRanks) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, analysisProcedureCriteriaOrNull != null, (IDisplayTypeIDGenerator)DisplayTypeIDGenerator.MATERIAL_FEATURES_FROM_ALL_EXPERIMENTS_SECTION);
        this.screeningViewContext = viewContext;
        this.material = material;
        this.experimentSearchCriteria = experimentSearchCriteria;
        this.analysisProcedureCriteria = analysisProcedureCriteriaOrNull;
        this.computeRanks = computeRanks;
        this.setBorders(true);
        this.linkExperiment();
        this.linkMaterialInExperiment();
    }

    private AnalysisProcedureChooser.IAnalysisProcedureSelectionListener createAnalysisProcedureListener() {
        return new AnalysisProcedureChooser.IAnalysisProcedureSelectionListener(){

            @Override
            public void analysisProcedureSelected(WellSearchCriteria.AnalysisProcedureCriteria criteria) {
                MaterialFeaturesFromAllExperimentsGrid.this.analysisProcedureCriteria = criteria;
                MaterialFeaturesFromAllExperimentsGrid.this.refresh(true);
            }
        };
    }

    private void linkExperiment() {
        this.registerListenerAndLinkGenerator("ASSAY", (ICellListenerAndLinkGenerator)new ICellListenerAndLinkGenerator<MaterialSimpleFeatureVectorSummary>(){

            public void handle(TableModelRowWithObject<MaterialSimpleFeatureVectorSummary> rowItem, boolean specialKeyPressed) {
                ClientPluginFactory.openImagingExperimentViewer((IEntityInformationHolderWithPermId)((MaterialSimpleFeatureVectorSummary)rowItem.getObjectOrNull()).getExperiment(), MaterialFeaturesFromAllExperimentsGrid.this.getRestrictGlobalScopeLinkToProject(), (IViewContext<IScreeningClientServiceAsync>)MaterialFeaturesFromAllExperimentsGrid.this.screeningViewContext);
            }

            public String tryGetLink(MaterialSimpleFeatureVectorSummary entity, ISerializableComparable value) {
                return ClientPluginFactory.createImagingExperimentViewerLink((IEntityInformationHolderWithPermId)entity.getExperiment(), MaterialFeaturesFromAllExperimentsGrid.this.getRestrictGlobalScopeLinkToProject(), (IViewContext<IScreeningClientServiceAsync>)MaterialFeaturesFromAllExperimentsGrid.this.screeningViewContext);
            }
        });
    }

    private void linkMaterialInExperiment() {
        this.registerListenerAndLinkGenerator("ASSAY", (ICellListenerAndLinkGenerator)new ICellListenerAndLinkGenerator<MaterialSimpleFeatureVectorSummary>(){

            public void handle(TableModelRowWithObject<MaterialSimpleFeatureVectorSummary> rowItem, boolean specialKeyPressed) {
                MaterialSimpleFeatureVectorSummary summaryOrNull = (MaterialSimpleFeatureVectorSummary)rowItem.getObjectOrNull();
                if (summaryOrNull == null) {
                    return;
                }
                String experimentPermId = summaryOrNull.getExperiment().getPermId();
                assert (MaterialFeaturesFromAllExperimentsGrid.this.analysisProcedureCriteria != null) : "analysisProcedureCriteria is not set yet, it should not happen because this field is set before the grid refreshes";
                MaterialReplicaSummaryViewer.openTab((IViewContext<IScreeningClientServiceAsync>)MaterialFeaturesFromAllExperimentsGrid.this.screeningViewContext, experimentPermId, MaterialFeaturesFromAllExperimentsGrid.this.getRestrictGlobalScopeLinkToProject(), new MaterialIdentifier(MaterialFeaturesFromAllExperimentsGrid.this.material), MaterialFeaturesFromAllExperimentsGrid.this.analysisProcedureCriteria);
            }

            public String tryGetLink(MaterialSimpleFeatureVectorSummary entity, ISerializableComparable value) {
                WellSearchCriteria.ExperimentSearchCriteria experiment = MaterialFeaturesFromAllExperimentsGrid.this.getExperimentCriteria(entity);
                String link = ScreeningLinkExtractor.createMaterialDetailsLink((IEntityInformationHolder)MaterialFeaturesFromAllExperimentsGrid.this.material, experiment);
                return link;
            }
        });
    }

    private boolean getRestrictGlobalScopeLinkToProject() {
        return WellSearchCriteria.shouldRestrictScopeToProject(this.experimentSearchCriteria);
    }

    private WellSearchCriteria.ExperimentSearchCriteria getExperimentCriteria(MaterialSimpleFeatureVectorSummary summary) {
        ExperimentReference experimentRef = summary.getExperiment();
        return WellSearchCriteria.ExperimentSearchCriteria.createExperiment(experimentRef, this.getRestrictGlobalScopeLinkToProject());
    }

    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<MaterialSimpleFeatureVectorSummary>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<MaterialSimpleFeatureVectorSummary>> callback) {
        WellSearchCriteria.MaterialFeaturesManyExpCriteria criteria = new WellSearchCriteria.MaterialFeaturesManyExpCriteria(new TechId((IIdAndCodeHolder)this.material), this.analysisProcedureCriteria, this.experimentSearchCriteria, this.computeRanks);
        ((IScreeningClientServiceAsync)this.screeningViewContext.getService()).listMaterialFeaturesFromAllExperiments((IResultSetConfig<String, TableModelRowWithObject<MaterialSimpleFeatureVectorSummary>>)resultSetConfig, criteria, (AsyncCallback<TypedTableResultSet<MaterialSimpleFeatureVectorSummary>>)callback);
    }

    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<MaterialSimpleFeatureVectorSummary>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((IScreeningClientServiceAsync)this.screeningViewContext.getService()).prepareExportMaterialFeaturesFromAllExperiments(exportCriteria, (AsyncCallback<String>)callback);
    }

    protected String translateColumnIdToDictionaryKey(String columnID) {
        return "material_features_from_all_experiments_" + columnID.toUpperCase();
    }

    public void dispose() {
        this.asDisposableWithoutToolbar().dispose();
    }
}

