/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureListenerHolder;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialFeaturesFromAllExperimentsComponent;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialReplicaSummaryComponent;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.SingleOrAllExperimentsChooser;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.rpc.AsyncCallback;

class MaterialMergedSummarySection
extends DisposableTabContent {
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final Material material;
    private final boolean restrictGlobalScopeLinkToProject;
    private final WellSearchCriteria.ExperimentSearchCriteriaHolder experimentSearchCriteriaHolder;
    private final AnalysisProcedureListenerHolder analysisProcedureListenerHolder = new AnalysisProcedureListenerHolder();
    private WellSearchCriteria.AnalysisProcedureCriteria initialAnalysisProcedureCriteriaOrNull;
    private AnalysisProcedureChooser analysisProcedureChooser;

    public MaterialMergedSummarySection(IViewContext<IScreeningClientServiceAsync> screeningViewContext, Material material, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.AnalysisProcedureCriteria initialAnalysisProcedureCriteriaOrNull, boolean restrictGlobalScopeLinkToProject) {
        super(screeningViewContext.getMessage("MATERIAL_MERGED_SUMMARY_SECTION_TITLE", new Object[0]), screeningViewContext, (IIdHolder)material);
        this.screeningViewContext = screeningViewContext;
        this.material = material;
        this.initialAnalysisProcedureCriteriaOrNull = initialAnalysisProcedureCriteriaOrNull;
        this.restrictGlobalScopeLinkToProject = restrictGlobalScopeLinkToProject;
        this.experimentSearchCriteriaHolder = new WellSearchCriteria.ExperimentSearchCriteriaHolder(experimentCriteriaOrNull);
        this.setIds(DisplayTypeIDGenerator.MATERIAL_MERGED_SUMMARY_SECTION);
    }

    private IDelegatedAction createRefreshAction(final WellSearchCriteria.ExperimentSearchCriteriaHolder searchCriteriaHolder) {
        return new IDelegatedAction(){

            public void execute() {
                WellSearchCriteria.ExperimentSearchCriteria criteriaOrNull = searchCriteriaHolder.tryGetCriteria();
                if (criteriaOrNull != null && criteriaOrNull.tryGetExperiment() != null) {
                    String experimentPermId = criteriaOrNull.tryGetExperiment().getExperimentPermId();
                    MaterialMergedSummarySection.this.showMaterialReplicaSummaryComponent(experimentPermId);
                } else {
                    IDisposableComponent allExperimentsComponent = MaterialMergedSummarySection.this.createMaterialFeaturesFromAllExperimentsComponent(criteriaOrNull);
                    MaterialMergedSummarySection.this.replaceContent(allExperimentsComponent);
                    MaterialMergedSummarySection.this.analysisProcedureChooser.updateAnalysisProcedures();
                }
            }
        };
    }

    private void showMaterialReplicaSummaryComponent(String experimentPermId) {
        this.screeningViewContext.getCommonService().getExperimentInfoByPermId(experimentPermId, (AsyncCallback)new AbstractAsyncCallback<Experiment>(this.screeningViewContext){

            protected void process(Experiment experiment) {
                IDisposableComponent viewer = MaterialMergedSummarySection.this.createMaterialReplicaSummaryComponent(experiment);
                MaterialMergedSummarySection.this.replaceContent(viewer);
                MaterialMergedSummarySection.this.analysisProcedureChooser.updateAnalysisProcedures();
            }
        });
    }

    private IDisposableComponent createMaterialFeaturesFromAllExperimentsComponent(WellSearchCriteria.ExperimentSearchCriteria criteriaOrNull) {
        WellSearchCriteria.ExperimentSearchByProjectCriteria experimentSearchCriteria = criteriaOrNull == null ? null : criteriaOrNull.tryAsSearchByProjectCriteria();
        IDisposableComponent allExperimentsComponent = MaterialFeaturesFromAllExperimentsComponent.createComponent(this.screeningViewContext, this.material, experimentSearchCriteria, this.analysisProcedureListenerHolder);
        return allExperimentsComponent;
    }

    private IDisposableComponent createMaterialReplicaSummaryComponent(Experiment experiment) {
        IDisposableComponent viewer = MaterialReplicaSummaryComponent.createViewer(this.screeningViewContext, experiment, this.material, this.restrictGlobalScopeLinkToProject, this.analysisProcedureListenerHolder);
        return viewer;
    }

    protected IDisposableComponent createDisposableContent() {
        return null;
    }

    protected void showContent() {
        super.showContent();
        this.setHeading("");
        SingleOrAllExperimentsChooser experimentsChooser = this.createExperimentChooser();
        this.getHeader().addTool((Component)experimentsChooser);
        this.analysisProcedureChooser = this.createAnalysisProcedureChooser();
        this.getHeader().addTool((Component)this.analysisProcedureChooser);
        experimentsChooser.getParent().addStyleName("force-float-left");
    }

    private SingleOrAllExperimentsChooser createExperimentChooser() {
        return new SingleOrAllExperimentsChooser(this.screeningViewContext, this.experimentSearchCriteriaHolder, this.restrictGlobalScopeLinkToProject, this.createRefreshAction(this.experimentSearchCriteriaHolder));
    }

    private AnalysisProcedureChooser createAnalysisProcedureChooser() {
        WellSearchCriteria.AnalysisProcedureCriteria initialSelection = this.initialAnalysisProcedureCriteriaOrNull == null ? WellSearchCriteria.AnalysisProcedureCriteria.createNoProcedures() : this.initialAnalysisProcedureCriteriaOrNull;
        return AnalysisProcedureChooser.createVertical(this.screeningViewContext, this.experimentSearchCriteriaHolder, initialSelection, this.createAnalysisProcedureListener(), false);
    }

    private AnalysisProcedureChooser.IAnalysisProcedureSelectionListener createAnalysisProcedureListener() {
        return new AnalysisProcedureChooser.IAnalysisProcedureSelectionListener(){

            @Override
            public void analysisProcedureSelected(WellSearchCriteria.AnalysisProcedureCriteria criteria) {
                AnalysisProcedureChooser.IAnalysisProcedureSelectionListener delegateListener = MaterialMergedSummarySection.this.analysisProcedureListenerHolder.getAnalysisProcedureListener();
                if (delegateListener != null) {
                    delegateListener.analysisProcedureSelected(criteria);
                }
            }
        };
    }
}

