/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.NotScrollableContainer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureListenerHolder;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ChannelChooserPanel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ChannelWidgetWithListener;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.DefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialReplicaFeatureSummaryGrid;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellContentDialog;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.MaterialComponentUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.PropertiesUtil;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellReplicaImage;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaterialReplicaSummaryComponent {
    private static final String LOADING_IMAGES_DICT_MSG = "Loading images...";
    private static final String REPLICATE_ABBREV_DICT_MSG = "repl.";
    private static final String NO_IMAGES_AVAILABLE_DICT_MSG = "No images available.";
    private static final int ONE_IMAGE_SIZE_FACTOR_PX = 60;
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final boolean restrictGlobalScopeLinkToProject;
    private final Experiment experiment;
    private final WellSearchCriteria.AnalysisProcedureCriteria initialAnalysisProcedureCriteriaOrNull;

    public static IDisposableComponent createViewer(IViewContext<IScreeningClientServiceAsync> screeningViewContext, Experiment experiment, Material material, boolean restrictGlobalScopeLinkToProject, AnalysisProcedureListenerHolder analysisProcedureListenerHolder) {
        return new MaterialReplicaSummaryComponent(screeningViewContext, restrictGlobalScopeLinkToProject, experiment, null).createViewer(material, analysisProcedureListenerHolder);
    }

    public static IDisposableComponent createViewer(IViewContext<IScreeningClientServiceAsync> screeningViewContext, Experiment experiment, Material material, boolean restrictGlobalScopeLinkToProject, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        return new MaterialReplicaSummaryComponent(screeningViewContext, restrictGlobalScopeLinkToProject, experiment, analysisProcedureCriteria).createViewer(material);
    }

    private MaterialReplicaSummaryComponent(IViewContext<IScreeningClientServiceAsync> screeningViewContext, boolean restrictGlobalScopeLinkToProject, Experiment experiment, WellSearchCriteria.AnalysisProcedureCriteria initialAnalysisProcedureCriteriaOrNull) {
        this.screeningViewContext = screeningViewContext;
        this.restrictGlobalScopeLinkToProject = restrictGlobalScopeLinkToProject;
        this.experiment = experiment;
        this.initialAnalysisProcedureCriteriaOrNull = initialAnalysisProcedureCriteriaOrNull;
    }

    private static RowData createImagePanelLayoutData() {
        return new RowData(-1.0, -1.0, new Margins(10, 0, 10, 10));
    }

    private Widget createImagePanel(List<WellReplicaImage> images) {
        if (images.isEmpty()) {
            return new Text(NO_IMAGES_AVAILABLE_DICT_MSG);
        }
        String displayTypeId = ScreeningDisplayTypeIDGenerator.EXPERIMENT_CHANNEL.createID(null);
        DefaultChannelState defaultChannelState = new DefaultChannelState(this.screeningViewContext, displayTypeId);
        ChannelChooserPanel channelChooser = new ChannelChooserPanel((IMessageProvider)this.screeningViewContext, defaultChannelState);
        NotScrollableContainer panel = new NotScrollableContainer();
        panel.setLayout((Layout)new RowLayout());
        panel.add((Widget)channelChooser);
        Map<String, List<WellReplicaImage>> labelToReplicasMap = MaterialReplicaSummaryComponent.createSortedImageMap(images);
        Object orphanGroupKey = null;
        List<WellReplicaImage> orphanTechnicalReplicates = labelToReplicasMap.get(orphanGroupKey);
        if (orphanTechnicalReplicates != null) {
            Widget technicalReplicatesPanel = this.createOrphanTechnicalReplicatesPanel(orphanTechnicalReplicates, channelChooser);
            panel.add(technicalReplicatesPanel);
            labelToReplicasMap.remove(orphanGroupKey);
        }
        LayoutContainer biologicalReplicatesImagesPanel = this.createBiologicalReplicatesImagesPanel(labelToReplicasMap, channelChooser);
        panel.add((Widget)biologicalReplicatesImagesPanel);
        return panel;
    }

    private Widget createOrphanTechnicalReplicatesPanel(List<WellReplicaImage> orphanTechnicalReplicates, ChannelChooserPanel channelChooser) {
        LayoutContainer imagePanel = new LayoutContainer();
        boolean shouldDisplayLabels = orphanTechnicalReplicates.size() > 1;
        int oneImageSizeFactorPx = this.getOneImageSizeFactorPx(1);
        for (WellReplicaImage image : orphanTechnicalReplicates) {
            LayoutContainer imageWithLabel = new LayoutContainer();
            imageWithLabel.setLayout((Layout)new RowLayout());
            if (shouldDisplayLabels) {
                Widget label = this.createTechnicalReplicateLabel(image.getTechnicalReplicateSequenceNumber());
                imageWithLabel.add(label);
            }
            Widget imageViewer = this.createImageViewer(image.getWellImage(), channelChooser, oneImageSizeFactorPx);
            imageWithLabel.add(imageViewer);
            imagePanel.add((Widget)imageWithLabel);
        }
        return imagePanel;
    }

    private LayoutContainer createBiologicalReplicatesImagesPanel(Map<String, List<WellReplicaImage>> labelToReplicasMap, ChannelChooserPanel channelChooser) {
        LayoutContainer imagePanel = new LayoutContainer();
        int maxReplicaNumber = MaterialReplicaSummaryComponent.calcMaxReplicaNumber(labelToReplicasMap);
        if (maxReplicaNumber == 0) {
            return imagePanel;
        }
        TableLayout layout = new TableLayout(maxReplicaNumber + 1);
        layout.setBorder(1);
        layout.setCellPadding(5);
        imagePanel.setLayout((Layout)layout);
        this.addImageTableHeader(maxReplicaNumber, imagePanel);
        List<String> sortedLabels = MaterialReplicaSummaryComponent.sortCopy(labelToReplicasMap.keySet());
        for (String label : sortedLabels) {
            List<WellReplicaImage> sortedTechnicalReplicates = labelToReplicasMap.get(label);
            imagePanel.add((Widget)new Text(label));
            for (int i = 0; i < maxReplicaNumber; ++i) {
                if (i < sortedTechnicalReplicates.size()) {
                    WellContent wellImage = sortedTechnicalReplicates.get(i).getWellImage();
                    Widget imageViewer = this.createImageViewer(wellImage, channelChooser, this.getOneImageSizeFactorPx(maxReplicaNumber));
                    imagePanel.add(imageViewer);
                    continue;
                }
                imagePanel.add(this.createEmptyBox());
            }
        }
        return imagePanel;
    }

    private int getOneImageSizeFactorPx(int maxReplicaNumber) {
        double columnFactor = 1.0 + 0.25 * (double)(3 - maxReplicaNumber);
        columnFactor = Math.max(columnFactor, 0.75);
        return Math.max(64, (int)(60.0 * columnFactor));
    }

    private static List<String> sortCopy(Set<String> values) {
        ArrayList<String> sorted = new ArrayList<String>(values);
        Collections.sort(sorted);
        return sorted;
    }

    private void addImageTableHeader(int maxReplicaNumber, LayoutContainer imagePanel) {
        for (int i = 0; i <= maxReplicaNumber; ++i) {
            if (i == 0) {
                imagePanel.add(this.createEmptyBox());
                continue;
            }
            imagePanel.add(this.createTechnicalReplicateLabel(i));
        }
    }

    private Widget createTechnicalReplicateLabel(int technicalReplicateSequence) {
        return new Text("repl. " + technicalReplicateSequence);
    }

    private Widget createEmptyBox() {
        return new Text();
    }

    private static int calcMaxReplicaNumber(Map<String, List<WellReplicaImage>> labelToReplicasMap) {
        int max = 0;
        for (List<WellReplicaImage> technicalReplicates : labelToReplicasMap.values()) {
            max = Math.max(max, technicalReplicates.size());
        }
        return max;
    }

    private static Map<String, List<WellReplicaImage>> createSortedImageMap(List<WellReplicaImage> images) {
        HashMap<String, List<WellReplicaImage>> map = new HashMap<String, List<WellReplicaImage>>();
        for (WellReplicaImage image : images) {
            String label = image.tryGetBiologicalReplicateLabel();
            ArrayList<WellReplicaImage> technicalReplicas = (ArrayList<WellReplicaImage>)map.get(label);
            if (technicalReplicas == null) {
                technicalReplicas = new ArrayList<WellReplicaImage>();
            }
            technicalReplicas.add(image);
            map.put(label, technicalReplicas);
        }
        MaterialReplicaSummaryComponent.sortTechnicalReplicas(map);
        return map;
    }

    private static void sortTechnicalReplicas(Map<String, List<WellReplicaImage>> map) {
        for (List<WellReplicaImage> technicalReplicas : map.values()) {
            Collections.sort(technicalReplicas, new Comparator<WellReplicaImage>(){

                @Override
                public int compare(WellReplicaImage arg1, WellReplicaImage arg2) {
                    Integer s1 = arg1.getTechnicalReplicateSequenceNumber();
                    Integer s2 = arg2.getTechnicalReplicateSequenceNumber();
                    return s1.compareTo(s2);
                }
            });
        }
    }

    private Widget createImageViewer(final WellContent image, ChannelChooserPanel channelChooser, final int oneImageSizeFactorPx) {
        assert (image.tryGetImageDataset() != null);
        ChannelWidgetWithListener.ISimpleChanneledViewerFactory viewerFactory = new ChannelWidgetWithListener.ISimpleChanneledViewerFactory(){

            @Override
            public Widget create(List<String> channels, String imageTransformationCodeOrNull, Map<String, IntensityRange> rangesOrNull) {
                return WellContentDialog.createImageViewerForChannel((IViewContext<IScreeningClientServiceAsync>)MaterialReplicaSummaryComponent.this.screeningViewContext, image, oneImageSizeFactorPx, channels, imageTransformationCodeOrNull, rangesOrNull);
            }
        };
        ChannelWidgetWithListener widgetWithListener = new ChannelWidgetWithListener(viewerFactory);
        widgetWithListener.selectionChanged(channelChooser.getSelectedValues(), channelChooser.tryGetSelectedTransformationCode(false), channelChooser.tryGetSelectedIntensityRanges());
        ImageDatasetParameters imageParameters = image.tryGetImageDataset().getImageParameters();
        channelChooser.addSelectionChangedListener(widgetWithListener);
        channelChooser.addChannels(imageParameters);
        return widgetWithListener.asWidget();
    }

    private IDisposableComponent createViewer(Material material) {
        IDisposableComponent gridComponent = MaterialReplicaFeatureSummaryGrid.createForEmbeddedMode(this.screeningViewContext, new TechId((IIdAndCodeHolder)this.experiment), new TechId((IIdAndCodeHolder)material), this.initialAnalysisProcedureCriteriaOrNull);
        return this.createViewer(material, gridComponent);
    }

    private IDisposableComponent createViewer(Material material, AnalysisProcedureListenerHolder analysisProcedureListenerHolderOrNull) {
        IDisposableComponent gridComponent = MaterialReplicaFeatureSummaryGrid.create(this.screeningViewContext, new TechId((IIdAndCodeHolder)this.experiment), new TechId((IIdAndCodeHolder)material), analysisProcedureListenerHolderOrNull);
        return this.createViewer(material, gridComponent);
    }

    private IDisposableComponent createViewer(Material material, final IDisposableComponent gridComponent) {
        final LayoutContainer panel = new LayoutContainer();
        panel.setLayout((Layout)new RowLayout(Style.Orientation.VERTICAL));
        panel.setScrollMode(Style.Scroll.AUTO);
        Widget materialInfo = this.createMaterialInfo(material);
        panel.add(materialInfo, (LayoutData)new RowData(-1.0, -1.0, PropertiesUtil.createHeaderInfoMargin()));
        TechId materialTechId = new TechId((IIdAndCodeHolder)material);
        TechId experimentTechId = new TechId((IIdAndCodeHolder)this.experiment);
        panel.add((Widget)gridComponent.getComponent(), (LayoutData)new RowData(0.97, 400.0));
        NotScrollableContainer imagesPanel = new NotScrollableContainer();
        imagesPanel.setLayout((Layout)new RowLayout());
        imagesPanel.add((Widget)new Text(LOADING_IMAGES_DICT_MSG), (LayoutData)MaterialReplicaSummaryComponent.createImagePanelLayoutData());
        panel.add((Widget)imagesPanel);
        ((IScreeningClientServiceAsync)this.screeningViewContext.getService()).listWellImages(materialTechId, experimentTechId, (AsyncCallback<List<WellReplicaImage>>)new ImagesFoundCallback((LayoutContainer)imagesPanel));
        return new IDisposableComponent(){

            public void update(Set<DatabaseModificationKind> observedModifications) {
            }

            public DatabaseModificationKind[] getRelevantModifications() {
                return new DatabaseModificationKind[0];
            }

            public Component getComponent() {
                return panel;
            }

            public void dispose() {
                gridComponent.dispose();
            }
        };
    }

    private Widget createMaterialInfo(Material material) {
        LayoutContainer panel = new LayoutContainer();
        panel.setLayout((Layout)new RowLayout());
        Widget headerWidget = this.createHeaderWithLinks(material);
        panel.add(headerWidget, (LayoutData)PropertiesUtil.createHeaderTitleLayoutData());
        LayoutContainer materialPropertiesPanel = MaterialReplicaSummaryComponent.createMaterialPropertiesPanel(material);
        panel.add((Widget)materialPropertiesPanel);
        return panel;
    }

    private Widget createHeaderWithLinks(Material material) {
        LayoutContainer headerPanel = new LayoutContainer();
        headerPanel.setLayout((Layout)new TableLayout(2));
        Html headingWidget = MaterialReplicaSummaryComponent.createHeaderTitle((IEntityInformationHolderWithPermId)this.experiment, material, this.screeningViewContext);
        headerPanel.add((Widget)headingWidget);
        LayoutContainer rightLinksPanel = new LayoutContainer();
        rightLinksPanel.setLayout((Layout)new RowLayout());
        RowData linkMargins = new RowData(-1.0, -1.0, new Margins(0, 0, 0, 50));
        if (this.screeningViewContext.getModel().isEmbeddedMode() && this.initialAnalysisProcedureCriteriaOrNull != null) {
            Widget materialInAllAssaysSummaryLink = this.createMaterialInAllAssaysSummaryLink(material, this.initialAnalysisProcedureCriteriaOrNull);
            rightLinksPanel.add(materialInAllAssaysSummaryLink, (LayoutData)linkMargins);
        }
        Widget assayAnalysisSummaryLink = this.createAssayAnalysisSummaryLink(material);
        rightLinksPanel.add(assayAnalysisSummaryLink, (LayoutData)linkMargins);
        headerPanel.add((Widget)rightLinksPanel);
        return headerPanel;
    }

    private Widget createMaterialInAllAssaysSummaryLink(final Material material, final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        final WellSearchCriteria.ExperimentSearchCriteria experimentCriteria = this.createAllAssaysExperimentCriteria();
        String linkUrl = ScreeningLinkExtractor.createMaterialDetailsLink((IEntityInformationHolder)material, experimentCriteria);
        String linkText = this.screeningViewContext.getMessage("FIND_IN_ALL_ASSAYS", new Object[]{MaterialComponentUtils.getMaterialFullName(material, false)});
        Widget linkWidget = LinkRenderer.getLinkWidget((String)linkText, (ClickHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ClientPluginFactory.openImagingMaterialViewer((IEntityInformationHolderWithPermId)material, experimentCriteria, analysisProcedureCriteria, false, (IViewContext<IScreeningClientServiceAsync>)MaterialReplicaSummaryComponent.this.screeningViewContext);
            }
        }, (String)linkUrl);
        return linkWidget;
    }

    private WellSearchCriteria.ExperimentSearchCriteria createAllAssaysExperimentCriteria() {
        if (this.restrictGlobalScopeLinkToProject) {
            Project project = this.experiment.getProject();
            BasicProjectIdentifier projectIdentifier = new BasicProjectIdentifier(project.getSpace().getCode(), project.getCode());
            return WellSearchCriteria.ExperimentSearchCriteria.createAllExperimentsForProject(projectIdentifier);
        }
        return WellSearchCriteria.ExperimentSearchCriteria.createAllExperiments();
    }

    private static Html createHeaderTitle(IEntityInformationHolderWithPermId experiment, Material material, IViewContext<IScreeningClientServiceAsync> screeningViewContext) {
        String materialDesc = MaterialComponentUtils.getMaterialFullName(material, true);
        String headingText = screeningViewContext.getMessage("MATERIAL_IN_ASSAY", new Object[]{materialDesc, experiment.getCode()});
        return PropertiesUtil.createHeaderTitle(headingText);
    }

    private Widget createAssayAnalysisSummaryLink(Material material) {
        String linkUrl = ClientPluginFactory.createImagingExperimentViewerLink((IEntityInformationHolderWithPermId)this.experiment, this.restrictGlobalScopeLinkToProject, this.screeningViewContext);
        String linkText = this.screeningViewContext.getMessage("SHOW_ASSAY", new Object[]{this.experiment.getCode()});
        Widget linkWidget = LinkRenderer.getLinkWidget((String)linkText, (ClickHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ClientPluginFactory.openImagingExperimentViewer((IEntityInformationHolderWithPermId)MaterialReplicaSummaryComponent.this.experiment, MaterialReplicaSummaryComponent.this.restrictGlobalScopeLinkToProject, (IViewContext<IScreeningClientServiceAsync>)MaterialReplicaSummaryComponent.this.screeningViewContext);
            }
        }, (String)linkUrl);
        return linkWidget;
    }

    private static LayoutContainer createMaterialPropertiesPanel(Material material) {
        LayoutContainer propertiesPanel = new LayoutContainer();
        propertiesPanel.setLayout((Layout)new RowLayout());
        PropertiesUtil.addProperties((IEntityInformationHolderWithProperties)material, propertiesPanel, MaterialComponentUtils.createAdditionalMaterialProperties((IEntityInformationHolderWithProperties)material), MaterialComponentUtils.getExcludedMatrialProperties());
        return propertiesPanel;
    }

    private class ImagesFoundCallback
    extends AbstractAsyncCallback<List<WellReplicaImage>> {
        private final LayoutContainer imagesPanel;

        ImagesFoundCallback(LayoutContainer imagesPanel) {
            super(MaterialReplicaSummaryComponent.this.screeningViewContext);
            this.imagesPanel = imagesPanel;
        }

        protected void process(List<WellReplicaImage> images) {
            this.imagesPanel.removeAll();
            this.imagesPanel.add(MaterialReplicaSummaryComponent.this.createImagePanel(images), (LayoutData)MaterialReplicaSummaryComponent.createImagePanelLayoutData());
            this.imagesPanel.layout();
        }
    }
}

