/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImagingDatasetGuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.PlateMetadataBrowser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.LayoutUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.PlateLayouter;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateMetadata;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class PlateLayoutSampleSection
extends TabContent {
    private static final String PLATE_METADATA_REPORT_LABEL = "Plate Metadata Report: ";
    private final TechId sampleId;

    public PlateLayoutSampleSection(ScreeningViewContext viewContext, TechId sampleId) {
        super("Plate Layout", (IViewContext)viewContext, (IIdHolder)sampleId);
        this.sampleId = sampleId;
        this.setIds(DisplayTypeIDGenerator.PLATE_LAYOUT_SAMPLE_SECTION);
    }

    private ScreeningViewContext getViewContext() {
        return (ScreeningViewContext)this.viewContext;
    }

    protected void showContent() {
        ScreeningViewContext context = this.getViewContext();
        this.add((Component)new Text(context.getMessage("load_in_progress", new Object[0])));
        ((IScreeningClientServiceAsync)context.getService()).getPlateContent(this.sampleId, this.createDisplayPlateCallback());
    }

    private AsyncCallback<PlateContent> createDisplayPlateCallback() {
        return new AbstractAsyncCallback<PlateContent>((IViewContext)this.getViewContext()){

            protected void process(PlateContent plateContent) {
                PlateLayoutSampleSection.this.removeAll();
                PlateLayoutSampleSection.this.setLayout((Layout)new RowLayout());
                PlateLayoutSampleSection.this.setScrollMode(Style.Scroll.AUTO);
                PlateLayoutSampleSection.this.addPlateVisualisation(plateContent);
                PlateLayoutSampleSection.this.addPlateMetadataReportLink(plateContent);
                PlateLayoutSampleSection.this.addUnknownDatasetLinks(plateContent);
                PlateLayoutSampleSection.this.layout();
            }
        };
    }

    private void addUnknownDatasetLinks(PlateContent plateContent) {
        ImagingDatasetGuiUtils guiUtils = new ImagingDatasetGuiUtils((IViewContext<?>)this.getViewContext());
        Widget w = guiUtils.tryCreateUnknownDatasetsLinks(plateContent.getUnknownDatasets());
        if (w != null) {
            this.add(w, (LayoutData)LayoutUtils.createRowLayoutSurroundingData());
        }
    }

    private void addPlateVisualisation(PlateContent plateContent) {
        PlateMetadata plateMetadata = plateContent.getPlateMetadata();
        PlateLayouter plateLayouter = new PlateLayouter(this.getViewContext(), plateMetadata);
        List<ImageDatasetEnrichedReference> imageDatasets = plateContent.getImageDatasets();
        ImagingDatasetGuiUtils guiUtils = new ImagingDatasetGuiUtils((IViewContext<?>)this.getViewContext());
        Widget imageDatasetDetailsRow = guiUtils.createImageDatasetDetailsRow(imageDatasets, PlateLayoutSampleSection.asImageDatasetUpdater(plateLayouter));
        Widget featureVectorDatasetDatailsRow = guiUtils.createFeatureVectorDatasetDetailsRow(plateContent.getFeatureVectorDatasets(), this.asFeatureVectorDatasetUpdater(plateLayouter));
        Widget plateLayout = plateLayouter.getView();
        boolean manyImageDatasets = imageDatasets.size() > 1;
        boolean manyFeatureVectorDatasets = plateContent.getFeatureVectorDatasets().size() > 1;
        this.layoutComponents(plateLayout, imageDatasetDetailsRow, manyImageDatasets, featureVectorDatasetDatailsRow, manyFeatureVectorDatasets);
    }

    private ImagingDatasetGuiUtils.IFeatureVectorDatasetReferenceUpdater asFeatureVectorDatasetUpdater(final PlateLayouter plateLayouter) {
        return new ImagingDatasetGuiUtils.IFeatureVectorDatasetReferenceUpdater(){

            @Override
            public void changeDisplayedFeatureVectorDataset(FeatureVectorDataset dataset) {
                plateLayouter.changeDisplayedFeatureVectorDataset(dataset);
            }

            @Override
            public void changeDisplayedFeatureVectorDataset(ScreeningViewContext context, DatasetReference dataset) {
                plateLayouter.changeDisplayedFeatureVectorDataset(context, dataset);
            }
        };
    }

    private static ImagingDatasetGuiUtils.IDatasetImagesReferenceUpdater asImageDatasetUpdater(final PlateLayouter plateLayouter) {
        return new ImagingDatasetGuiUtils.IDatasetImagesReferenceUpdater(){

            @Override
            public void changeDisplayedImageDataset(ImageDatasetEnrichedReference newImageDatasetOrNull) {
                plateLayouter.changeDisplayedImageDataset(newImageDatasetOrNull);
            }
        };
    }

    private void layoutComponents(Widget plateLayout, Widget imageDatasetDetailsRow, boolean manyImageDatasets, Widget featureVectorDatasetDatailsRow, boolean manyFeatureVectorDatasets) {
        RowData margin = LayoutUtils.createRowLayoutSurroundingData();
        if (manyImageDatasets) {
            this.add(imageDatasetDetailsRow, (LayoutData)margin);
        }
        if (manyFeatureVectorDatasets) {
            this.add(featureVectorDatasetDatailsRow, (LayoutData)margin);
        }
        this.add(plateLayout, (LayoutData)margin);
        if (!manyImageDatasets) {
            this.add(imageDatasetDetailsRow, (LayoutData)margin);
        }
        if (!manyFeatureVectorDatasets) {
            this.add(featureVectorDatasetDatailsRow, (LayoutData)margin);
        }
    }

    private void addPlateMetadataReportLink(PlateContent plateContent) {
        Sample plate = plateContent.getPlateMetadata().getPlate();
        Widget generateLink = PlateLayoutSampleSection.createPlateMetadataLink(plate, (IViewContext<IScreeningClientServiceAsync>)this.getViewContext());
        this.add(ImagingDatasetGuiUtils.withLabel(generateLink, PLATE_METADATA_REPORT_LABEL), (LayoutData)LayoutUtils.createRowLayoutSurroundingData());
    }

    private static Widget createPlateMetadataLink(final Sample plate, final IViewContext<IScreeningClientServiceAsync> viewContext) {
        String plateLinkUrl = ScreeningLinkExtractor.createPlateMetadataBrowserLink(plate.getPermId());
        return LinkRenderer.getLinkWidget((String)viewContext.getMessage("button_show", new Object[0]), (ClickHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlateMetadataBrowser.openTab((IEntityInformationHolderWithPermId)plate, (IViewContext<IScreeningClientServiceAsync>)viewContext);
            }
        }, (String)plateLinkUrl);
    }
}

