/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.PlateLayoutSampleSection;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;

public final class PlateSampleViewer
extends GenericSampleViewer {
    private final ScreeningViewContext screeningViewContext;

    public static DatabaseModificationAwareComponent create(ScreeningViewContext viewContext, IIdAndCodeHolder identifiable) {
        PlateSampleViewer viewer = new PlateSampleViewer(viewContext, identifiable);
        viewer.reloadAllData();
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    public PlateSampleViewer(ScreeningViewContext viewContext, IIdAndCodeHolder identifiable) {
        super((IViewContext)viewContext, identifiable);
        this.screeningViewContext = viewContext;
    }

    protected void loadSampleGenerationInfo(TechId sampleTechId, AsyncCallback<SampleParentWithDerived> asyncCallback) {
        ((IScreeningClientServiceAsync)this.screeningViewContext.getService()).getSampleGenerationInfo(sampleTechId, asyncCallback);
    }

    protected List<TabContent> createAdditionalSectionPanels() {
        ArrayList<TabContent> sections = new ArrayList<TabContent>();
        sections.add(new PlateLayoutSampleSection(this.screeningViewContext, this.sampleId));
        return sections;
    }

    protected String getOriginalDataDescription() {
        return this.screeningViewContext.getMessage("PLATE_VIEWER_TITLE", new Object[]{((Sample)this.originalData).getCode()});
    }

    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_plate", new Object[0]);
    }
}

