/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleModelComboBox;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class ResolutionChooser
extends LayoutContainer {
    private SimpleModelComboBox<ImageResolution> comboBox;

    public ResolutionChooser(IViewContext<IScreeningClientServiceAsync> viewContext, List<ImageResolution> incomingResolutions, ImageResolution defaultResolution) {
        List<ImageResolution> resolutions = this.prepareResolutions(incomingResolutions);
        ArrayList<LabeledItem> items = new ArrayList<LabeledItem>();
        if (resolutions.isEmpty()) {
            items.add(new LabeledItem(null, viewContext.getMessage("RESOLUTION_CHOOSER_DEFAULT", new Object[0])));
        } else {
            for (ImageResolution resolution : resolutions) {
                String resolutionText = viewContext.getMessage("RESOLUTION_CHOOSER_RESOLUTION", new Object[]{resolution.getWidth(), resolution.getHeight()});
                items.add(new LabeledItem((Object)resolution, resolutionText));
            }
        }
        this.comboBox = new SimpleModelComboBox(viewContext, items, null);
        LabeledItem defaultResolutionItem = this.comboBox.findModelForVal((Object)defaultResolution);
        if (defaultResolutionItem != null) {
            this.comboBox.setSelection(defaultResolutionItem);
        } else if (!items.isEmpty()) {
            this.comboBox.setSelection((LabeledItem)items.get(0));
        }
        this.add((Component)this.comboBox);
    }

    private List<ImageResolution> prepareResolutions(List<ImageResolution> resolutions) {
        TreeSet<ImageResolution> allResolutions = new TreeSet<ImageResolution>(resolutions);
        this.maybeAddThumbnailResolution(allResolutions);
        return new ArrayList<ImageResolution>(allResolutions);
    }

    private void maybeAddThumbnailResolution(Collection<ImageResolution> resolutions) {
        boolean hasThumbnails = false;
        for (ImageResolution resolution : resolutions) {
            if (resolution.isOriginal()) continue;
            hasThumbnails = true;
            break;
        }
        if (!hasThumbnails) {
            ImageResolution originalResolution = null;
            for (ImageResolution resolution : resolutions) {
                if (!resolution.isOriginal()) continue;
                originalResolution = resolution;
                break;
            }
            if (originalResolution != null) {
                resolutions.add(new ImageResolution(Math.round(originalResolution.getWidth() / 4), Math.round(originalResolution.getHeight() / 4), false));
            }
        }
    }

    public ImageResolution getResolution() {
        return (ImageResolution)this.comboBox.tryGetChosenItem();
    }

    public void addResolutionChangedListener(Listener<BaseEvent> listener) {
        this.comboBox.addListener(Events.SelectionChange, listener);
    }
}

