/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IntegerField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.IDefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserDefinedRescalingSettingsDialog
extends Dialog {
    private final List<SingleChannelIntesityRange> intensitiesPerChannel;
    private final IMessageProvider messageProvider;
    private final IDefaultChannelState defaultChannelState;
    private final List<LabeledItem<String>> channelCodes;

    public UserDefinedRescalingSettingsDialog(IMessageProvider messageProvider, Map<String, IntensityRange> intensitiesPerChannel, IDefaultChannelState defaultChannelState, List<LabeledItem<String>> channelCodes) {
        this.messageProvider = messageProvider;
        this.defaultChannelState = defaultChannelState;
        this.channelCodes = channelCodes;
        this.setHeading(this.messageProvider.getMessage("TITLE_USER_DEFINED_RESCALING_DIALOG", new Object[0]));
        this.setButtons("okcancel");
        this.intensitiesPerChannel = new ArrayList<SingleChannelIntesityRange>(channelCodes.size());
        for (LabeledItem<String> channelCode : channelCodes) {
            this.intensitiesPerChannel.add(new SingleChannelIntesityRange(messageProvider, channelCode));
        }
        this.setInitialValues(intensitiesPerChannel);
        Grid grid = new Grid(channelCodes.size() * 2, 2);
        int counter = 0;
        for (SingleChannelIntesityRange scir : this.intensitiesPerChannel) {
            grid.setWidget(2 * counter, 0, (Widget)scir.labelMax);
            grid.setWidget(2 * counter, 1, (Widget)scir.maxTextField);
            grid.setWidget(2 * counter + 1, 0, (Widget)scir.labelMin);
            grid.setWidget(2 * counter + 1, 1, (Widget)scir.minTextField);
            ++counter;
        }
        this.add((Widget)grid);
        this.setAutoWidth(true);
        this.setAutoHeight(true);
        this.addListener(Events.Show, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                UserDefinedRescalingSettingsDialog.this.center();
            }
        });
    }

    private void setInitialValues(Map<String, IntensityRange> intensitiesPerChannel) {
        for (SingleChannelIntesityRange scir : this.intensitiesPerChannel) {
            scir.minTextField.setValue((Object)0);
            scir.maxTextField.setValue((Object)255);
            IntensityRange range = intensitiesPerChannel.get(scir.channelCode.getItem());
            if (range == null) continue;
            scir.minTextField.setValue((Object)range.getBlackPoint());
            scir.maxTextField.setValue((Object)range.getWhitePoint());
        }
    }

    protected final void onButtonPressed(Button button) {
        if (button.getItemId().equals("ok")) {
            button.disable();
            if (this.areIntensitiesValid()) {
                super.onButtonPressed(button);
                this.updateIntensityRescaling();
                this.fireEvent(Events.OnChange);
                this.hide();
            } else {
                button.enable();
            }
        } else {
            super.onButtonPressed(button);
            this.hide();
        }
    }

    private boolean areIntensitiesValid() {
        for (SingleChannelIntesityRange scir : this.intensitiesPerChannel) {
            if (scir.minTextField.isValid() && scir.maxTextField.isValid()) continue;
            return false;
        }
        return true;
    }

    public void updateIntensityRescaling() {
        HashMap<String, IntensityRange> result = new HashMap<String, IntensityRange>();
        try {
            for (SingleChannelIntesityRange singleChannelIntesityRange : this.intensitiesPerChannel) {
                int min = Integer.parseInt(((Number)singleChannelIntesityRange.minTextField.getValue()).toString());
                int max = Integer.parseInt(((Number)singleChannelIntesityRange.maxTextField.getValue()).toString());
                result.put((String)singleChannelIntesityRange.channelCode.getItem(), new IntensityRange(min, max));
            }
            for (LabeledItem labeledItem : this.channelCodes) {
                this.defaultChannelState.setIntensityRange((String)labeledItem.getItem(), (IntensityRange)result.get(labeledItem.getItem()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static class SingleChannelIntesityRange {
        private final LabeledItem<String> channelCode;
        private final Label labelMin;
        private final Label labelMax;
        private final IntegerField minTextField;
        private final IntegerField maxTextField;

        public SingleChannelIntesityRange(IMessageProvider messageProvider, LabeledItem<String> channelCode) {
            this.channelCode = channelCode;
            this.labelMin = new Label(messageProvider.getMessage("RESCALING_DIALOG_MIN", new Object[]{channelCode.getLabel()}));
            this.labelMax = new Label(messageProvider.getMessage("RESCALING_DIALOG_MAX", new Object[]{channelCode.getLabel()}));
            this.minTextField = new IntegerField(messageProvider.getMessage("RESCALING_DIALOG_MIN", new Object[]{channelCode}), true);
            this.maxTextField = new IntegerField(messageProvider.getMessage("RESCALING_DIALOG_MAX", new Object[]{channelCode}), true);
        }
    }
}

