/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabClickListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImageDialog;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageClickHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageRefreshHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.TileContentDialog;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageChannelsReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.WellData;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.PlateUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.TileLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellImage;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.layout.HBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WellContentDialog
extends ImageDialog {
    private static final String UNKNOWN_CHANNEL_LABEL = "No images available for this channel.";
    private static final String INCORRECT_WELL_CODE_LABEL = "Incorrect well code.";
    private static final String NO_IMAGE_DATASETS_LABEL = "Images not acquired.";
    private static final String WELL_LABEL = "Well: ";
    private final IEntityInformationHolderWithPermId wellOrNull;
    private final WellLocation wellLocationOrNull;
    private final List<IEntityProperty> wellPropertiesOrNull;
    private final WellSearchCriteria.SingleExperimentSearchCriteria experimentCriteria;
    private final IEntityInformationHolderWithPermId plate;
    private final IViewContext<IScreeningClientServiceAsync> viewContext;
    private ImageDatasetEnrichedReference imageDatasetOrNull;

    public static void showContentDialog(WellData wellData, Sample plateSample, ImageDatasetEnrichedReference imageDatasetOrNull, IViewContext<IScreeningClientServiceAsync> viewContext) {
        WellContentDialog contentDialog = WellContentDialog.createContentDialog(wellData, plateSample, imageDatasetOrNull, viewContext);
        WellContentDialog.showContentDialog(contentDialog, viewContext);
    }

    private static void showContentDialog(final WellContentDialog contentDialog, IViewContext<IScreeningClientServiceAsync> viewContext) {
        if (contentDialog.tryGetImages() != null) {
            LogicalImageViewer viewer = contentDialog.createImageViewer();
            final Grid grid = new Grid(1, 1);
            grid.setWidget(0, 0, viewer.getViewerWidget("WellContentDialog"));
            contentDialog.add((Widget)grid);
            viewer.setLogicalImageRefreshHandler(new LogicalImageRefreshHandler(){

                @Override
                public void onRefresh() {
                    WindowUtils.resize((Window)contentDialog, (Element)grid.getElement());
                }
            });
            viewer.setLogicalImageClickHandler(new LogicalImageClickHandler(){

                @Override
                public void onClick(LogicalImageChannelsReference channelReferences, int row, int col) {
                    TileLocation tileLocation = new TileLocation(row, col);
                    String experimentIdentifier = contentDialog.experimentCriteria.getExperimentIdentifier();
                    String experimentPermId = contentDialog.experimentCriteria.getExperimentPermId();
                    new TileContentDialog((IViewContext<IScreeningClientServiceAsync>)contentDialog.viewContext, contentDialog.imageDatasetOrNull, contentDialog.wellLocationOrNull, tileLocation, experimentIdentifier, experimentPermId).show();
                }
            });
            contentDialog.addImageEditorLaunchButton(viewer);
        }
        contentDialog.show();
    }

    private static WellContentDialog createContentDialog(WellData wellData, Sample plateSample, ImageDatasetEnrichedReference imageDatasetOrNull, IViewContext<IScreeningClientServiceAsync> viewContext) {
        WellLocation wellLocation = wellData.getWellLocation();
        WellMetadata wellMetadata = wellData.tryGetMetadata();
        Sample wellOrNull = null;
        List wellPropertiesOrNull = null;
        if (wellMetadata != null) {
            wellOrNull = wellMetadata.getWellSample();
            wellPropertiesOrNull = wellMetadata.getWellSample().getProperties();
        }
        return new WellContentDialog((IEntityInformationHolderWithPermId)wellOrNull, wellPropertiesOrNull, wellLocation, WellContentDialog.getExperiment(wellData), (IEntityInformationHolderWithPermId)plateSample, imageDatasetOrNull, viewContext);
    }

    public static Widget createImageViewerForChannel(final IViewContext<IScreeningClientServiceAsync> viewContext, final WellContent wellImage, int imageSizePx, List<String> channels, String imageTransformationCodeOrNull, Map<String, IntensityRange> rangesOrNull) {
        final ImageDatasetEnrichedReference imageDataset = WellContentDialog.tryGetImageDataset(wellImage);
        if (imageDataset == null) {
            return new Text(NO_IMAGE_DATASETS_LABEL);
        }
        WellLocation locationOrNull = wellImage.tryGetLocation();
        if (locationOrNull == null) {
            return new Text(INCORRECT_WELL_CODE_LABEL);
        }
        ImageDatasetParameters imageParameters = imageDataset.getImageDatasetParameters();
        if (!imageParameters.getChannelsCodes().containsAll(channels) && !channels.contains("Merged Channels")) {
            return new Text(UNKNOWN_CHANNEL_LABEL);
        }
        LogicalImageClickHandler clickHandler = null;
        if (imageParameters.isMultidimensional()) {
            new LogicalImageClickHandler(){

                @Override
                public void onClick(LogicalImageChannelsReference channelReferences, int row, int col) {
                }
            };
        }
        String sessionId = WellContentDialog.getSessionId(viewContext);
        LogicalImageReference wellImages = new LogicalImageReference(imageDataset, locationOrNull);
        LogicalImageChannelsReference channelReferences = LogicalImageChannelsReference.createWithoutOverlays(wellImages, channels, imageTransformationCodeOrNull, rangesOrNull);
        LayoutContainer staticTilesGrid = LogicalImageViewer.createTilesGrid(channelReferences, sessionId, imageSizePx, clickHandler, null);
        if (imageParameters.isMultidimensional()) {
            staticTilesGrid.sinkEvents(Events.OnClick.getEventCode());
            staticTilesGrid.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    WellContentDialog.showContentDialog((IViewContext<IScreeningClientServiceAsync>)viewContext, wellImage, (IEntityInformationHolderWithPermId)wellImage.getPlate(), imageDataset);
                }
            });
        }
        return staticTilesGrid;
    }

    private static ImageDatasetEnrichedReference tryGetImageDataset(WellImage wellImage) {
        if (wellImage.tryGetImageDataset() != null) {
            return new ImageDatasetEnrichedReference(wellImage.tryGetImageDataset());
        }
        return null;
    }

    private static void showContentDialog(IViewContext<IScreeningClientServiceAsync> viewContext, WellImage wellImage, IEntityInformationHolderWithPermId plate, ImageDatasetEnrichedReference imageDatasetOrNull) {
        WellContentDialog contentDialog = new WellContentDialog((IEntityInformationHolderWithPermId)wellImage.getWell(), null, wellImage.tryGetLocation(), WellContentDialog.getExperiment(wellImage.getExperiment()), plate, imageDatasetOrNull, viewContext);
        WellContentDialog.showContentDialog(contentDialog, viewContext);
    }

    private LogicalImageViewer createImageViewer() {
        LogicalImageReference imagesOrNull = new LogicalImageReference(this.imageDatasetOrNull, this.wellLocationOrNull);
        return new LogicalImageViewer(imagesOrNull, this.viewContext, this.experimentCriteria.getExperimentIdentifier(), this.experimentCriteria.getExperimentPermId(), false);
    }

    private static WellSearchCriteria.SingleExperimentSearchCriteria getExperiment(WellData wellData) {
        Experiment experiment = wellData.getExperiment();
        return new WellSearchCriteria.SingleExperimentSearchCriteria(experiment.getId(), experiment.getPermId(), experiment.getIdentifier());
    }

    private static WellSearchCriteria.SingleExperimentSearchCriteria getExperiment(ExperimentReference experimentReference) {
        return new WellSearchCriteria.SingleExperimentSearchCriteria(experimentReference.getId(), experimentReference.getPermId(), experimentReference.getIdentifier());
    }

    private static String getSessionId(IViewContext<?> viewContext) {
        return viewContext.getModel().getSessionContext().getSessionID();
    }

    private WellContentDialog(IEntityInformationHolderWithPermId wellOrNull, List<IEntityProperty> wellPropertiesOrNull, WellLocation wellLocationOrNull, WellSearchCriteria.SingleExperimentSearchCriteria experimentCriteria, IEntityInformationHolderWithPermId plate, ImageDatasetEnrichedReference imageDatasetOrNull, IViewContext<IScreeningClientServiceAsync> viewContext) {
        this.wellOrNull = wellOrNull;
        this.plate = plate;
        this.wellLocationOrNull = wellLocationOrNull;
        this.wellPropertiesOrNull = wellPropertiesOrNull;
        if (wellPropertiesOrNull != null) {
            Collections.sort(wellPropertiesOrNull);
        }
        this.experimentCriteria = experimentCriteria;
        this.imageDatasetOrNull = imageDatasetOrNull;
        this.viewContext = viewContext;
        this.setScrollMode(Style.Scroll.AUTO);
        this.setHideOnButtonClick(true);
        this.setButtons("close");
        this.setHeading(WELL_LABEL + this.getWellDescription());
        this.setTopComponent((Component)this.createContentDescription());
    }

    private ImageDatasetEnrichedReference tryGetImages() {
        return this.imageDatasetOrNull;
    }

    private void addImageEditorLaunchButton(final LogicalImageViewer viewer) {
        if (!viewer.isImageEditorEnabled()) {
            return;
        }
        ButtonBar buttonBar = this.getButtonBar();
        buttonBar.setAlignment(Style.HorizontalAlignment.LEFT);
        Button launchButton = new Button(this.viewContext.getMessage("image_viewer_button", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                viewer.launchImageEditor();
                WellContentDialog.this.hide();
            }
        });
        buttonBar.insert((Component)new FillToolItem(), 0);
        buttonBar.insert((Component)launchButton, 0);
    }

    private String getWellDescription() {
        return this.wellLocationOrNull != null ? PlateUtils.translateLocationIntoWellCode(this.wellLocationOrNull) : "?";
    }

    private LayoutContainer createContentDescription() {
        LayoutContainer container = new LayoutContainer();
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setCellPadding(3);
        container.setLayout((Layout)tableLayout);
        TableData cellLayout = new TableData();
        cellLayout.setMargin(5);
        if (this.wellOrNull != null) {
            container.add((Widget)new Text(WELL_LABEL), (LayoutData)cellLayout);
            container.add(this.createEntityLink(this.wellOrNull, this.wellOrNull.getCode()));
        } else {
            container.add((Widget)new Text(WELL_LABEL), (LayoutData)cellLayout);
            final String suffix = this.wellLocationOrNull == null ? "" : ":" + this.wellLocationOrNull.toWellIdString();
            container.add(this.createEntityLink(new IEntityInformationHolderWithPermId(){
                private static final long serialVersionUID = 1L;

                public String getPermId() {
                    return WellContentDialog.this.plate.getPermId() + suffix;
                }

                public String getCode() {
                    return WellContentDialog.this.plate.getCode();
                }

                public Long getId() {
                    return WellContentDialog.this.plate.getId();
                }

                public BasicEntityType getEntityType() {
                    return WellContentDialog.this.plate.getEntityType();
                }

                public EntityKind getEntityKind() {
                    return WellContentDialog.this.plate.getEntityKind();
                }
            }, this.getWellDescription()));
        }
        if (this.wellPropertiesOrNull != null) {
            this.addProperties(container, cellLayout, this.wellPropertiesOrNull);
        }
        return container;
    }

    private void addProperties(LayoutContainer container, TableData cellLayout, List<IEntityProperty> properties) {
        for (IEntityProperty property : properties) {
            this.addProperty(container, cellLayout, property);
        }
    }

    private void addProperty(LayoutContainer container, TableData cellLayout, IEntityProperty property) {
        String propertyLabel = property.getPropertyType().getLabel();
        String propertyValue = property.tryGetAsString();
        container.add((Widget)new Text(propertyLabel + ": "), (LayoutData)cellLayout);
        Material material = property.getMaterial();
        if (material != null) {
            if (material.getMaterialType().getCode().equalsIgnoreCase("GENE")) {
                container.add(this.createEntityExternalLink(material));
            } else {
                container.add(this.createPlateLocationsMaterialViewerLink((IEntityInformationHolderWithPermId)material));
            }
        } else if (property.getPropertyType().getDataType().getCode() == DataTypeCode.HYPERLINK) {
            String link = LinkRenderer.renderAsLinkWithAnchor((String)propertyValue, (String)propertyValue, (boolean)true);
            container.add((Widget)new Html(link));
        } else {
            container.add((Widget)new Text(propertyValue), (LayoutData)cellLayout);
        }
    }

    private Widget createEntityExternalLink(Material material) {
        LayoutContainer container = new LayoutContainer();
        HBoxLayout layout = new HBoxLayout();
        container.setLayout((Layout)layout);
        container.setWidth(300);
        container.add(this.createPlateLocationsMaterialViewerLink((IEntityInformationHolderWithPermId)material));
        LayoutContainer spacer = new LayoutContainer();
        spacer.setWidth(10);
        container.add((Widget)spacer);
        container.add((Widget)new Text("["));
        String geneSymbolsOrNull = WellContentDialog.tryGetGeneSymbols(material);
        if (geneSymbolsOrNull != null && !StringUtils.isBlank((String)geneSymbolsOrNull)) {
            String[] symbols = geneSymbolsOrNull.split(" ");
            for (int i = 0; i < symbols.length; ++i) {
                String symbol = symbols[i];
                if (i > 0) {
                    container.add((Widget)new Text(","));
                }
                String message = this.viewContext.getMessage("GENE_LIBRARY_URL", new Object[]{symbol});
                String link = LinkRenderer.renderAsLinkWithAnchor((String)symbol, (String)message, (boolean)true);
                container.add((Widget)new Html(link));
            }
        } else {
            container.add((Widget)new Html(LinkRenderer.renderAsLinkWithAnchor((String)"gene database", (String)this.viewContext.getMessage("GENE_LIBRARY_SEARCH_URL", new Object[]{material.getCode()}), (boolean)true)));
        }
        container.add((Widget)new Text("]"));
        return container;
    }

    private static String tryGetGeneSymbols(Material material) {
        for (IEntityProperty prop : material.getProperties()) {
            if (!prop.getPropertyType().getCode().equalsIgnoreCase("GENE_SYMBOLS")) continue;
            return prop.getValue();
        }
        return null;
    }

    private Widget createPlateLocationsMaterialViewerLink(final IEntityInformationHolderWithPermId material) {
        String href = ScreeningLinkExtractor.createMaterialDetailsLink((IEntityInformationHolder)material, this.getExperimentCriteria());
        ClickHandler listener = new ClickHandler(){

            public void onClick(ClickEvent event) {
                WellContentDialog.this.hide();
                ClientPluginFactory.openImagingMaterialViewer(material, WellContentDialog.this.getExperimentCriteria(), WellSearchCriteria.AnalysisProcedureCriteria.createNoProcedures(), false, (IViewContext<IScreeningClientServiceAsync>)WellContentDialog.this.viewContext);
            }
        };
        Anchor link = (Anchor)LinkRenderer.getLinkWidget((String)material.getCode(), (ClickHandler)listener, (String)href);
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            link.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WellContentDialog.this.hide();
                }
            });
        }
        return link;
    }

    private WellSearchCriteria.ExperimentSearchCriteria getExperimentCriteria() {
        return WellSearchCriteria.ExperimentSearchCriteria.createExperiment(this.experimentCriteria, false);
    }

    private Widget createEntityLink(IEntityInformationHolderWithPermId entity, String label) {
        WellContentOpenEntityDetailsTabClickLister listener = new WellContentOpenEntityDetailsTabClickLister(entity, this.viewContext, this.imageDatasetOrNull);
        return LinkRenderer.getLinkWidget((String)label, (ClickHandler)listener);
    }

    private static class WellContentOpenEntityDetailsTabClickLister
    extends OpenEntityDetailsTabClickListener {
        private final ImageDatasetEnrichedReference currentDataSet;
        private final ScreeningViewContext screeningViewContext;

        public WellContentOpenEntityDetailsTabClickLister(IEntityInformationHolderWithPermId entity, IViewContext<IScreeningClientServiceAsync> viewContext, ImageDatasetEnrichedReference currentDataSet) {
            super(entity, viewContext);
            this.currentDataSet = currentDataSet;
            this.screeningViewContext = (ScreeningViewContext)viewContext;
        }

        public void onClick(ClickEvent event) {
            this.screeningViewContext.setCurrentlyViewedPlateDataSet(this.getEntity().getId(), this.currentDataSet);
            super.onClick(event);
        }
    }
}

