/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineItemsField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellSearchGrid;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.MarginData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class WellSearchComponent
extends TabContent {
    public static final String ID_SUFFIX = "ExperimentPlateLocationsSection";
    private static final int TEXT_AREA_WIDTH = 500;
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final WellSearchCriteria.ExperimentSearchCriteria experimentSearchCriteria;
    private final MultilineItemsField materialListField;
    private final CheckBoxField exactMatchOnly;
    private final CheckBoxField showCombinedResults;
    private List<MaterialType> materialTypesOrNull;

    public static String getTabTitle(IViewContext<IScreeningClientServiceAsync> viewContext) {
        return viewContext.getMessage("EXPERIMENT_PLATE_MATERIAL_REVIEWER_SECTION", new Object[0]);
    }

    public WellSearchComponent(IViewContext<IScreeningClientServiceAsync> screeningViewContext, String materialListOrNull, Boolean isExactMatchOrNull, Boolean showCombinedResultsOrNull) {
        this(screeningViewContext, WellSearchCriteria.ExperimentSearchCriteria.createAllExperiments());
        if (!StringUtils.isBlank((String)materialListOrNull)) {
            this.materialListField.setValue((Object)materialListOrNull);
        }
        if (isExactMatchOrNull != null) {
            this.exactMatchOnly.setValue(isExactMatchOrNull);
        }
        if (showCombinedResultsOrNull != null) {
            this.showCombinedResults.setValue(showCombinedResultsOrNull);
        }
        this.setContentVisible(true);
    }

    public static WellSearchComponent create(IViewContext<IScreeningClientServiceAsync> screeningViewContext, IEntityInformationHolderWithIdentifier experiment) {
        assert (experiment != null) : "experiment is null";
        return new WellSearchComponent(screeningViewContext, WellSearchComponent.getExperimentSearchCriteria(experiment));
    }

    private static WellSearchCriteria.ExperimentSearchCriteria getExperimentSearchCriteria(IEntityInformationHolderWithIdentifier experimentOrNull) {
        if (experimentOrNull == null) {
            return WellSearchCriteria.ExperimentSearchCriteria.createAllExperiments();
        }
        return WellSearchCriteria.ExperimentSearchCriteria.createExperiment(experimentOrNull);
    }

    public WellSearchComponent(IViewContext<IScreeningClientServiceAsync> screeningViewContext, WellSearchCriteria.ExperimentSearchCriteria experimentSearchCriteria) {
        super(WellSearchComponent.getTabTitle(screeningViewContext), screeningViewContext, (IIdHolder)WellSearchComponent.tryGetExperimentId(experimentSearchCriteria));
        this.screeningViewContext = screeningViewContext;
        this.experimentSearchCriteria = experimentSearchCriteria;
        this.materialListField = this.createMaterialListArea();
        this.exactMatchOnly = WellSearchComponent.createCheckBox("EXACT_MATCH_ONLY", true, screeningViewContext);
        this.showCombinedResults = WellSearchComponent.createCheckBox("WELLS_SEARCH_SHOW_COMBINED_RESULTS", true, screeningViewContext);
        this.setIds(DisplayTypeIDGenerator.EXPERIMENT_PLATE_LOCATIONS_SECTION);
        screeningViewContext.getCommonService().listMaterialTypes((AsyncCallback)new AbstractAsyncCallback<List<MaterialType>>(screeningViewContext){

            protected void process(List<MaterialType> result) {
                WellSearchComponent.this.materialTypesOrNull = result;
            }
        });
    }

    private static TechId tryGetExperimentId(WellSearchCriteria.ExperimentSearchCriteria experimentSearchCriteria) {
        return experimentSearchCriteria.tryGetExperiment() == null ? null : experimentSearchCriteria.tryGetExperiment().getExperimentId();
    }

    private static CheckBoxField createCheckBox(String labelDictKey, Boolean value, IMessageProvider messageProvider) {
        String label = messageProvider.getMessage(labelDictKey, new Object[0]);
        CheckBoxField checkbox = new CheckBoxField(label, false);
        checkbox.setBoxLabel(label);
        checkbox.setValue(value);
        return checkbox;
    }

    private MultilineItemsField createMaterialListArea() {
        MultilineItemsField area = new MultilineItemsField("", true, 10);
        area.setWidth(500);
        area.setEmptyText(this.screeningViewContext.getMessage("PLATE_MATERIAL_REVIEWER_SPECIFY_METERIAL_ITEMS", new Object[0]));
        area.setLabelSeparator("");
        return area;
    }

    protected void showContent() {
        LayoutContainer container = new LayoutContainer((Layout)new RowLayout());
        CheckBoxGroup checkBoxGroup = new CheckBoxGroup();
        checkBoxGroup.add((Field)this.exactMatchOnly);
        checkBoxGroup.add((Field)this.showCombinedResults);
        container.add((Widget)checkBoxGroup);
        container.add((Widget)this.materialListField);
        container.add(this.createSearchLink());
        container.setScrollMode(Style.Scroll.AUTO);
        this.add((Widget)container, (LayoutData)new MarginData(10));
    }

    private Widget createSearchLink() {
        Button searchButton = new Button(this.screeningViewContext.getMessage("search_button", new Object[0]));
        searchButton.setWidth(500);
        IDelegatedAction normalModeAction = new IDelegatedAction(){

            public void execute() {
                WellSearchComponent.this.showPlateMaterialReviewer();
            }
        };
        LinkRenderer.IURLProvider urlProvider = new LinkRenderer.IURLProvider(){

            public String tryGetURL() {
                WellSearchCriteria.MaterialSearchCodesCriteria materialCriteria = WellSearchComponent.this.tryGetMaterialSearchCriteria();
                if (materialCriteria == null) {
                    return null;
                }
                return ScreeningLinkExtractor.createWellsSearchLink(WellSearchComponent.this.experimentSearchCriteria, materialCriteria, WellSearchComponent.this.showCombinedResults.getValue());
            }
        };
        return LinkRenderer.createButtonLink((Button)searchButton, (IDelegatedAction)normalModeAction, (LinkRenderer.IURLProvider)urlProvider);
    }

    private void showPlateMaterialReviewer() {
        WellSearchCriteria.MaterialSearchCodesCriteria materialCriteria = this.tryGetMaterialSearchCriteria();
        if (materialCriteria == null) {
            return;
        }
        WellSearchGrid.openTab(this.screeningViewContext, this.experimentSearchCriteria, WellSearchCriteria.MaterialSearchCriteria.create(materialCriteria), WellSearchCriteria.AnalysisProcedureCriteria.createNoProcedures(), (boolean)this.showCombinedResults.getValue(), null);
    }

    private WellSearchCriteria.MaterialSearchCodesCriteria tryGetMaterialSearchCriteria() {
        String[] materialItemList = this.materialListField.tryGetModifiedItemList();
        if (materialItemList == null || materialItemList.length == 0) {
            return null;
        }
        if (this.materialTypesOrNull == null) {
            return null;
        }
        String[] materialTypeCodes = Code.extractCodesToArray(this.materialTypesOrNull);
        return new WellSearchCriteria.MaterialSearchCodesCriteria(materialItemList, materialTypeCodes, this.exactMatchOnly.getValue());
    }
}

