/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ChannelChooserPanel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ChannelWidgetWithListener;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.DefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.IDefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialDisambiguationGrid;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.SingleOrAllExperimentsChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellContentDialog;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.grids.WellSearchGridColumnIds;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WellSearchGrid
extends TypedTableGrid<WellContent>
implements AnalysisProcedureChooser.IAnalysisProcedureSelectionListener {
    public static final String BROWSER_ID = "openbis_PlateMaterialReviewer2Grid";
    private static final String CHANNEL_CHOOSER_LABEL = "Channel:";
    private static final int IMAGE_SIZE_PX = 80;
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final WellSearchCriteria.MaterialSearchCriteria materialCriteria;
    private final WellSearchCriteria.ExperimentSearchCriteriaHolder experimentCriteriaHolder;
    private final boolean restrictGlobalScopeLinkToProject;
    private ChannelChooserPanel channelChooser;
    private WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;

    public static void openTab(final IViewContext<IScreeningClientServiceAsync> screeningViewContext, String experimentPermId, final WellSearchCriteria.MaterialSearchCriteria materialSearchCriteria, final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, final boolean showCombinedResults, final String nothingFoundRedirectionUrlOrNull) {
        screeningViewContext.getCommonService().getEntityInformationHolder(EntityKind.EXPERIMENT, experimentPermId, (AsyncCallback)new AbstractAsyncCallback<IEntityInformationHolderWithPermId>(screeningViewContext){

            protected void process(IEntityInformationHolderWithPermId experimentIdentifier) {
                TechId experimentId = new TechId(experimentIdentifier.getId());
                WellSearchGrid.openTab((IViewContext<IScreeningClientServiceAsync>)screeningViewContext, experimentId, materialSearchCriteria, analysisProcedureCriteria, showCombinedResults, nothingFoundRedirectionUrlOrNull);
            }
        });
    }

    private static void openTab(final IViewContext<IScreeningClientServiceAsync> screeningViewContext, TechId experimentId, final WellSearchCriteria.MaterialSearchCriteria materialSearchCriteria, final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, final boolean showCombinedResults, final String nothingFoundRedirectionUrlOrNull) {
        screeningViewContext.getCommonService().getExperimentInfo(experimentId, (AsyncCallback)new AbstractAsyncCallback<Experiment>(screeningViewContext){

            protected void process(Experiment experiment) {
                WellSearchCriteria.ExperimentSearchCriteria experimentCriteria = WellSearchCriteria.ExperimentSearchCriteria.createExperiment((IEntityInformationHolderWithIdentifier)experiment);
                WellSearchGrid.openTab((IViewContext<IScreeningClientServiceAsync>)screeningViewContext, experimentCriteria, materialSearchCriteria, analysisProcedureCriteria, showCombinedResults, nothingFoundRedirectionUrlOrNull);
            }
        });
    }

    public static void openTab(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria.ExperimentSearchCriteria experimentCriteria, WellSearchCriteria.MaterialSearchCriteria materialCriteria, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean showCombinedResults, String nothingFoundRedirectionUrlOrNull) {
        WellSearchCriteria searchCriteria = new WellSearchCriteria(experimentCriteria, materialCriteria, analysisProcedureCriteria);
        if (showCombinedResults) {
            WellSearchGrid.openWellSearchTab(viewContext, searchCriteria);
        } else {
            MaterialDisambiguationGrid.openTab(viewContext, searchCriteria, nothingFoundRedirectionUrlOrNull);
        }
    }

    private static void openWellSearchTab(final IViewContext<IScreeningClientServiceAsync> viewContext, final WellSearchCriteria searchCriteria) {
        DispatcherHelper.dispatchNaviEvent((AbstractTabItemFactory)new AbstractTabItemFactory(){

            public ITabItem create() {
                IDisposableComponent grid = WellSearchGrid.create((IViewContext<IScreeningClientServiceAsync>)viewContext, searchCriteria.getExperimentCriteria(), searchCriteria.getMaterialSearchCriteria(), searchCriteria.getAnalysisProcedureCriteria());
                return DefaultTabItem.create((String)this.getTabTitle(), (IDisposableComponent)grid, (IViewContext)viewContext);
            }

            public HelpPageIdentifier getHelpPageIdentifier() {
                return HelpPageIdentifier.createSpecific((String)"Well Reviewing Panel");
            }

            public String getId() {
                String reportDate = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_MEDIUM).format(new Date());
                return "openbis_-PlateMaterialReviewer-" + reportDate;
            }

            public String getTabTitle() {
                return viewContext.getMessage("PLATE_MATERIAL_REVIEWER_TITLE", new Object[0]);
            }

            public String tryGetLink() {
                return ScreeningLinkExtractor.tryCreateWellsSearchLink(searchCriteria, true);
            }
        });
    }

    public static IDisposableComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, TechId materialId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean restrictGlobalScopeLinkToProject) {
        return WellSearchGrid.create(viewContext, experimentCriteriaOrNull, WellSearchCriteria.MaterialSearchCriteria.createIdCriteria(materialId), analysisProcedureCriteria, restrictGlobalScopeLinkToProject);
    }

    @Deprecated
    private static IDisposableComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.MaterialSearchCriteria materialCriteria, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        return WellSearchGrid.create(viewContext, experimentCriteriaOrNull, materialCriteria, analysisProcedureCriteria, false);
    }

    private static IDisposableComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.MaterialSearchCriteria materialCriteria, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean restrictGlobalScopeLinkToProject) {
        WellSearchGrid reviewer = new WellSearchGrid(viewContext, experimentCriteriaOrNull, materialCriteria, analysisProcedureCriteria, restrictGlobalScopeLinkToProject);
        final ToolBar toolbar = reviewer.createToolbar();
        return reviewer.asDisposableWithToolbar(new IDisposableComponent(){

            public void update(Set<DatabaseModificationKind> observedModifications) {
            }

            public DatabaseModificationKind[] getRelevantModifications() {
                return null;
            }

            public Component getComponent() {
                return toolbar;
            }

            public void dispose() {
            }
        });
    }

    private WellSearchGrid(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.MaterialSearchCriteria materialCriteria, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean restrictGlobalScopeLinkToProject) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, false, (IDisplayTypeIDGenerator)DisplayTypeIDGenerator.PLATE_MATERIAL_REVIEWER);
        this.screeningViewContext = viewContext;
        this.restrictGlobalScopeLinkToProject = restrictGlobalScopeLinkToProject;
        this.experimentCriteriaHolder = new WellSearchCriteria.ExperimentSearchCriteriaHolder(experimentCriteriaOrNull);
        this.materialCriteria = materialCriteria;
        this.analysisProcedureCriteria = analysisProcedureCriteria;
        IDefaultChannelState defaultChannelState = WellSearchGrid.createDefaultChannelState(viewContext, experimentCriteriaOrNull);
        this.channelChooser = new ChannelChooserPanel((IMessageProvider)this.screeningViewContext, defaultChannelState);
        this.linkExperiment();
        this.linkPlate();
        this.linkWell();
        this.linkImageDataSet();
        this.linkImageAnalysisDataSet();
    }

    private IViewContext<IScreeningClientServiceAsync> getViewContext() {
        return this.screeningViewContext;
    }

    private static IDefaultChannelState createDefaultChannelState(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull) {
        String displayTypeId;
        ScreeningDisplayTypeIDGenerator displayTypeIdGenerator = ScreeningDisplayTypeIDGenerator.EXPERIMENT_CHANNEL;
        if (experimentCriteriaOrNull != null && experimentCriteriaOrNull.tryGetExperiment() != null) {
            String experimentPermId = experimentCriteriaOrNull.tryGetExperiment().getExperimentPermId();
            displayTypeId = displayTypeIdGenerator.createID(experimentPermId);
        } else {
            displayTypeId = displayTypeIdGenerator.createID(null);
        }
        return new DefaultChannelState(viewContext, displayTypeId);
    }

    protected ICellListenerAndLinkGenerator<WellContent> tryGetCellListenerAndLinkGenerator(String columnId) {
        String wellMaterialPropertyTypeCode = WellSearchGridColumnIds.tryExtractWellMaterialPropertyCode(columnId);
        if (wellMaterialPropertyTypeCode != null) {
            ICellListenerAndLinkGenerator<WellContent> listenerLinkGenerator = this.createMaterialLinkGenerator(wellMaterialPropertyTypeCode);
            this.registerLinkClickListenerFor(columnId, (ICellListener)listenerLinkGenerator);
            return listenerLinkGenerator;
        }
        return super.tryGetCellListenerAndLinkGenerator(columnId);
    }

    private ICellListenerAndLinkGenerator<WellContent> createMaterialLinkGenerator(final String wellMaterialPropertyTypeCode) {
        return new ICellListenerAndLinkGenerator<WellContent>(){

            public String tryGetLink(WellContent wellContent, ISerializableComparable value) {
                Material material = WellSearchGrid.tryGetMaterial(wellContent, wellMaterialPropertyTypeCode);
                if (material == null) {
                    return null;
                }
                return WellSearchGrid.tryCreateMaterialDetailsLink(wellContent, material);
            }

            public void handle(TableModelRowWithObject<WellContent> row, boolean specialKeyPressed) {
                WellContent wellContent = (WellContent)row.getObjectOrNull();
                if (wellContent == null) {
                    return;
                }
                Material material = WellSearchGrid.tryGetMaterial(wellContent, wellMaterialPropertyTypeCode);
                if (material == null) {
                    return;
                }
                WellSearchGrid.this.openImagingMaterialViewer(wellContent, material);
            }
        };
    }

    private static Material tryGetMaterial(WellContent entity, String wellMaterialPropertyTypeCode) {
        for (IEntityProperty wellMaterialProperty : entity.getMaterialTypeProperties()) {
            if (!wellMaterialProperty.getPropertyType().getCode().equalsIgnoreCase(wellMaterialPropertyTypeCode)) continue;
            return wellMaterialProperty.getMaterial();
        }
        return null;
    }

    private static String tryCreateMaterialDetailsLink(WellContent wellContent, Material material) {
        return ScreeningLinkExtractor.createMaterialDetailsLink((IEntityInformationHolder)material, WellSearchGrid.getExperimentCriteria(wellContent));
    }

    private static WellSearchCriteria.ExperimentSearchCriteria getExperimentCriteria(WellContent wellContent) {
        ExperimentReference experiment = wellContent.getExperiment();
        return WellSearchGrid.getExperimentCriteria(experiment);
    }

    private static WellSearchCriteria.ExperimentSearchCriteria getExperimentCriteria(IEntityInformationHolderWithIdentifier experiment) {
        return WellSearchCriteria.ExperimentSearchCriteria.createExperiment(experiment);
    }

    private void openImagingMaterialViewer(WellContent wellContent, Material material) {
        ClientPluginFactory.openImagingMaterialViewer((IEntityInformationHolderWithPermId)material, WellSearchGrid.getExperimentCriteria(wellContent), this.analysisProcedureCriteria, false, this.getViewContext());
    }

    private void linkExperiment() {
        this.registerListenerAndLinkGenerator("experiment", (ICellListenerAndLinkGenerator)new ICellListenerAndLinkGenerator<WellContent>(){

            public String tryGetLink(WellContent entity, ISerializableComparable value) {
                return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity.getExperiment());
            }

            public void handle(TableModelRowWithObject<WellContent> wellContent, boolean specialKeyPressed) {
                WellSearchGrid.this.showEntityViewer((IEntityInformationHolderWithPermId)((WellContent)wellContent.getObjectOrNull()).getExperiment(), specialKeyPressed);
            }
        });
    }

    private void linkPlate() {
        this.registerListenerAndLinkGenerator("PLATE", (ICellListenerAndLinkGenerator)new ICellListenerAndLinkGenerator<WellContent>(){

            public String tryGetLink(WellContent entity, ISerializableComparable value) {
                return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity.getPlate());
            }

            public void handle(TableModelRowWithObject<WellContent> wellContent, boolean specialKeyPressed) {
                WellSearchGrid.this.showEntityViewer((IEntityInformationHolderWithPermId)((WellContent)wellContent.getObjectOrNull()).getPlate(), specialKeyPressed);
            }
        });
    }

    private void linkWell() {
        this.registerListenerAndLinkGenerator("WELL", (ICellListenerAndLinkGenerator)new ICellListenerAndLinkGenerator<WellContent>(){

            public String tryGetLink(WellContent entity, ISerializableComparable value) {
                return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity.getWell());
            }

            public void handle(TableModelRowWithObject<WellContent> wellContent, boolean specialKeyPressed) {
                WellSearchGrid.this.showEntityViewer((IEntityInformationHolderWithPermId)((WellContent)wellContent.getObjectOrNull()).getWell(), specialKeyPressed);
            }
        });
    }

    private void linkImageDataSet() {
        this.registerListenerAndLinkGenerator("IMAGE_DATA_SET", (ICellListenerAndLinkGenerator)new ICellListenerAndLinkGenerator<WellContent>(){

            public String tryGetLink(WellContent entity, ISerializableComparable value) {
                DatasetImagesReference imageDataset = entity.tryGetImageDataset();
                if (imageDataset != null) {
                    return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)imageDataset.getDatasetReference());
                }
                return null;
            }

            public void handle(TableModelRowWithObject<WellContent> wellContent, boolean specialKeyPressed) {
                DatasetImagesReference dataset = ((WellContent)wellContent.getObjectOrNull()).tryGetImageDataset();
                if (dataset != null) {
                    WellSearchGrid.this.showEntityViewer(dataset.getDatasetReference(), specialKeyPressed);
                }
            }
        });
    }

    private void linkImageAnalysisDataSet() {
        this.registerListenerAndLinkGenerator("IMAGE_ANALYSIS_DATA_SET", (ICellListenerAndLinkGenerator)new ICellListenerAndLinkGenerator<WellContent>(){

            public String tryGetLink(WellContent entity, ISerializableComparable value) {
                DatasetReference dataset = entity.tryGetFeatureVectorDataset();
                if (dataset != null) {
                    return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)dataset);
                }
                return null;
            }

            public void handle(TableModelRowWithObject<WellContent> wellContent, boolean specialKeyPressed) {
                DatasetReference dataset = ((WellContent)wellContent.getObjectOrNull()).tryGetFeatureVectorDataset();
                if (dataset != null) {
                    WellSearchGrid.this.showEntityViewer(dataset, specialKeyPressed);
                }
            }
        });
    }

    private void showEntityViewer(IEntityInformationHolderWithPermId entityOrNull, boolean specialKeyPressed) {
        if (entityOrNull != null) {
            new OpenEntityDetailsTabAction(entityOrNull, this.getViewContext(), specialKeyPressed).execute();
        }
    }

    private ToolBar createToolbar() {
        ToolBar toolbar = new ToolBar();
        toolbar.setEnableOverflow(false);
        AnalysisProcedureChooser analysisProcedureChooser = this.createAnalysisProcedureChooser();
        toolbar.add(this.createExperimentChooser(analysisProcedureChooser));
        toolbar.add((Component)analysisProcedureChooser);
        toolbar.add((Component)new Label(CHANNEL_CHOOSER_LABEL));
        toolbar.add((Component)this.channelChooser);
        return toolbar;
    }

    private Component createExperimentChooser(AnalysisProcedureChooser analysisProcedureChooser) {
        IDelegatedAction experimentSelectionChangedAction = this.createExperimentSelectionChangedAction(analysisProcedureChooser);
        return new SingleOrAllExperimentsChooser(this.getViewContext(), this.experimentCriteriaHolder, this.restrictGlobalScopeLinkToProject, experimentSelectionChangedAction);
    }

    protected final IDelegatedAction createExperimentSelectionChangedAction(final AnalysisProcedureChooser analysisProcedureChooser) {
        return new IDelegatedAction(){

            public void execute() {
                analysisProcedureChooser.updateAnalysisProcedures();
            }
        };
    }

    private AnalysisProcedureChooser createAnalysisProcedureChooser() {
        AnalysisProcedureChooser analysisProcedureChooser = AnalysisProcedureChooser.createVertical(this.getViewContext(), this.experimentCriteriaHolder, WellSearchCriteria.AnalysisProcedureCriteria.createAllProcedures(), this, true);
        return analysisProcedureChooser;
    }

    protected ColumnDefsAndConfigs<TableModelRowWithObject<WellContent>> createColumnsDefinition() {
        ColumnDefsAndConfigs columnDefs = super.createColumnsDefinition();
        this.setImageRenderer((ColumnDefsAndConfigs<TableModelRowWithObject<WellContent>>)columnDefs);
        return columnDefs;
    }

    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID;
    }

    private void setImageRenderer(ColumnDefsAndConfigs<TableModelRowWithObject<WellContent>> schema) {
        GridCellRenderer render = new GridCellRenderer<BaseEntityModel<?>>(){

            public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
                final WellContent entity = (WellContent)this.getTableModel(model).getObjectOrNull();
                if (entity == null) {
                    return null;
                }
                DatasetImagesReference images = entity.tryGetImageDataset();
                if (images == null) {
                    return null;
                }
                ChannelWidgetWithListener.ISimpleChanneledViewerFactory viewerFactory = new ChannelWidgetWithListener.ISimpleChanneledViewerFactory(){

                    @Override
                    public Widget create(List<String> channels, String imageTransformationCodeOrNull, Map<String, IntensityRange> rangesOrNull) {
                        return WellContentDialog.createImageViewerForChannel((IViewContext<IScreeningClientServiceAsync>)WellSearchGrid.this.getViewContext(), entity, 80, channels, imageTransformationCodeOrNull, rangesOrNull);
                    }
                };
                ChannelWidgetWithListener widgetWithListener = new ChannelWidgetWithListener(viewerFactory);
                widgetWithListener.selectionChanged(WellSearchGrid.this.channelChooser.getSelectedValues(), WellSearchGrid.this.channelChooser.tryGetSelectedTransformationCode(false), WellSearchGrid.this.channelChooser.tryGetSelectedIntensityRanges());
                WellSearchGrid.this.channelChooser.addSelectionChangedListener(widgetWithListener);
                return widgetWithListener.asWidget();
            }

            private TableModelRowWithObject<WellContent> getTableModel(BaseEntityModel<?> model) {
                return (TableModelRowWithObject)model.getBaseObject();
            }
        };
        schema.setGridCellRendererFor("WELL_IMAGES", render);
    }

    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<WellContent>> resultSetConfig, final AbstractAsyncCallback<TypedTableResultSet<WellContent>> callback) {
        WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull = this.experimentCriteriaHolder.tryGetCriteria();
        assert (experimentCriteriaOrNull != null) : "experiment not specified";
        WellSearchCriteria searchCriteria = new WellSearchCriteria(experimentCriteriaOrNull, this.materialCriteria, this.analysisProcedureCriteria);
        ((IScreeningClientServiceAsync)this.getViewContext().getService()).listPlateWells((IResultSetConfig<String, TableModelRowWithObject<WellContent>>)resultSetConfig, searchCriteria, new AsyncCallback<TypedTableResultSet<WellContent>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(TypedTableResultSet<WellContent> result) {
                GridRowModels rows = result.getResultSet().getList();
                for (GridRowModel row : rows) {
                    DatasetImagesReference dataSet;
                    WellContent wellContent = (WellContent)((TableModelRowWithObject)row.getOriginalObject()).getObjectOrNull();
                    if (wellContent == null || (dataSet = wellContent.tryGetImageDataset()) == null) continue;
                    ImageDatasetParameters imageParameters = dataSet.getImageParameters();
                    WellSearchGrid.this.channelChooser.addChannelsForParameters(imageParameters);
                }
                WellSearchGrid.this.channelChooser.updateChannelSelection(null);
                callback.onSuccess(result);
            }
        });
    }

    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<WellContent>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((IScreeningClientServiceAsync)this.getViewContext().getService()).prepareExportPlateWells(exportCriteria, (AsyncCallback<String>)callback);
    }

    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("PLATE", "WELL");
    }

    @Override
    public void analysisProcedureSelected(WellSearchCriteria.AnalysisProcedureCriteria selectedProcedureCriteria) {
        if (this.experimentCriteriaHolder.tryGetCriteria() != null) {
            this.analysisProcedureCriteria = selectedProcedureCriteria;
            this.refresh(true);
        }
    }
}

