/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.IRealNumberRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.WellData;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.DelegatingFloatHeatmapRenderer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.DelegatingStringHeatmapRenderer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.HeatMapRangeChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.HeatmapScaleFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.IHeatmapRenderer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.WellTooltipGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.Color;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.HeatmapScaleElement;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.MinMaxAndRange;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.PlateLayouterModel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.Utils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class HeatmapPresenter {
    private static final String UNKNOWN_WELL_MSG = "No metadata available";
    private final IHeatmapRenderer<WellData> cachedMetadataHeatmapRenderer;
    private final PlateLayouterModel model;
    private final IHeatmapViewManipulator viewManipulations;
    private final IWellTooltipGenerator tooltipGenerator;
    private final IRealNumberRenderer realNumberRenderer;
    private final ScreeningViewContext viewContext;

    public HeatmapPresenter(ScreeningViewContext viewContext, PlateLayouterModel model, IRealNumberRenderer realNumberRenderer, IHeatmapViewManipulator viewManipulations) {
        this.viewContext = viewContext;
        this.model = model;
        this.viewManipulations = viewManipulations;
        this.realNumberRenderer = realNumberRenderer;
        this.tooltipGenerator = new WellTooltipGenerator(model, realNumberRenderer);
        this.cachedMetadataHeatmapRenderer = WellMetadataHeatmapRenderer.create(model.getWellList());
        this.setWellMetadataMode();
    }

    public void setWellMetadataMode() {
        IHeatmapRenderer<WellData> renderer = this.cachedMetadataHeatmapRenderer;
        this.refreshHeatmap(renderer, null);
    }

    public void setFeatureValueMode(CodeAndLabel featureName) {
        boolean success = this.changeFeatureValueMode(featureName);
        if (!success) {
            DatasetReference dataset = this.model.tryGetDatasetReference();
            if (dataset != null) {
                ((IScreeningClientServiceAsync)this.viewContext.getService()).getFeatureVectorDataset(dataset, featureName, this.createChangeHeatmapCallback(this.viewContext, featureName));
            } else {
                GWTUtils.alert((String)"Error", (String)"No data set selected");
            }
        }
    }

    private boolean changeFeatureValueMode(CodeAndLabel featureName) {
        boolean result = this.model.setChosenFeature(featureName);
        if (result) {
            this.refreshHeatMap(featureName);
        }
        return result;
    }

    private void refreshHeatMap(CodeAndLabel featureName) {
        IHeatmapRenderer<WellData> renderer = this.createFeatureHeatmapRenderer();
        this.refreshHeatmap(renderer, featureName);
    }

    private AsyncCallback<FeatureVectorDataset> createChangeHeatmapCallback(ScreeningViewContext context, final CodeAndLabel featureName) {
        return new AbstractAsyncCallback<FeatureVectorDataset>((IViewContext)context){

            protected void process(FeatureVectorDataset featureVector) {
                HeatmapPresenter.this.model.updateFeatureVectorDataset(featureVector);
                boolean success = HeatmapPresenter.this.changeFeatureValueMode(featureName);
                if (!success) {
                    GWTUtils.alert((String)"Error", (String)("No values found for feature " + featureName.getLabel()));
                }
            }
        };
    }

    private IHeatmapRenderer<WellData> createFeatureHeatmapRenderer() {
        if (this.model.isVocabularyFeature()) {
            return this.createVocabularyFeatureHeatmapRenderer();
        }
        return this.createFloatFeatureHeatmapRenderer();
    }

    private IHeatmapRenderer<WellData> createVocabularyFeatureHeatmapRenderer() {
        List<String> uniqueValues = this.model.extractUniqueVocabularyTerms();
        return new DelegatingStringHeatmapRenderer<WellData>(uniqueValues, this.model.getChosenFeature(), null){

            @Override
            protected String extractLabel(WellData well) {
                return Utils.tryAsVocabularyFeature(well, this.feature.getLabel());
            }
        };
    }

    private void refreshHeatmap(IHeatmapRenderer<WellData> renderer, final CodeAndLabel featureOrNull) {
        WellData[][] wellMatrix = this.model.getWellMatrix();
        for (int rowIx = 0; rowIx < wellMatrix.length; ++rowIx) {
            for (int colIx = 0; colIx < wellMatrix[rowIx].length; ++colIx) {
                final WellData wellData = wellMatrix[rowIx][colIx];
                Color color = renderer.getColor(wellData);
                this.viewManipulations.updateWellStyle(rowIx, colIx, color);
                final int ri = rowIx;
                final int ci = colIx;
                final IDelegatedAction refreshTooltipAction = new IDelegatedAction(){

                    public void execute() {
                        HeatmapPresenter.this.viewContext.log("Update tooltip: " + wellData.getWellLocation().toString());
                        String tooltip = HeatmapPresenter.this.tooltipGenerator.generateTooltip(ri, ci, featureOrNull);
                        HeatmapPresenter.this.viewManipulations.updateTooltip(ri, ci, tooltip);
                    }
                };
                if (wellData.isFullyLoaded()) {
                    refreshTooltipAction.execute();
                    continue;
                }
                this.viewManipulations.addEmptyTooltip(rowIx, colIx);
                this.viewManipulations.scheduleUpdateTooltip(rowIx, colIx, new IDelegatedAction(){

                    public void execute() {
                        HeatmapPresenter.this.viewContext.log("Fetch Well Values: " + wellData.getWellLocation().toString());
                        HeatmapPresenter.this.fetchWellFeatures(wellData, refreshTooltipAction);
                    }
                });
            }
        }
        this.refreshLegend(renderer);
    }

    private void fetchWellFeatures(final WellData wellData, final IDelegatedAction refreshTooltipAction) {
        DatasetReference datasetReference = this.model.tryGetDatasetReference();
        if (datasetReference != null) {
            String datasetCode = datasetReference.getCode();
            String datastoreCode = datasetReference.getDatastoreCode();
            WellLocation location = wellData.getWellLocation();
            AbstractAsyncCallback<FeatureVectorValues> callback = new AbstractAsyncCallback<FeatureVectorValues>((IViewContext)this.viewContext){

                protected void process(FeatureVectorValues resultOrNull) {
                    this.viewContext.log("Update Well Feature Values: " + wellData.getWellLocation().toString());
                    if (resultOrNull != null) {
                        HeatmapPresenter.this.model.updateWellFeatureValues(resultOrNull);
                    } else {
                        HeatmapPresenter.this.model.resetFeatureValues(wellData);
                    }
                    refreshTooltipAction.execute();
                }
            };
            ((IScreeningClientServiceAsync)this.viewContext.getService()).getWellFeatureVectorValues(datasetCode, datastoreCode, location, (AsyncCallback<FeatureVectorValues>)callback);
        } else {
            wellData.setFullyLoaded(true);
            refreshTooltipAction.execute();
        }
    }

    private void refreshLegend(IHeatmapRenderer<WellData> renderer) {
        List<HeatmapScaleElement> scale = renderer.calculateScale();
        String firstLabel = renderer.tryGetFirstLabel();
        Component legend = HeatmapScaleFactory.create(firstLabel, scale);
        if (firstLabel != null) {
            LayoutContainer container = new LayoutContainer();
            container.setLayout((Layout)new TableLayout(1));
            container.add((Widget)legend);
            Button adaptScaleButton = new Button(this.viewContext.getMessage("heat_map_range_chooser_button", new Object[0]));
            adaptScaleButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    HeatmapPresenter.this.showHeatMapRangeChooser();
                }
            });
            container.add((Widget)adaptScaleButton);
            legend = container;
        }
        this.viewManipulations.updateLegend((Widget)legend);
    }

    private IHeatmapRenderer<WellData> createFloatFeatureHeatmapRenderer() {
        MinMaxAndRange mmRange = this.model.calculateRange();
        return new DelegatingFloatHeatmapRenderer<WellData>(mmRange, this.model.getChosenFeature(), this.realNumberRenderer){

            @Override
            protected Float convert(WellData well) {
                return Utils.tryAsFloatFeature(well, this.feature.getLabel());
            }
        };
    }

    private void showHeatMapRangeChooser() {
        HeatMapRangeChooser chooser = new HeatMapRangeChooser(this.viewContext, this.model, new IDelegatedAction(){

            public void execute() {
                CodeAndLabel feature = HeatmapPresenter.this.model.getChosenFeature();
                HeatmapPresenter.this.refreshHeatMap(feature);
            }
        });
        chooser.show();
    }

    private static class WellMetadataHeatmapRenderer
    extends DelegatingStringHeatmapRenderer<WellData> {
        private static final int MAX_SPECIFIC_COLORS = 3;
        private static final Color EMPTY_WELL_COLOR = new Color("#F2F0F7");
        private static final List<Color> CONTROL_COLORS = Arrays.asList(new Color("#DAFFB3"), new Color("#9CFFB3"), new Color("#FFFFB3"));
        private static final List<Color> NON_CONTROL_COLORS = Arrays.asList(new Color("#D3CCFF"), new Color("#BDCCFF"), new Color("#E9CCFF"));

        public static IHeatmapRenderer<WellData> create(List<WellData> wells) {
            HashSet<String> labels = new HashSet<String>();
            boolean emptyWellsEncountered = false;
            for (WellData well : wells) {
                String label = WellMetadataHeatmapRenderer.tryExtractLabel(well);
                if (label != null) {
                    labels.add(label);
                    continue;
                }
                emptyWellsEncountered = true;
            }
            ArrayList<String> uniqueValues = new ArrayList<String>(labels);
            Collections.sort(uniqueValues);
            if (emptyWellsEncountered) {
                uniqueValues.add(HeatmapPresenter.UNKNOWN_WELL_MSG);
            }
            List<Color> colorsOrNull = WellMetadataHeatmapRenderer.tryGetMetadataLegendColors(uniqueValues, emptyWellsEncountered);
            return new WellMetadataHeatmapRenderer(uniqueValues, colorsOrNull);
        }

        private static List<Color> tryGetMetadataLegendColors(List<String> uniqueValues, boolean emptyWellsEncountered) {
            int colorsNumber = uniqueValues.size();
            int nonEmptyColors = colorsNumber - (emptyWellsEncountered ? 1 : 0);
            if (nonEmptyColors > 3) {
                return null;
            }
            assert (CONTROL_COLORS.size() >= 3) : "not enough control colors";
            assert (NON_CONTROL_COLORS.size() >= 3) : "not enough non-control colors";
            Iterator<Color> controlColorsIter = CONTROL_COLORS.iterator();
            Iterator<Color> nonControlColorsIter = NON_CONTROL_COLORS.iterator();
            ArrayList<Color> colors = new ArrayList<Color>();
            for (int i = 0; i < nonEmptyColors; ++i) {
                if (WellMetadataHeatmapRenderer.isControl(uniqueValues.get(i))) {
                    colors.add(controlColorsIter.next());
                    continue;
                }
                colors.add(nonControlColorsIter.next());
            }
            if (emptyWellsEncountered) {
                colors.add(EMPTY_WELL_COLOR);
            }
            return colors;
        }

        private static boolean isControl(String label) {
            return label.toUpperCase().matches(".*CONTROL.*");
        }

        private WellMetadataHeatmapRenderer(List<String> uniqueValues, List<Color> colorsOrNull) {
            super(uniqueValues, null, colorsOrNull);
        }

        @Override
        protected final String extractLabel(WellData well) {
            String label = WellMetadataHeatmapRenderer.tryExtractLabel(well);
            if (label == null) {
                return HeatmapPresenter.UNKNOWN_WELL_MSG;
            }
            return label;
        }

        private static final String tryExtractLabel(WellData well) {
            WellMetadata metadata = well.tryGetMetadata();
            if (metadata == null) {
                return null;
            }
            return metadata.getWellSample().getEntityType().getCode();
        }
    }

    static interface IWellTooltipGenerator {
        public String generateTooltip(int var1, int var2, CodeAndLabel var3);
    }

    static interface IHeatmapViewManipulator {
        public void updateWellStyle(int var1, int var2, Color var3);

        public void addEmptyTooltip(int var1, int var2);

        public void updateTooltip(int var1, int var2, String var3);

        public void scheduleUpdateTooltip(int var1, int var2, IDelegatedAction var3);

        public void updateLegend(Widget var1);
    }
}

