/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.IRealNumberRenderer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.ColorConstants;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.IHeatmapRenderer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.Color;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.HeatmapScaleElement;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.MinMaxAndRange;
import java.util.ArrayList;
import java.util.List;

class NumberHeatmapRenderer
implements IHeatmapRenderer<Float> {
    static final String LESS_THAN_EQUAL = "\u2264";
    static final String GREATER_THAN_EQUAL = "\u2265";
    private final float step;
    private final List<Color> colors;
    private final float from;
    private final float until;
    private final IRealNumberRenderer realNumberRenderer;
    private final String scaleTop;
    private final String scaleBottom;

    public NumberHeatmapRenderer(MinMaxAndRange minMaxRange, IRealNumberRenderer realNumberRenderer) {
        this(minMaxRange, ColorConstants.LONG_GRADIENT_DEFAULT_COLORS, realNumberRenderer);
    }

    public NumberHeatmapRenderer(MinMaxAndRange minMaxRange, List<String> colors, IRealNumberRenderer realNumberRenderer) {
        this.from = minMaxRange.getRange().getFrom();
        this.until = minMaxRange.getRange().getUntil();
        this.colors = ColorConstants.asColors(colors);
        this.realNumberRenderer = realNumberRenderer;
        this.step = this.from == this.until ? 1.0f / (float)this.colors.size() : (this.until - this.from) / (float)this.colors.size();
        if (this.step > 0.0f) {
            this.scaleTop = this.createScaleEndLabel(this.until, minMaxRange.getMax(), minMaxRange.getMin());
            this.scaleBottom = this.createScaleEndLabel(this.from, minMaxRange.getMin(), minMaxRange.getMax());
        } else {
            this.scaleTop = this.createScaleEndLabel(this.until, minMaxRange.getMin(), minMaxRange.getMax());
            this.scaleBottom = this.createScaleEndLabel(this.from, minMaxRange.getMax(), minMaxRange.getMin());
        }
    }

    private String createScaleEndLabel(float scaleEnd, float dataEnd, float otherDataEnd) {
        String scaleNumber = this.round(scaleEnd);
        if ((dataEnd - scaleEnd) * (scaleEnd - otherDataEnd) > 0.0f) {
            scaleNumber = (scaleEnd < dataEnd ? GREATER_THAN_EQUAL : LESS_THAN_EQUAL) + " " + scaleNumber;
        }
        return scaleNumber;
    }

    @Override
    public Color getColor(Float value) {
        if (value == null || Float.isNaN(value.floatValue()) || Float.isInfinite(value.floatValue())) {
            return ColorConstants.EMPTY_VALUE_COLOR;
        }
        float part = (this.until - value.floatValue()) / this.step;
        int colorNumber = Math.max(0, Math.min((int)Math.floor(part), this.colors.size() - 1));
        return this.colors.get(colorNumber);
    }

    @Override
    public List<HeatmapScaleElement> calculateScale() {
        ArrayList<HeatmapScaleElement> scale = new ArrayList<HeatmapScaleElement>();
        for (int i = 0; i < this.colors.size() - 1; ++i) {
            String label = this.round(this.until - this.step * (float)(i + 1));
            scale.add(new HeatmapScaleElement(label, this.colors.get(i)));
        }
        scale.add(new HeatmapScaleElement(this.scaleBottom, this.colors.get(this.colors.size() - 1)));
        return scale;
    }

    @Override
    public String tryGetFirstLabel() {
        return this.scaleTop;
    }

    private String round(float labelValue) {
        return this.realNumberRenderer.render(Math.abs(this.step) > 10.0f ? (float)Math.round(labelValue) : labelValue);
    }
}

