/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage;

import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageChannelStack;

class LogicalImageSeriesPoint
implements Comparable<LogicalImageSeriesPoint> {
    private final Float tOrNull;
    private final Float zOrNull;
    private final Integer seriesNumberOrNull;

    public LogicalImageSeriesPoint(ImageChannelStack stack) {
        this.tOrNull = stack.tryGetTimepoint();
        this.zOrNull = stack.tryGetDepth();
        this.seriesNumberOrNull = stack.tryGetSeriesNumber();
    }

    public LogicalImageSeriesPoint(Float tOrNull, Float zOrNull, Integer seriesNumberOrNull) {
        this.tOrNull = tOrNull;
        this.zOrNull = zOrNull;
        this.seriesNumberOrNull = seriesNumberOrNull;
    }

    public String getLabel() {
        String desc = "";
        if (this.isSeriesNumberPresent()) {
            if (desc.length() > 0) {
                desc = desc + ". ";
            }
            desc = desc + "Series: " + this.seriesNumberOrNull;
        }
        if (this.isTimePointPresent()) {
            if (desc.length() > 0) {
                desc = desc + ". ";
            }
            desc = desc + "Time: " + this.tOrNull + " sec";
        }
        if (this.isDepthPresent()) {
            if (desc.length() > 0) {
                desc = desc + ". ";
            }
            desc = desc + "Depth: " + this.zOrNull;
        }
        return desc;
    }

    private boolean isDepthPresent() {
        return this.zOrNull != null;
    }

    Float getDepthOrNull() {
        return this.zOrNull;
    }

    private boolean isTimePointPresent() {
        return this.tOrNull != null;
    }

    Float getTimePointOrNull() {
        return this.tOrNull;
    }

    private boolean isSeriesNumberPresent() {
        return this.seriesNumberOrNull != null;
    }

    Integer getSeriesNumberOrNull() {
        return this.seriesNumberOrNull;
    }

    @Override
    public int compareTo(LogicalImageSeriesPoint o) {
        int cmp = LogicalImageSeriesPoint.compareNullable(this.seriesNumberOrNull, o.seriesNumberOrNull);
        if (cmp != 0) {
            return cmp;
        }
        cmp = LogicalImageSeriesPoint.compareNullable(this.tOrNull, o.tOrNull);
        if (cmp != 0) {
            return cmp;
        }
        return LogicalImageSeriesPoint.compareNullable(this.zOrNull, o.zOrNull);
    }

    private static <T extends Comparable<T>> int compareNullable(T v1OrNull, T v2OrNull) {
        if (v1OrNull == null) {
            return v2OrNull == null ? 0 : -1;
        }
        return v2OrNull == null ? 1 : v1OrNull.compareTo(v2OrNull);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isSeriesNumberPresent() ? this.seriesNumberOrNull.hashCode() : 0);
        result = 31 * result + (this.isTimePointPresent() ? this.tOrNull.hashCode() : 0);
        result = 31 * result + (this.isDepthPresent() ? this.zOrNull.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogicalImageSeriesPoint other = (LogicalImageSeriesPoint)obj;
        if (!this.isSeriesNumberPresent() ? other.isSeriesNumberPresent() : !this.seriesNumberOrNull.equals(other.seriesNumberOrNull)) {
            return false;
        }
        if (!this.isTimePointPresent() ? other.isTimePointPresent() : !this.tOrNull.equals(other.tOrNull)) {
            return false;
        }
        return !(!this.isDepthPresent() ? other.isDepthPresent() : !this.zOrNull.equals(other.zOrNull));
    }
}

