/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ExperimentAnalysisSummaryViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.ScreeningResolverUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ExperimentAnalysisSummaryResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<IScreeningClientServiceAsync> viewContext;

    public ExperimentAnalysisSummaryResolver(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super("FEATURE_VECTOR_SUMMARY");
        this.viewContext = viewContext;
    }

    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        try {
            String experimentPermId = this.tryGetPermId(locator);
            this.viewContext.getCommonService().getEntityInformationHolder(EntityKind.EXPERIMENT, experimentPermId, (AsyncCallback)new AbstractViewLocatorResolver.LocatorExistsCallback((AbstractViewLocatorResolver)this, callback));
        }
        catch (UserFailureException e) {
            callback.onFailure(null);
        }
    }

    public void resolve(ViewLocator locator) throws UserFailureException {
        String experimentPermId = this.tryGetPermId(locator);
        boolean restrictGlobalScopeLinkToProject = ExperimentAnalysisSummaryResolver.getOptionalBooleanParameter((ViewLocator)locator, (String)"restrictGlobalSearchToProject", (boolean)false);
        WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria = ScreeningResolverUtils.extractAnalysisProcedureCriteria(locator);
        ExperimentAnalysisSummaryViewer.openTab(this.viewContext, experimentPermId, restrictGlobalScopeLinkToProject, analysisProcedureCriteria);
    }

    protected String tryGetPermId(ViewLocator locator) {
        return ExperimentAnalysisSummaryResolver.getMandatoryParameter((ViewLocator)locator, (String)"experimentPermId");
    }
}

