/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.MaterialCodeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellSearchComponent;
import com.extjs.gxt.ui.client.widget.ContentPanel;

public class GlobalWellSearchLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<IScreeningClientServiceAsync> viewContext;

    public GlobalWellSearchLocatorResolver(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super("GLOBAL_WELL_SEARCH");
        this.viewContext = viewContext;
    }

    public void resolve(final ViewLocator locator) throws UserFailureException {
        DispatcherHelper.dispatchNaviEvent((AbstractTabItemFactory)new AbstractTabItemFactory(){

            public String getId() {
                return "openbis_-screening-GLOBAL_WELL_SEARCH";
            }

            public ITabItem create() {
                String materialsList = GlobalWellSearchLocatorResolver.getOptionalParameter((ViewLocator)locator, (String)"items");
                if (materialsList != null) {
                    materialsList = MaterialCodeUtils.decode((String)materialsList);
                }
                Boolean exactMatchOnly = GlobalWellSearchLocatorResolver.getOptionalBooleanParameter((ViewLocator)locator, (String)"isExactSearch");
                boolean showCombinedResults = GlobalWellSearchLocatorResolver.getOptionalBooleanParameter((ViewLocator)locator, (String)"showCombinedResults", (boolean)true);
                WellSearchComponent wellSearchTab = new WellSearchComponent((IViewContext<IScreeningClientServiceAsync>)GlobalWellSearchLocatorResolver.this.viewContext, materialsList, exactMatchOnly, showCombinedResults);
                return DefaultTabItem.createUnaware((ContentPanel)wellSearchTab, (boolean)false, (IViewContext)GlobalWellSearchLocatorResolver.this.viewContext);
            }

            public String tryGetLink() {
                return locator.getHistoryToken();
            }

            public String getTabTitle() {
                return WellSearchComponent.getTabTitle((IViewContext<IScreeningClientServiceAsync>)GlobalWellSearchLocatorResolver.this.viewContext);
            }

            public HelpPageIdentifier getHelpPageIdentifier() {
                return null;
            }
        });
    }

    public static String createQueryBrowserLink() {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", (Object)"GLOBAL_WELL_SEARCH");
        return url.toStringWithoutDelimiterPrefix();
    }
}

