/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.PermlinkLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ImagingDataSetLocatorResolver
extends PermlinkLocatorResolver {
    private final IViewContext<IScreeningClientServiceAsync> viewContext;

    public ImagingDataSetLocatorResolver(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super(viewContext.getCommonViewContext());
        this.viewContext = viewContext;
    }

    public boolean canHandleLocator(ViewLocator locator) {
        String entityKindValueOrNull = this.tryGetEntityKind(locator);
        String permIdValueOrNull = this.tryGetPermId(locator);
        return super.canHandleLocator(locator) && (EntityKind.DATA_SET.name().equals(entityKindValueOrNull) || EntityKind.SAMPLE.name().equals(entityKindValueOrNull)) && permIdValueOrNull != null && permIdValueOrNull.contains(":");
    }

    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        int idx;
        EntityKind entityKindValueOrNull = this.tryGetEntityKindEnum(locator);
        String permIdValueOrNull = this.tryGetPermId(locator);
        if (entityKindValueOrNull != null && permIdValueOrNull != null && (idx = permIdValueOrNull.indexOf(58)) != -1) {
            this.viewContext.getCommonService().getEntityInformationHolder(entityKindValueOrNull, permIdValueOrNull.substring(0, idx), (AsyncCallback)new AbstractViewLocatorResolver.LocatorExistsCallback((AbstractViewLocatorResolver)this, callback));
            return;
        }
        callback.onFailure(null);
    }

    protected void openInitialEntityViewer(String entityKindValue, String permIdValue) throws UserFailureException {
        EntityKind entityKind = ImagingDataSetLocatorResolver.getEntityKind((String)entityKindValue);
        int idx = permIdValue.indexOf(58);
        this.viewContext.getCommonService().getEntityInformationHolder(entityKind, permIdValue.substring(0, idx), (AsyncCallback)new OpenEntityDetailsTabCallback(this.viewContext, permIdValue.substring(idx + 1)));
    }

    private static class OpenEntityDetailsTabCallback
    extends AbstractAsyncCallback<IEntityInformationHolderWithPermId> {
        private final String wellLocation;

        private OpenEntityDetailsTabCallback(IViewContext<?> viewContext, String wellLocation) {
            super(viewContext);
            this.wellLocation = wellLocation;
        }

        protected final void process(final IEntityInformationHolderWithPermId result) {
            new OpenEntityDetailsTabAction(new IEntityInformationHolderWithPermId(){
                private static final long serialVersionUID = 1L;

                public BasicEntityType getEntityType() {
                    return result.getEntityType();
                }

                public EntityKind getEntityKind() {
                    return result.getEntityKind();
                }

                public Long getId() {
                    return result.getId();
                }

                public String getCode() {
                    return result.getCode();
                }

                public String getPermId() {
                    return result.getPermId() + ":" + wellLocation;
                }
            }, this.viewContext, false).execute();
        }
    }
}

