/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.MaterialLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.ScreeningResolverUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.dto.ExperimentIdentifierSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ImagingMaterialLocatorResolver
extends MaterialLocatorResolver {
    private final IViewContext<IScreeningClientServiceAsync> viewContext;
    private static final String EMPTY_EXPERIMENT_IDENTIFIER = "";

    public ImagingMaterialLocatorResolver(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super(viewContext.getCommonViewContext());
        this.viewContext = viewContext;
    }

    public void resolve(ViewLocator locator) throws UserFailureException {
        assert (EntityKind.MATERIAL.name().equals(locator.tryGetEntity()));
        ExperimentIdentifierSearchCriteria experimentCriteriaOrNull = ImagingMaterialLocatorResolver.tryGetExperimentIdentifierSearchCriteria(locator);
        WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria = ScreeningResolverUtils.extractAnalysisProcedureCriteria(locator);
        boolean computeRanks = ImagingMaterialLocatorResolver.getOptionalBooleanParameter((ViewLocator)locator, (String)"computeRanks", (boolean)false);
        this.openInitialMaterialViewer(this.extractMaterialIdentifier(locator), experimentCriteriaOrNull, analysisProcedureCriteria, computeRanks);
    }

    private static ExperimentIdentifierSearchCriteria tryGetExperimentIdentifierSearchCriteria(ViewLocator locator) {
        String experimentIdentifierOrNull = ImagingMaterialLocatorResolver.getOptionalParameter((ViewLocator)locator, (String)"experiment");
        boolean experimentIdentifierSpecified = locator.getParameters().containsKey("experiment");
        if (experimentIdentifierSpecified) {
            if (experimentIdentifierOrNull == null || experimentIdentifierOrNull.trim().length() == 0) {
                experimentIdentifierOrNull = EMPTY_EXPERIMENT_IDENTIFIER;
            }
            boolean restrictGlobalSearchToProject = ImagingMaterialLocatorResolver.getOptionalBooleanParameter((ViewLocator)locator, (String)"restrictGlobalSearchToProject", (boolean)false);
            return ExperimentIdentifierSearchCriteria.createExperimentScope(experimentIdentifierOrNull, restrictGlobalSearchToProject);
        }
        String space = ImagingMaterialLocatorResolver.getOptionalParameter((ViewLocator)locator, (String)"spaceCode");
        String project = ImagingMaterialLocatorResolver.getOptionalParameter((ViewLocator)locator, (String)"projectCode");
        if (!StringUtils.isBlank((String)space) && !StringUtils.isBlank((String)project)) {
            return ExperimentIdentifierSearchCriteria.createProjectScope(new BasicProjectIdentifier(space, project));
        }
        boolean searchAllExp = ImagingMaterialLocatorResolver.getOptionalBooleanParameter((ViewLocator)locator, (String)"searchAllExperiments", (boolean)false);
        if (searchAllExp) {
            return ExperimentIdentifierSearchCriteria.createSearchAll();
        }
        return null;
    }

    protected void openInitialMaterialViewer(MaterialIdentifier identifier, ExperimentIdentifierSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks) throws UserFailureException {
        this.viewContext.getCommonService().getMaterialInformationHolder(identifier, (AsyncCallback)new OpenEntityDetailsTabCallback(this.viewContext, experimentCriteriaOrNull, analysisProcedureCriteria, computeRanks));
    }

    private static class OpenEntityDetailsTabCallback
    extends AbstractAsyncCallback<IEntityInformationHolderWithPermId> {
        private final ExperimentIdentifierSearchCriteria scopeOrNull;
        private final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;
        private boolean computeRanks;

        private OpenEntityDetailsTabCallback(IViewContext<IScreeningClientServiceAsync> viewContext, ExperimentIdentifierSearchCriteria scopeOrNull, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks) {
            super(viewContext);
            this.scopeOrNull = scopeOrNull;
            this.analysisProcedureCriteria = analysisProcedureCriteria;
            this.computeRanks = computeRanks;
        }

        protected final void process(IEntityInformationHolderWithPermId material) {
            if (this.scopeOrNull == null) {
                this.openImagingMaterialViewer(material, null);
            } else {
                String experimentIdentifier = this.scopeOrNull.tryGetExperimentIdentifier();
                BasicProjectIdentifier project = this.scopeOrNull.tryGetProject();
                if (experimentIdentifier != null) {
                    if (ImagingMaterialLocatorResolver.EMPTY_EXPERIMENT_IDENTIFIER.equals(experimentIdentifier)) {
                        this.openImagingMaterialViewer(material, WellSearchCriteria.ExperimentSearchCriteria.createExperiment(WellSearchCriteria.SingleExperimentSearchCriteria.EMPTY_CRITERIA, this.scopeOrNull.getRestrictGlobalSearchLinkToProject()));
                    } else {
                        this.fetchExperimentAndShowLocations(material, experimentIdentifier);
                    }
                } else if (project != null) {
                    this.openImagingMaterialViewer(material, WellSearchCriteria.ExperimentSearchCriteria.createAllExperimentsForProject(project));
                } else {
                    this.openImagingMaterialViewer(material, WellSearchCriteria.ExperimentSearchCriteria.createAllExperiments());
                }
            }
        }

        private void fetchExperimentAndShowLocations(final IEntityInformationHolderWithPermId material, String experimentIdentifier) {
            IViewContext<IScreeningClientServiceAsync> context = this.getViewContext();
            context.getCommonService().getExperimentInfo(experimentIdentifier, (AsyncCallback)new AbstractAsyncCallback<Experiment>(context){

                protected void process(Experiment experiment) {
                    WellSearchCriteria.ExperimentSearchCriteria experimentCriteria = WellSearchCriteria.ExperimentSearchCriteria.createExperiment((IEntityInformationHolderWithIdentifier)experiment, scopeOrNull.getRestrictGlobalSearchLinkToProject());
                    this.openImagingMaterialViewer(material, experimentCriteria);
                }
            });
        }

        private final void openImagingMaterialViewer(IEntityInformationHolderWithPermId material, WellSearchCriteria.ExperimentSearchCriteria experimentSearchCriteriaOrNull) {
            ClientPluginFactory.openImagingMaterialViewer(material, experimentSearchCriteriaOrNull, this.analysisProcedureCriteria, this.computeRanks, this.getViewContext());
        }

        private IViewContext<IScreeningClientServiceAsync> getViewContext() {
            return this.viewContext;
        }
    }
}

