/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.PlateMetadataBrowser;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class PlateMetadataBrowserLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<IScreeningClientServiceAsync> viewContext;

    public PlateMetadataBrowserLocatorResolver(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super("PLATE_METADATA_REPORT");
        this.viewContext = viewContext;
    }

    public boolean canHandleLocator(ViewLocator locator) {
        return super.canHandleLocator(locator) && this.tryExtractPlatePermId(locator) != null;
    }

    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        String platePermId = this.tryExtractPlatePermId(locator);
        if (platePermId != null) {
            this.viewContext.getCommonService().getEntityInformationHolder(EntityKind.SAMPLE, platePermId, (AsyncCallback)new AbstractViewLocatorResolver.LocatorExistsCallback((AbstractViewLocatorResolver)this, callback));
        } else {
            callback.onFailure(null);
        }
    }

    private String tryExtractPlatePermId(ViewLocator locator) {
        return (String)locator.getParameters().get("permId");
    }

    public void resolve(ViewLocator locator) throws UserFailureException {
        String platePermId = this.tryExtractPlatePermId(locator);
        PlateMetadataBrowser.openTab(platePermId, this.viewContext);
    }
}

