/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.MaterialCodeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.URLListEncoder;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellSearchGrid;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.ScreeningResolverUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;

public class WellSearchLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<IScreeningClientServiceAsync> viewContext;

    public WellSearchLocatorResolver(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super("WELL_SEARCH");
        this.viewContext = viewContext;
    }

    public void resolve(ViewLocator locator) throws UserFailureException {
        String experimentPermId = WellSearchLocatorResolver.getOptionalParameter((ViewLocator)locator, (String)"experimentPermId");
        String projectCode = WellSearchLocatorResolver.getOptionalParameter((ViewLocator)locator, (String)"projectCode");
        String spaceCode = WellSearchLocatorResolver.getOptionalParameter((ViewLocator)locator, (String)"spaceCode");
        String materialCodesOrProperties = WellSearchLocatorResolver.getMandatoryParameter((ViewLocator)locator, (String)"items");
        String materialTypeCodes = WellSearchLocatorResolver.getMandatoryParameter((ViewLocator)locator, (String)"types");
        boolean exactMatchOnly = WellSearchLocatorResolver.getMandatoryBooleanParameter((ViewLocator)locator, (String)"isExactSearch");
        boolean showCombinedResults = WellSearchLocatorResolver.getOptionalBooleanParameter((ViewLocator)locator, (String)"showCombinedResults", (boolean)true);
        String nothingFoundRedirectionUrlOrNull = WellSearchLocatorResolver.getOptionalParameter((ViewLocator)locator, (String)"noResultsRedirectionUrl");
        String[] materialCodes = MaterialCodeUtils.decodeList((String)materialCodesOrProperties);
        WellSearchCriteria.MaterialSearchCodesCriteria materialCodesCriteria = new WellSearchCriteria.MaterialSearchCodesCriteria(materialCodes, this.decodeList(materialTypeCodes), exactMatchOnly);
        WellSearchCriteria.MaterialSearchCriteria materialSearchCriteria = WellSearchCriteria.MaterialSearchCriteria.create(materialCodesCriteria);
        WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria = ScreeningResolverUtils.extractAnalysisProcedureCriteria(locator);
        if (StringUtils.isBlank((String)experimentPermId)) {
            WellSearchCriteria.ExperimentSearchCriteria criteria = StringUtils.isBlank((String)projectCode) || StringUtils.isBlank((String)spaceCode) ? WellSearchCriteria.ExperimentSearchCriteria.createAllExperiments() : WellSearchCriteria.ExperimentSearchCriteria.createAllExperimentsForProject(new BasicProjectIdentifier(spaceCode, projectCode));
            WellSearchGrid.openTab(this.viewContext, criteria, materialSearchCriteria, analysisProcedureCriteria, showCombinedResults, nothingFoundRedirectionUrlOrNull);
        } else {
            WellSearchGrid.openTab(this.viewContext, experimentPermId, materialSearchCriteria, analysisProcedureCriteria, showCombinedResults, nothingFoundRedirectionUrlOrNull);
        }
    }

    private String[] decodeList(String itemsList) {
        return URLListEncoder.decodeItemList((String)itemsList);
    }
}

