/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.VocabularyTermModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractBatchRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ExperimentChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VocabularyTermSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LibraryRegistrationInfo;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.io.Serializable;
import java.util.List;

public final class LibrarySampleBatchRegistrationForm
extends AbstractBatchRegistrationForm {
    private static final String PLATES = "Plates";
    private static final String SIRNAS_PLATES = "siRNAs + Plates";
    private static final String GENES_SIRNAS_PLATES = "Genes + siRNAs + Plates";
    private static final String SESSION_KEY = "qiagen-library-sample-batch-registration";
    private final ExperimentChooserField.ExperimentChooserFieldAdaptor experimentChooser;
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final PlateGeometrySelectionWidget plateGeometryField;
    private final SimpleComboBox<String> scopeField;
    private final SimpleComboBox<Separator> separatorField;

    public LibrarySampleBatchRegistrationForm(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super(viewContext.getCommonViewContext(), "openbis_qiagen-library-sample-batch-registration", SESSION_KEY);
        this.setResetButtonVisible(true);
        this.screeningViewContext = viewContext;
        this.experimentChooser = ExperimentChooserField.create((String)viewContext.getMessage("experiment", new Object[0]), (boolean)true, null, (IViewContext)viewContext.getCommonViewContext());
        this.plateGeometryField = this.createPlateGeometryField();
        this.scopeField = this.createScopeField();
        this.separatorField = this.createSeparatorField();
    }

    private SimpleComboBox<String> createScopeField() {
        SimpleComboBox options = new SimpleComboBox();
        options.add((Object)GENES_SIRNAS_PLATES);
        options.add((Object)SIRNAS_PLATES);
        options.add((Object)PLATES);
        options.setFieldLabel(this.viewContext.getMessage("register", new Object[0]));
        options.setTriggerAction(ComboBox.TriggerAction.ALL);
        options.setForceSelection(true);
        options.setEditable(false);
        options.setAllowBlank(false);
        options.setSimpleValue((Object)GENES_SIRNAS_PLATES);
        FieldUtil.markAsMandatory((TextField)options);
        return options;
    }

    private SimpleComboBox<Separator> createSeparatorField() {
        SimpleComboBox options = new SimpleComboBox();
        for (Separator separator : Separator.values()) {
            options.add((Object)separator);
        }
        options.setFieldLabel(this.viewContext.getMessage("separator", new Object[0]));
        options.setTriggerAction(ComboBox.TriggerAction.ALL);
        options.setForceSelection(true);
        options.setEditable(false);
        options.setAllowBlank(false);
        options.setSimpleValue((Object)Separator.COMMA);
        FieldUtil.markAsMandatory((TextField)options);
        return options;
    }

    protected void save() {
        ExperimentIdentifier experiment = this.experimentChooser.tryToGetValue();
        VocabularyTermModel value = (VocabularyTermModel)this.plateGeometryField.getValue();
        String plateGeometry = value == null ? null : value.getTerm().getCode();
        char separator = this.extractSeparatorCharacter();
        LibraryRegistrationInfo.RegistrationScope registrationScope = this.extractRegistrationScope();
        LibraryRegistrationInfo libraryInfo = new LibraryRegistrationInfo().setExperiment(experiment.getIdentifier()).setPlateGeometry(plateGeometry).setScope(registrationScope).setSeparator(separator);
        ((IScreeningClientServiceAsync)this.screeningViewContext.getService()).registerLibrary(libraryInfo, SESSION_KEY, this.isAsync(), (String)this.emailField.getValue(), (AsyncCallback<List<BatchRegistrationResult>>)new AbstractBatchRegistrationForm.BatchRegistrationCallback((AbstractBatchRegistrationForm)this, this.viewContext));
        this.infoBox.displayInfo("Data preprocessing started. Please wait...");
    }

    private char extractSeparatorCharacter() {
        Separator separator = (Separator)((SimpleComboValue)this.separatorField.getValue()).getValue();
        return separator.asChar();
    }

    private LibraryRegistrationInfo.RegistrationScope extractRegistrationScope() {
        String value = (String)((SimpleComboValue)this.scopeField.getValue()).getValue();
        if (value.equals(GENES_SIRNAS_PLATES)) {
            return LibraryRegistrationInfo.RegistrationScope.GENES_SIRNAS_PLATES;
        }
        if (value.equals(SIRNAS_PLATES)) {
            return LibraryRegistrationInfo.RegistrationScope.SIRNAS_PLATES;
        }
        if (value.equals(PLATES)) {
            return LibraryRegistrationInfo.RegistrationScope.PLATES;
        }
        return null;
    }

    protected LabelField createTemplateField() {
        return null;
    }

    protected void addSpecificFormFields(FormPanel form) {
        form.add((Widget)this.experimentChooser.getChooserField());
        form.add((Widget)this.plateGeometryField);
        form.add(this.scopeField);
        form.add(this.separatorField);
    }

    private PlateGeometrySelectionWidget createPlateGeometryField() {
        PlateGeometrySelectionWidget field = new PlateGeometrySelectionWidget(this.screeningViewContext);
        field.setFieldLabel("Plate Geometry");
        FieldUtil.markAsMandatory((TextField)field);
        return field;
    }

    private static final class PlateGeometrySelectionWidget
    extends VocabularyTermSelectionWidget {
        PlateGeometrySelectionWidget(IViewContext<IScreeningClientServiceAsync> viewContext) {
            super("plateGeometry", "plateGeometry", false, null, viewContext, null, null);
            this.setAllowBlank(false);
            this.setForceSelection(true);
            ((IScreeningClientServiceAsync)viewContext.getService()).getPlateGeometryVocabulary((AsyncCallback<Vocabulary>)new AbstractAsyncCallback<Vocabulary>(viewContext){

                protected void process(Vocabulary vocabulary) {
                    this.setVocabulary(vocabulary);
                }
            });
        }
    }

    public static enum Separator implements Serializable
    {
        TAB('\t'),
        COMMA(','),
        SEMICOLON(';');

        final char character;

        private Separator(char character) {
            this.character = character;
        }

        public char asChar() {
            return this.character;
        }

        public String toString() {
            return this.name() + " (" + this.character + ")";
        }
    }
}

