/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.URLListEncoder;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.dto.ExperimentIdentifierSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;

public class ScreeningLinkExtractor
extends LinkExtractor {
    public static final String PLATE_METADATA_BROWSER_ACTION = "PLATE_METADATA_REPORT";
    public static final String MATERIAL_DETAIL_EXPERIMENT_IDENT_PARAMETER_KEY = "experiment";
    public static final String MATERIAL_DETAIL_SEARCH_ALL_EXPERIMENTS_PARAMETER_KEY = "searchAllExperiments";
    public static final String MATERIAL_DETAIL_SEARCH_ALL_EXPERIMENTS_PARAMETER_VALUE = "true";
    public static final String GLOBAL_WELL_SEARCH_ACTION = "GLOBAL_WELL_SEARCH";
    public static final String WELL_SEARCH_ACTION = "WELL_SEARCH";
    public static final String WELL_SEARCH_EXPERIMENT_PERM_ID_PARAMETER_KEY = "experimentPermId";
    public static final String WELL_SEARCH_IS_EXACT_PARAMETER_KEY = "isExactSearch";
    public static final String WELL_SEARCH_MATERIAL_TYPES_PARAMETER_KEY = "types";
    public static final String WELL_SEARCH_MATERIAL_ITEMS_PARAMETER_KEY = "items";
    public static final String WELL_SEARCH_SHOW_COMBINED_RESULTS_PARAMETER_KEY = "showCombinedResults";
    public static final boolean WELL_SEARCH_SHOW_COMBINED_RESULTS_DEFAULT = true;
    public static final String WELL_SEARCH_NOTHING_FOUND_REDIRECTION_URL_KEY = "noResultsRedirectionUrl";
    public static final String EXPERIMENT_ANALYSIS_SUMMARY_ACTION = "FEATURE_VECTOR_SUMMARY";
    public static final String EXPERIMENT_ANALYSIS_SUMMARY_EXPERIMENT_PERMID_PARAMETER_KEY = "experimentPermId";
    public static final String MATERIAL_REPLICA_SUMMARY_EXPERIMENT_PERM_ID_KEY = "experimentPermId";
    public static final String MATERIAL_CODE_KEY = "materialCode";
    public static final String MATERIAL_TYPE_CODE_KEY = "materialTypeCode";
    public static final String PROJECT_CODE_KEY = "projectCode";
    public static final String SPACE_CODE_KEY = "spaceCode";
    public static final String RESTRICT_GLOBAL_SEARCH_TO_PROJECT = "restrictGlobalSearchToProject";
    public static final String ANALYSIS_PROCEDURE_KEY = "analysisProcedure";
    public static final String COMPUTE_RANKS_KEY = "computeRanks";

    public static final String createPlateMetadataBrowserLink(String platePermId) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", (Object)PLATE_METADATA_BROWSER_ACTION);
        url.addParameter("permId", (Object)platePermId);
        return ScreeningLinkExtractor.tryPrint((URLMethodWithParameters)url);
    }

    public static final String createExperimentAnalysisSummaryBrowserLink(String experimentPermId, boolean restrictGlobalScopeLinkToProject, String analysisProcedureOrNull) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", (Object)EXPERIMENT_ANALYSIS_SUMMARY_ACTION);
        url.addParameter("experimentPermId", (Object)experimentPermId);
        if (restrictGlobalScopeLinkToProject) {
            url.addParameterWithoutEncoding(RESTRICT_GLOBAL_SEARCH_TO_PROJECT, (Object)restrictGlobalScopeLinkToProject);
        }
        if (StringUtils.isNotBlank((String)analysisProcedureOrNull)) {
            url.addParameter(ANALYSIS_PROCEDURE_KEY, (Object)analysisProcedureOrNull);
        }
        return ScreeningLinkExtractor.tryPrint((URLMethodWithParameters)url);
    }

    public static String tryCreateWellsSearchLink(WellSearchCriteria searchCriteria, boolean showCombinedResults) {
        WellSearchCriteria.MaterialSearchCodesCriteria materialCodesOrProperties = searchCriteria.getMaterialSearchCriteria().tryGetMaterialCodesOrProperties();
        if (materialCodesOrProperties == null) {
            return null;
        }
        return ScreeningLinkExtractor.createWellsSearchLink(searchCriteria.getExperimentCriteria(), materialCodesOrProperties, showCombinedResults);
    }

    public static String createWellsSearchLink(WellSearchCriteria.ExperimentSearchCriteria experimentCriteria, WellSearchCriteria.MaterialSearchCodesCriteria materialCodesCriteria, Boolean showCombinedResults) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", (Object)WELL_SEARCH_ACTION);
        WellSearchCriteria.SingleExperimentSearchCriteria experiment = experimentCriteria.tryGetExperiment();
        BasicProjectIdentifier project = experimentCriteria.tryGetProjectIdentifier();
        if (experiment != null) {
            url.addParameter("experimentPermId", (Object)experiment.getExperimentPermId());
        }
        if (project != null) {
            url.addParameterWithoutEncoding(SPACE_CODE_KEY, (Object)project.getSpaceCode());
            url.addParameterWithoutEncoding(PROJECT_CODE_KEY, (Object)project.getProjectCode());
        }
        url.addParameter(WELL_SEARCH_IS_EXACT_PARAMETER_KEY, (Object)materialCodesCriteria.isExactMatchOnly());
        url.addParameterWithoutEncoding(WELL_SEARCH_MATERIAL_TYPES_PARAMETER_KEY, (Object)URLListEncoder.encodeItemList((String[])materialCodesCriteria.getMaterialTypeCodes()));
        url.addParameterWithoutEncoding(WELL_SEARCH_MATERIAL_ITEMS_PARAMETER_KEY, (Object)URLListEncoder.encodeItemList((String[])materialCodesCriteria.getMaterialCodesOrProperties()));
        url.addParameterWithoutEncoding(WELL_SEARCH_SHOW_COMBINED_RESULTS_PARAMETER_KEY, (Object)showCombinedResults);
        return ScreeningLinkExtractor.tryPrint((URLMethodWithParameters)url);
    }

    private static ExperimentIdentifierSearchCriteria convertToIdentifierExperimentCriteria(WellSearchCriteria.ExperimentSearchCriteria experimentSearchCriteria) {
        WellSearchCriteria.SingleExperimentSearchCriteria experiment = experimentSearchCriteria.tryGetExperiment();
        BasicProjectIdentifier project = experimentSearchCriteria.tryGetProjectIdentifier();
        if (experiment != null) {
            return ExperimentIdentifierSearchCriteria.createExperimentScope(experiment.getExperimentIdentifier(), experimentSearchCriteria.getRestrictGlobalSearchLinkToProject());
        }
        if (project != null) {
            return ExperimentIdentifierSearchCriteria.createProjectScope(project);
        }
        return ExperimentIdentifierSearchCriteria.createSearchAll();
    }

    public static final String createMaterialDetailsLink(IEntityInformationHolder material, ExperimentIdentifierSearchCriteria experimentCriteriaOrNull) {
        URLMethodWithParameters url = ScreeningLinkExtractor.createMaterialDetailsLink(material.getCode(), material.getEntityType().getCode(), experimentCriteriaOrNull);
        return ScreeningLinkExtractor.tryPrint((URLMethodWithParameters)url);
    }

    private static final URLMethodWithParameters createMaterialDetailsLink(String materialCode, String materialTypeCode, ExperimentIdentifierSearchCriteria experimentCriteriaOrNull) {
        assert (materialCode != null);
        assert (materialTypeCode != null);
        URLMethodWithParameters url = ScreeningLinkExtractor.tryCreateMaterialLink((String)materialCode, (String)materialTypeCode);
        assert (url != null) : "url is null";
        if (experimentCriteriaOrNull != null) {
            if (experimentCriteriaOrNull.searchAllExperiments()) {
                url.addParameter(MATERIAL_DETAIL_SEARCH_ALL_EXPERIMENTS_PARAMETER_KEY, (Object)MATERIAL_DETAIL_SEARCH_ALL_EXPERIMENTS_PARAMETER_VALUE);
            } else {
                BasicProjectIdentifier project = experimentCriteriaOrNull.tryGetProject();
                if (project != null) {
                    url.addParameterWithoutEncoding(SPACE_CODE_KEY, (Object)project.getSpaceCode());
                    url.addParameterWithoutEncoding(PROJECT_CODE_KEY, (Object)project.getProjectCode());
                } else {
                    url.addParameterWithoutEncoding(MATERIAL_DETAIL_EXPERIMENT_IDENT_PARAMETER_KEY, (Object)StringEscapeUtils.unescapeHtml((String)experimentCriteriaOrNull.tryGetExperimentIdentifier()));
                    if (experimentCriteriaOrNull.getRestrictGlobalSearchLinkToProject()) {
                        url.addParameterWithoutEncoding(RESTRICT_GLOBAL_SEARCH_TO_PROJECT, (Object)MATERIAL_DETAIL_SEARCH_ALL_EXPERIMENTS_PARAMETER_VALUE);
                    }
                }
            }
        }
        return url;
    }

    public static String createMaterialDetailsLink(IEntityInformationHolder material, WellSearchCriteria.ExperimentSearchCriteria experimentSearchCriteria) {
        ExperimentIdentifierSearchCriteria experimentCriteria = ScreeningLinkExtractor.convertToIdentifierExperimentCriteria(experimentSearchCriteria);
        return ScreeningLinkExtractor.createMaterialDetailsLink(material, experimentCriteria);
    }
}

