/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ImageViewerLaunchServlet
extends AbstractServlet {
    public static final Template JNLP_TEMPLATE = new Template("<?xml version='1.0' encoding='utf-8'?>\n<jnlp spec='1.0+' codebase='${base-URL}'>\n  <information>\n    <title>${title}</title>\n    <vendor>SyBIT</vendor>\n    <description>${description}</description>\n  </information>\n  <security>\n    <all-permissions/>\n  </security>\n  <resources>\n    <j2se version='1.5+'/>\n    <jar href='openbis.jar'/>\n    <jar href='sis-base.jar'/>\n    <jar href='image-viewer.jar'/>\n    <jar href='spring-aop.jar'/>\n    <jar href='spring-beans.jar'/>\n    <jar href='spring-context.jar'/>\n    <jar href='spring-core.jar'/>\n    <jar href='spring-web.jar'/>\n    <jar href='spring-webmvc.jar'/>\n    <jar href='spring-expression.jar'/>\n    <jar href='aopalliance.jar'/>\n    <jar href='stream-supporting-httpinvoker.jar'/>\n    <jar href='commons-codec.jar'/>\n    <jar href='httpclient.jar'/>\n    <jar href='httpcore.jar'/>\n    <jar href='commons-io.jar'/>\n    <jar href='commons-lang.jar'/>\n    <jar href='commons-logging.jar'/>\n    <jar href='ij.jar'/>\n    <jar href='jython.jar'/>\n  </resources>\n  <application-desc main-class='${main-class}'>\n    <argument>${service-URL}</argument>\n    <argument>${session-id}</argument>\n    <argument>${experiment}</argument>\n    <argument>${channel}</argument>\n${data-set-and-wells-arguments}\n  </application-desc>\n</jnlp>\n");
    private final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ((Object)((Object)this)).getClass());

    @RequestMapping(value={"/image-viewer-launch", "/openbis/image-viewer-launch"})
    protected void respondToRequest(HttpServletRequest request, HttpServletResponse response) throws Exception, IOException {
        try {
            response.setContentType("application/x-java-jnlp-file");
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            Template template = JNLP_TEMPLATE.createFreshCopy();
            template.bind("title", "Image Viewer");
            template.bind("description", "Image Viewer for color adjustment.");
            String basicURL = this.getBasicURL(request);
            template.bind("base-URL", basicURL);
            template.bind("main-class", this.getMainClass());
            template.bind("service-URL", this.getServiceURL(request));
            template.bind("experiment", this.getParam(request, "experiment-id"));
            String sessionToken = this.getSessionToken(request);
            template.bind("session-id", sessionToken);
            String channel = this.getParam(request, "channel");
            template.bind("channel", channel);
            StringBuilder builder = new StringBuilder();
            for (String dataSetAndWells : this.getParams(request, "data-set-and-wells")) {
                builder.append("    <argument>").append(dataSetAndWells).append("</argument>\n");
            }
            template.bind("data-set-and-wells-arguments", builder.toString());
            writer.print(template.createText());
            writer.close();
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info((Object)("Start Image Viewer for session " + sessionToken + " and channel " + channel));
            }
        }
        catch (UserFailureException ex) {
            this.operationLog.error((Object)"Couldn't create JNLP file", (Throwable)ex);
            this.printError(response, ex.getMessage());
        }
    }

    private String getMainClass() {
        return "ch.systemsx.sybit.imageviewer.gui.ImageViewer";
    }

    private String getServiceURL(HttpServletRequest request) {
        String url = this.getBasicURL(request);
        try {
            URL baseURL = new URL(url);
            String protocol = baseURL.getProtocol();
            String host = baseURL.getHost();
            int port = baseURL.getPort();
            return new URL(protocol, host, port, "/openbis/openbis/").toString();
        }
        catch (MalformedURLException ex) {
            throw new EnvironmentFailureException("Invalid URL", (Throwable)ex);
        }
    }

    private String getBasicURL(HttpServletRequest request) {
        return this.getParam(request, "server-url");
    }

    private String getParam(HttpServletRequest request, String paramName) {
        String value = request.getParameter(paramName);
        if (value == null) {
            throw new UserFailureException("Missing URL parameter '" + paramName + "'.");
        }
        return value;
    }

    private List<String> getParams(HttpServletRequest request, String paramName) {
        String[] values = request.getParameterValues(paramName);
        if (values == null) {
            throw new UserFailureException("Missing URL parameter '" + paramName + "'.");
        }
        return Arrays.asList(values);
    }

    private void printError(HttpServletResponse response, String errorMessage) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.write("<html><body><b>" + errorMessage + "</b></body></html>");
        writer.flush();
        writer.close();
    }
}

