/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.openbis.common.spring.IUncheckedMultipartFile;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListMaterialDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.UploadedFilesBean;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractMaterialProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.DataProviderAdapter;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ITableModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.MaterialDisambiguationProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AsyncBatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.plugin.screening.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientService;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.LibraryExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset.FeatureVectorSummaryProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset.MaterialFeatureVectorsFromAllExperimentsProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset.MaterialReplicaFeatureSummaryProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset.PlateMetadataProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset.WellContentProvider;
import ch.systemsx.cisd.openbis.plugin.screening.shared.IScreeningServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.AnalysisProcedures;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageSampleContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LibraryRegistrationInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaFeatureSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSimpleFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.NewLibrary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateImages;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellReplicaImage;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Component;

@Component(value="screening-plugin-service")
public final class ScreeningClientService
extends AbstractClientService
implements IScreeningClientService {
    @Resource(name="common-server")
    private ICommonServer commonServer;
    @Resource(name="screening-plugin-server")
    private IScreeningServer server;

    public ScreeningClientService() {
    }

    @Private
    ScreeningClientService(IScreeningServer server, IRequestContextProvider requestContextProvider) {
        super(requestContextProvider);
        this.server = server;
    }

    protected final IServer getServer() {
        return this.server;
    }

    protected String getVersion() {
        return BuildAndEnvironmentInfo.INSTANCE.getFullVersion();
    }

    @Override
    public final SampleParentWithDerived getSampleGenerationInfo(TechId sampleId) throws UserFailureException {
        return this.server.getSampleInfo(this.getSessionToken(), sampleId);
    }

    @Override
    public AbstractExternalData getDataSetInfo(TechId datasetTechId) {
        return this.server.getDataSetInfo(this.getSessionToken(), datasetTechId);
    }

    @Override
    public Material getMaterialInfo(TechId materialTechId) throws UserFailureException {
        return this.server.getMaterialInfo(this.getSessionToken(), materialTechId);
    }

    @Override
    public PlateContent getPlateContent(TechId plateId) throws UserFailureException {
        return this.server.getPlateContent(this.getSessionToken(), plateId);
    }

    @Override
    public FeatureVectorDataset getFeatureVectorDataset(DatasetReference dataset, CodeAndLabel featureName) throws UserFailureException {
        return this.server.getFeatureVectorDataset(this.getSessionToken(), dataset, featureName);
    }

    @Override
    public FeatureVectorValues getWellFeatureVectorValues(String datasetCode, String datastoreCode, WellLocation location) {
        return this.server.getWellFeatureVectorValues(this.getSessionToken(), datasetCode, datastoreCode, location);
    }

    @Override
    public PlateImages getPlateContentForDataset(TechId datasetId) {
        return this.server.getPlateContentForDataset(this.getSessionToken(), datasetId);
    }

    @Override
    public TypedTableResultSet<WellContent> listPlateWells(IResultSetConfig<String, TableModelRowWithObject<WellContent>> gridCriteria, WellSearchCriteria materialCriteria) {
        WellContentProvider provider = new WellContentProvider(this.server, this.getSessionToken(), materialCriteria);
        ResultSet resultSet = this.listEntities(gridCriteria, (IOriginalDataProvider)new DataProviderAdapter((ITableModelProvider)provider));
        return new TypedTableResultSet(resultSet);
    }

    @Override
    public String prepareExportPlateWells(TableExportCriteria<TableModelRowWithObject<WellContent>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public List<WellReplicaImage> listWellImages(TechId materialId, TechId experimentId) throws UserFailureException {
        return this.server.listWellImages(this.getSessionToken(), materialId, experimentId);
    }

    @Override
    public TypedTableResultSet<Material> listMaterials(IResultSetConfig<String, TableModelRowWithObject<Material>> gridCriteria, WellSearchCriteria materialCriteria) {
        List<Material> materials = this.server.listMaterials(this.getSessionToken(), materialCriteria);
        MaterialDisambiguationProvider provider = new MaterialDisambiguationProvider(materials);
        ResultSet resultSet = this.listEntities(gridCriteria, (IOriginalDataProvider)new DataProviderAdapter((ITableModelProvider)provider));
        return new TypedTableResultSet(resultSet);
    }

    @Override
    public String prepareExportMaterials(TableExportCriteria<TableModelRowWithObject<Material>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public TypedTableResultSet<WellMetadata> listPlateMetadata(IResultSetConfig<String, TableModelRowWithObject<WellMetadata>> criteria, TechId sampleId) {
        PlateMetadataProvider metaDataProvider = new PlateMetadataProvider(this.server, this.getSessionToken(), sampleId);
        DataProviderAdapter dataProvider = new DataProviderAdapter((ITableModelProvider)metaDataProvider);
        ResultSet resultSet = this.listEntities(criteria, (IOriginalDataProvider)dataProvider);
        return new TypedTableResultSet(resultSet);
    }

    @Override
    public String prepareExportPlateMetadata(TableExportCriteria<TableModelRowWithObject<WellMetadata>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchRegistrationResult> registerLibrary(LibraryRegistrationInfo details, String sessionKey, boolean async, String userEmail) throws UserFailureException {
        LinkedList<BatchRegistrationResult> results;
        LinkedList<NewLibrary> newLibraries;
        UploadedFilesBean uploadedFiles;
        HttpSession session;
        String sessionToken;
        block4: {
            List list;
            sessionToken = this.getSessionToken();
            session = this.getHttpSession();
            uploadedFiles = null;
            String experiment = details.getExperiment();
            try {
                ExperimentIdentifier experimentIdentifier = new ExperimentIdentifierFactory(experiment).createIdentifier();
                String space = experimentIdentifier.getSpaceCode();
                boolean projectSamplesEnabled = this.server.isProjectSamplesEnabled(sessionToken);
                String sampleProject = projectSamplesEnabled ? experimentIdentifier.getProjectCode() : null;
                uploadedFiles = ScreeningClientService.getUploadedFiles((String)sessionKey, (HttpSession)session);
                newLibraries = new LinkedList<NewLibrary>();
                results = new LinkedList<BatchRegistrationResult>();
                for (IUncheckedMultipartFile file : uploadedFiles.iterable()) {
                    LibraryExtractor extractor = new LibraryExtractor(file.getInputStream(), details.getSeparator(), experiment, space, sampleProject, details.getPlateGeometry(), details.getScope());
                    extractor.extract();
                    NewLibrary newLibrary = new NewLibrary();
                    newLibrary.setNewGenesOrNull(extractor.getNewGenes());
                    newLibrary.setNewOligosOrNull(extractor.getNewOligos());
                    newLibrary.setNewSamplesWithType(extractor.getNewSamplesWithType());
                    newLibraries.add(newLibrary);
                    BatchRegistrationResult result = new BatchRegistrationResult();
                    result.setFileName(file.getOriginalFilename());
                    result.setMessage(String.format("%d gene(s), %d oligo(s) %d sample(s) found and registered.", newLibrary.getNewGenesCount(), newLibrary.getNewOligosCount(), newLibrary.getNewSamplesWithTypeCount()));
                    results.add(result);
                }
                if (!async) break block4;
                this.server.registerLibrariesAsync(sessionToken, newLibraries, userEmail);
                String fileName = ((BatchRegistrationResult)results.get(0)).getFileName();
                list = AsyncBatchRegistrationResult.singletonList((String)fileName);
            }
            catch (Throwable throwable) {
                ScreeningClientService.cleanUploadedFiles((String)sessionKey, (HttpSession)session, uploadedFiles);
                throw throwable;
            }
            ScreeningClientService.cleanUploadedFiles((String)sessionKey, (HttpSession)session, (UploadedFilesBean)uploadedFiles);
            return list;
        }
        this.server.registerLibraries(sessionToken, newLibraries);
        LinkedList<BatchRegistrationResult> linkedList = results;
        ScreeningClientService.cleanUploadedFiles((String)sessionKey, (HttpSession)session, (UploadedFilesBean)uploadedFiles);
        return linkedList;
    }

    @Override
    public Vocabulary getPlateGeometryVocabulary() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.server.getVocabulary(sessionToken, "$PLATE_GEOMETRY");
    }

    @Override
    public LogicalImageInfo getImageDatasetInfo(String datasetCode, String datastoreCode, WellLocation wellLocationOrNull) {
        String sessionToken = this.getSessionToken();
        return this.server.getImageDatasetInfo(sessionToken, datasetCode, datastoreCode, wellLocationOrNull);
    }

    @Override
    public ImageDatasetEnrichedReference getImageDatasetReference(String datasetCode, String datastoreCode) {
        String sessionToken = this.getSessionToken();
        return this.server.getImageDatasetReference(sessionToken, datasetCode, datastoreCode);
    }

    @Override
    public List<ImageResolution> getImageDatasetResolutions(String datasetCode, String datastoreCode) {
        String sessionToken = this.getSessionToken();
        return this.server.getImageDatasetResolutions(sessionToken, datasetCode, datastoreCode);
    }

    @Override
    public ImageSampleContent getImageDatasetInfosForSample(TechId sampleId, WellLocation wellLocationOrNull) {
        String sessionToken = this.getSessionToken();
        return this.server.getImageDatasetInfosForSample(sessionToken, sampleId, wellLocationOrNull);
    }

    @Override
    public TypedTableResultSet<Material> listExperimentMaterials(final TechId experimentId, final ListMaterialDisplayCriteria displayCriteria) {
        return this.listEntities((ITableModelProvider)new AbstractMaterialProvider(){

            protected List<Material> getMaterials() {
                return ScreeningClientService.this.server.listExperimentMaterials(ScreeningClientService.this.getSessionToken(), experimentId, displayCriteria.getListCriteria().tryGetMaterialType());
            }
        }, (IResultSetConfig)displayCriteria);
    }

    @Override
    public TypedTableResultSet<MaterialFeatureVectorSummary> listExperimentFeatureVectorSummary(IResultSetConfig<String, TableModelRowWithObject<MaterialFeatureVectorSummary>> criteria, TechId experimentId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        FeatureVectorSummaryProvider provider = new FeatureVectorSummaryProvider(this.commonServer, this.server, this.getSessionToken(), experimentId, analysisProcedureCriteria);
        return this.listEntities((ITableModelProvider)provider, criteria);
    }

    @Override
    public TypedTableResultSet<MaterialReplicaFeatureSummary> listMaterialReplicaFeatureSummary(IResultSetConfig<String, TableModelRowWithObject<MaterialReplicaFeatureSummary>> resultSetConfig, WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria) {
        MaterialReplicaFeatureSummaryProvider provider = new MaterialReplicaFeatureSummaryProvider(this.server, this.getSessionToken(), criteria);
        return this.listEntities((ITableModelProvider)provider, resultSetConfig);
    }

    @Override
    public String prepareExportFeatureVectorSummary(TableExportCriteria<TableModelRowWithObject<MaterialFeatureVectorSummary>> criteria) throws UserFailureException {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportMaterialReplicaFeatureSummary(TableExportCriteria<TableModelRowWithObject<MaterialReplicaFeatureSummary>> criteria) throws UserFailureException {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public TypedTableResultSet<MaterialSimpleFeatureVectorSummary> listMaterialFeaturesFromAllExperiments(IResultSetConfig<String, TableModelRowWithObject<MaterialSimpleFeatureVectorSummary>> resultSetConfig, WellSearchCriteria.MaterialFeaturesManyExpCriteria criteria) throws UserFailureException {
        MaterialFeatureVectorsFromAllExperimentsProvider provider = new MaterialFeatureVectorsFromAllExperimentsProvider(this.server, this.getSessionToken(), criteria);
        return this.listEntities((ITableModelProvider)provider, resultSetConfig);
    }

    @Override
    public String prepareExportMaterialFeaturesFromAllExperiments(TableExportCriteria<TableModelRowWithObject<MaterialSimpleFeatureVectorSummary>> criteria) throws UserFailureException {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public AnalysisProcedures listNumericalDatasetsAnalysisProcedures(WellSearchCriteria.ExperimentSearchCriteria experimentSearchCriteria) {
        return this.server.listNumericalDatasetsAnalysisProcedures(this.getSessionToken(), experimentSearchCriteria);
    }
}

