/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.QiagenScreeningLibraryColumnExtractor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class LibraryEntityRegistrator {
    private final GeneRegistrator geneRegistrator;
    private final OligoRegistrator oligoRegistrator;
    private final PlateRegistrator plateRegistrator;

    public LibraryEntityRegistrator(QiagenScreeningLibraryColumnExtractor extractor, String experimentIdentifier, String plateGeometry, String spaceCode, String sampleProjectOrNull, String genesFile, String oligosFile, String platesFile) throws IOException {
        this.geneRegistrator = new GeneRegistrator(new File(genesFile));
        this.oligoRegistrator = new OligoRegistrator(new File(oligosFile), extractor.getAdditionalOligoPropertyNames());
        this.plateRegistrator = new PlateRegistrator(new File(platesFile), experimentIdentifier, plateGeometry, spaceCode, sampleProjectOrNull);
    }

    public void register(QiagenScreeningLibraryColumnExtractor extractor, String[] row) throws IOException {
        String geneId = this.geneRegistrator.tryRegister(extractor, row);
        if (geneId != null) {
            String oligoId = this.oligoRegistrator.register(extractor, row, geneId);
            String plateId = this.plateRegistrator.registerPlate(extractor, row);
            this.plateRegistrator.registerWell(extractor, row, plateId, oligoId, geneId);
        }
    }

    public void saveResults() throws IOException, FileNotFoundException {
        this.plateRegistrator.saveResults();
        this.close();
    }

    private void close() throws IOException {
        this.geneRegistrator.close();
        this.oligoRegistrator.close();
        this.plateRegistrator.close();
    }

    private static class OligoRegistrator
    extends AbstractMetadataRegistrator {
        private static final String HEADER = OligoRegistrator.join("CODE", "NUCLEOTIDE_SEQUENCE", "INHIBITOR_OF", "LIBRARY_ID");
        private final Set<String> registeredOligos = new HashSet<String>();
        private final List<String> additionalPropertyNames;

        public OligoRegistrator(File file, List<String> additionalPropertyNames) throws IOException {
            super(file);
            this.additionalPropertyNames = additionalPropertyNames;
            this.writeLine(OligoRegistrator.createHeader(additionalPropertyNames));
        }

        private static String createHeader(List<String> additionalPropertyNames) {
            String header = HEADER;
            for (String propertyName : additionalPropertyNames) {
                header = OligoRegistrator.join(header, propertyName);
            }
            return header;
        }

        public String register(QiagenScreeningLibraryColumnExtractor extractor, String[] row, String inhibitedGeneCode) throws IOException {
            String geneId = extractor.getGeneId(row);
            String oligoId = extractor.getSiRNAId(row);
            String openbisOligoId = geneId + "_" + oligoId;
            if (!this.containsCaseInsensitive(this.registeredOligos, openbisOligoId)) {
                String seq = extractor.getRNASequence(row);
                String geneMaterialProperty = inhibitedGeneCode + " (GENE)";
                String line = OligoRegistrator.join(openbisOligoId, seq, geneMaterialProperty, oligoId);
                List<String> propertyValues = extractor.getAdditionalOligoPropertyValues(row, this.additionalPropertyNames);
                for (int i = 0; i < propertyValues.size(); ++i) {
                    line = OligoRegistrator.join(line, propertyValues.get(i));
                }
                this.writeLine(line);
                this.addCaseInsensitive(this.registeredOligos, openbisOligoId);
            }
            return openbisOligoId;
        }

        private void addCaseInsensitive(Set<String> set, String value) {
            set.add(value.toLowerCase());
        }

        private boolean containsCaseInsensitive(Set<String> set, String value) {
            return set.contains(value.toLowerCase());
        }
    }

    private static class GeneRegistrator
    extends AbstractMetadataRegistrator {
        private static final String HEADER = GeneRegistrator.join("CODE", "DESCRIPTION", "GENE_SYMBOLS");
        private final Set<String> registeredGenes = new HashSet<String>();

        public GeneRegistrator(File genesFile) throws IOException {
            super(genesFile);
            this.writeLine(HEADER);
        }

        public String tryRegister(QiagenScreeningLibraryColumnExtractor extractor, String[] row) throws IOException {
            String geneCode = extractor.getGeneId(row);
            if (StringUtils.isBlank((CharSequence)geneCode)) {
                return null;
            }
            if (!this.registeredGenes.contains(geneCode)) {
                String geneSymbol = extractor.getGeneSymbol(row);
                String desc = extractor.getGeneDescription(row);
                this.writeLine(geneCode, desc, geneSymbol);
                this.registeredGenes.add(geneCode);
            }
            return geneCode;
        }
    }

    private static class PlateRegistrator
    extends AbstractMetadataRegistrator {
        private static final String HEADER_PLATES = "[PLATE]\n" + PlateRegistrator.join("identifier", "experiment", "$PLATE_GEOMETRY");
        private static final String HEADER_SIRNAS = "[SIRNA_WELL]\n" + PlateRegistrator.join("identifier", "experiment", "container", "SIRNA", "GENE");
        private final Set<String> registeredPlates;
        private final String experimentIdentifier;
        private final String plateGeometry;
        private final String spaceCode;
        private final String sampleProjectOrNull;
        private final List<String[]> wellRegistrationBuffer;

        public PlateRegistrator(File outputPlateFile, String experimentIdentifier, String plateGeometry, String spaceCode, String sampleProjectOrNull) throws IOException {
            super(outputPlateFile);
            this.experimentIdentifier = experimentIdentifier;
            this.plateGeometry = plateGeometry;
            this.spaceCode = spaceCode;
            this.sampleProjectOrNull = sampleProjectOrNull;
            this.registeredPlates = new HashSet<String>();
            this.wellRegistrationBuffer = new ArrayList<String[]>();
            this.writeLine(HEADER_PLATES);
        }

        public String registerPlate(QiagenScreeningLibraryColumnExtractor extractor, String[] row) throws IOException {
            String plateCode = extractor.getPlateCode(row);
            String sampleIdentifier = this.getSampleIdentifier(plateCode);
            if (!this.registeredPlates.contains(plateCode)) {
                this.writeLine(sampleIdentifier, this.experimentIdentifier, this.plateGeometry);
                this.registeredPlates.add(plateCode);
            }
            return sampleIdentifier;
        }

        private String getSampleIdentifier(String plateCode) {
            return "/" + this.spaceCode + "/" + (this.sampleProjectOrNull == null ? "" : this.sampleProjectOrNull + "/") + plateCode;
        }

        public void registerWell(QiagenScreeningLibraryColumnExtractor extractor, String[] row, String plateId, String oligoId, String geneId) throws IOException {
            String wellCode = extractor.getWellCode(row);
            String wellIdentifier = plateId + ":" + wellCode;
            String oligoMaterialProperty = oligoId + " (" + "SIRNA" + ")";
            String geneMaterialProperty = geneId + " (" + "GENE" + ")";
            this.saveWell(wellIdentifier, this.experimentIdentifier, plateId, oligoMaterialProperty, geneMaterialProperty);
        }

        private void saveWell(String ... tokens) {
            this.wellRegistrationBuffer.add(tokens);
        }

        public void saveResults() throws IOException {
            this.writeLine(HEADER_SIRNAS);
            for (String[] wellLine : this.wellRegistrationBuffer) {
                this.writeLine(wellLine);
            }
        }
    }

    protected static abstract class AbstractMetadataRegistrator {
        private static final String TAB = "\t";
        private final OutputStream stream;

        protected AbstractMetadataRegistrator(File file) throws FileNotFoundException {
            this.stream = new FileOutputStream(file);
        }

        protected void writeLine(String ... tokens) throws IOException {
            this.writeLine(AbstractMetadataRegistrator.join(tokens));
        }

        public static String join(String ... tokens) {
            return StringUtils.join((Object[])tokens, (String)TAB);
        }

        private void writeLine(String line) throws IOException {
            IOUtils.writeLines(Arrays.asList(line), (String)"\n", (OutputStream)this.stream, (String)"UTF-8");
        }

        public void close() throws IOException {
            this.stream.close();
        }
    }
}

