/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools;

import ch.systemsx.cisd.common.geometry.ConversionUtils;
import ch.systemsx.cisd.common.geometry.Point;
import ch.systemsx.cisd.openbis.generic.shared.util.MaterialConfigurationProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.AbstractColumnExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.PlateWellLocation;
import java.util.List;

public class QiagenScreeningLibraryColumnExtractor
extends AbstractColumnExtractor {
    private static final String PLATE_NAME = "barcode";
    private static final String WELL_ROW = "row";
    private static final String WELL_COL = "col";
    private static final String GENE_ID = "geneId";
    private static final String GENE_SYMBOL = "symbol";
    private static final String GENE_DESC = "description";
    private static final String RNA_SEQUENCE = "sirna";
    private static final String SIRNA_ID = "productId";
    private static final String[] EXPECTED_COLUMNS = new String[]{"barcode", "row", "col", "sirna", "geneId", "symbol", "description", "productId"};
    private final MaterialConfigurationProvider materialConfig;

    public QiagenScreeningLibraryColumnExtractor(String[] headerTokens, MaterialConfigurationProvider materialConfig) {
        super(headerTokens, EXPECTED_COLUMNS);
        this.materialConfig = materialConfig;
    }

    public List<String> getAdditionalOligoPropertyNames() {
        return this.getUnknownColumnNames();
    }

    public String getPlateCode(String[] row) {
        return this.getCodeValue(row, PLATE_NAME);
    }

    public String getWellCode(String[] row) {
        String wellRow = this.getWellRow(row);
        String wellCol = this.getWellCol(row);
        Point loc = ConversionUtils.parseSpreadsheetLocation((String)(wellRow + wellCol));
        return ConversionUtils.convertToSpreadsheetLocation((Point)loc);
    }

    private String getWellCol(String[] row) {
        return this.getValue(row, WELL_COL);
    }

    private String getWellRow(String[] row) {
        return this.getValue(row, WELL_ROW);
    }

    public String getRNASequence(String[] row) {
        return this.getValue(row, RNA_SEQUENCE);
    }

    public String getSiRNAId(String[] row) {
        return this.getValue(row, SIRNA_ID);
    }

    public String getGeneId(String[] row) {
        return this.getMaterialCodeValue(row, GENE_ID);
    }

    private String getMaterialCodeValue(String[] row, String columnName) {
        if (this.materialConfig.isStrictCodeConstraints()) {
            return this.getCodeValue(row, columnName);
        }
        return this.getValue(row, columnName);
    }

    public String getGeneSymbol(String[] row) {
        return this.getValue(row, GENE_SYMBOL);
    }

    public String getGeneDescription(String[] row) {
        return this.getValue(row, GENE_DESC);
    }

    public List<String> getAdditionalOligoPropertyValues(String[] row, List<String> columnNames) {
        return this.getUnknownColumnValues(row, columnNames);
    }

    public PlateWellLocation getPlateWellLocation(String[] row) {
        return new PlateWellLocation(this.getPlateCode(row), this.getWellRow(row), this.getWellCol(row));
    }

    public GeneDetails getGeneDetails(String[] row) {
        return new GeneDetails(this.getGeneId(row), this.getGeneDescription(row));
    }

    public static class GeneDetails {
        private String symbol;
        private String description;

        public GeneDetails(String symbol, String description) {
            this.symbol = symbol;
            this.description = description;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

