/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.string.UnicodeUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.MaterialConfigurationProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.LibraryEntityRegistrator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.QiagenScreeningLibraryColumnExtractor;
import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ScreeningLibraryTransformer {
    private static final char DEFAULT_SEPARATOR = ',';
    private static final String GENES_FILE_NAME = "genes.txt";
    private static final String SIRNAS_FILE_NAME = "oligos.txt";
    private static final String PLATES_FILE_NAME = "plates.txt";

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 4) {
            System.err.println("Invalid parameters. Expected: <library-file-path> <experiment-identifier> <plate-geometry> <space>");
            System.exit(1);
        }
        String experimentIdentifier = args[1];
        String plateGeometry = args[2];
        String spaceCode = args[3];
        String fileName = args[0];
        System.out.println("Processing...");
        File input = new File(fileName);
        if (!input.isFile()) {
            System.err.println(input + " does not exist or is not a file.");
            return;
        }
        Status status = ScreeningLibraryTransformer.readLibrary(new FileInputStream(input), ',', experimentIdentifier, plateGeometry, spaceCode, null, GENES_FILE_NAME, SIRNAS_FILE_NAME, PLATES_FILE_NAME);
        if (status.isError()) {
            System.err.println(status.tryGetErrorMessage());
        } else {
            System.out.println("Done, look for results in " + new File(".").getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status readLibrary(InputStream input, char separator, String experimentIdentifier, String plateGeometry, String spaceCode, String sampleProjectOrNull, String genesFile, String oligosFile, String platesFile) {
        try (CsvReader csvReader = null;){
            csvReader = ScreeningLibraryTransformer.createReader(input, separator);
            boolean headerPresent = csvReader.readRecord();
            if (!headerPresent) {
                throw new UserFailureException("header not found");
            }
            String[] headers = csvReader.getValues();
            QiagenScreeningLibraryColumnExtractor extractor = new QiagenScreeningLibraryColumnExtractor(headers, MaterialConfigurationProvider.getInstance());
            LibraryEntityRegistrator registrator = new LibraryEntityRegistrator(extractor, experimentIdentifier, plateGeometry, spaceCode, sampleProjectOrNull, genesFile, oligosFile, platesFile);
            while (csvReader.readRecord()) {
                String[] row = csvReader.getValues();
                registrator.register(extractor, row);
            }
            registrator.saveResults();
            Status status = Status.OK;
            return status;
        }
    }

    static CsvReader createReader(InputStream input, char separator) throws FileNotFoundException, IOException, UserFailureException {
        CsvReader csvReader = new CsvReader(input, UnicodeUtils.getDefaultUnicodeCharset());
        csvReader.setDelimiter(separator);
        csvReader.setSafetySwitch(false);
        return csvReader;
    }
}

