/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.screening.shared.IScreeningServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class FeatureVectorSummaryProvider
extends AbstractTableModelProvider<MaterialFeatureVectorSummary> {
    private static final String FEATURE_VALUE_PREFIX = "FEATURE_VALUE-";
    private final IScreeningServer server;
    private final String sessionToken;
    private final TechId experimentId;
    private final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;
    private final ICommonServer commonServer;

    public FeatureVectorSummaryProvider(ICommonServer commonServer, IScreeningServer server, String sessionToken, TechId experimentId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        this.commonServer = commonServer;
        this.server = server;
        this.sessionToken = sessionToken;
        this.experimentId = experimentId;
        this.analysisProcedureCriteria = analysisProcedureCriteria;
    }

    public TypedTableModel<MaterialFeatureVectorSummary> createTableModel() {
        TypedTableModelBuilder builder = new TypedTableModelBuilder();
        ExperimentFeatureVectorSummary fvSummary = this.server.getExperimentFeatureVectorSummary(this.sessionToken, this.experimentId, this.analysisProcedureCriteria);
        TableModel tableModel = fvSummary.getTableModelOrNull();
        if (tableModel == null) {
            return this.buildTableFromSummary((TypedTableModelBuilder<MaterialFeatureVectorSummary>)builder, fvSummary);
        }
        return this.buildTableFromTableModel(tableModel);
    }

    private TypedTableModel<MaterialFeatureVectorSummary> buildTableFromTableModel(TableModel tableModel) {
        List headers = tableModel.getHeader();
        List rows = tableModel.getRows();
        HashMap<String, Material> materialsByIdentifer = new HashMap<String, Material>();
        int materialColumnIndex = this.findMaterialColumnIndex(tableModel);
        if (materialColumnIndex >= 0) {
            int indexOfMaterialId = this.getIndexOfHeaderById(headers, "id");
            if (indexOfMaterialId != materialColumnIndex && indexOfMaterialId >= 0) {
                throw new IllegalArgumentException("There is already a column with id 'id'. Column index: " + indexOfMaterialId);
            }
            ((TableModelColumnHeader)headers.get(materialColumnIndex)).setId("id");
            List<Material> materials = this.loadMaterials(rows, materialColumnIndex);
            for (Material material : materials) {
                materialsByIdentifer.put(material.getIdentifier(), material);
            }
        }
        ArrayList<TableModelRowWithObject> list = new ArrayList<TableModelRowWithObject>();
        for (TableModelRow row : rows) {
            List values = row.getValues();
            Material material = null;
            if (materialColumnIndex >= 0) {
                String identifierOrNull = this.getMaterialIdentifier(values, materialColumnIndex);
                material = (Material)materialsByIdentifer.get(identifierOrNull);
            }
            MaterialFeatureVectorSummary summary = new MaterialFeatureVectorSummary(material, null, null, null, 0);
            list.add(new TableModelRowWithObject((Serializable)summary, values));
        }
        return new TypedTableModel(headers, list);
    }

    private int getIndexOfHeaderById(List<TableModelColumnHeader> headers, String id) {
        for (int i = 0; i < headers.size(); ++i) {
            TableModelColumnHeader header = headers.get(i);
            if (!id.equals(header.getId())) continue;
            return i;
        }
        return -1;
    }

    private List<Material> loadMaterials(List<TableModelRow> rows, int materialColumnIndex) {
        ArrayList<MaterialIdentifier> materialIdentifiers = new ArrayList<MaterialIdentifier>();
        for (TableModelRow row : rows) {
            List values = row.getValues();
            String identifierOrNull = this.getMaterialIdentifier(values, materialColumnIndex);
            materialIdentifiers.add(MaterialIdentifier.tryParseIdentifier((String)identifierOrNull));
        }
        ListMaterialCriteria criteria = ListMaterialCriteria.createFromMaterialIdentifiers(materialIdentifiers);
        return this.commonServer.listMaterials(this.sessionToken, criteria, false);
    }

    private String getMaterialIdentifier(List<ISerializableComparable> values, int materialColumnIndex) {
        if (materialColumnIndex >= values.size()) {
            throw new IllegalArgumentException("Material column index " + materialColumnIndex + " is out of bounds for row: " + values);
        }
        ISerializableComparable cell = values.get(materialColumnIndex);
        if (!(cell instanceof EntityTableCell)) {
            throw new IllegalArgumentException("Material column index " + materialColumnIndex + " points to a cell which isn't a entity table cell: " + values);
        }
        String identifierOrNull = ((EntityTableCell)cell).getIdentifierOrNull();
        if (identifierOrNull == null) {
            throw new IllegalArgumentException("Material column index " + materialColumnIndex + " points to an entity table cell which hasn't an identifier: " + values);
        }
        return identifierOrNull.toUpperCase();
    }

    private int findMaterialColumnIndex(TableModel tableModel) {
        List headers = tableModel.getHeader();
        for (int i = 0; i < headers.size(); ++i) {
            TableModelColumnHeader header = (TableModelColumnHeader)headers.get(i);
            if (!EntityKind.MATERIAL.equals((Object)header.tryGetEntityKind())) continue;
            return i;
        }
        return -1;
    }

    private TypedTableModel<MaterialFeatureVectorSummary> buildTableFromSummary(TypedTableModelBuilder<MaterialFeatureVectorSummary> builder, ExperimentFeatureVectorSummary fvSummary) {
        builder.addColumn("id");
        builder.addColumn("experiment_perm_id").hideByDefault();
        builder.columnGroup("MATERIAL_PROP-");
        List<CodeAndLabel> featureDescriptions = fvSummary.getFeatureDescriptions();
        ArrayList<String> featureColumnIds = new ArrayList<String>();
        ArrayList<String> rankColumnIds = new ArrayList<String>();
        for (CodeAndLabel featureDescription : featureDescriptions) {
            String featureCode = featureDescription.getCode();
            String featureColumnId = this.getFeatureColumnId(featureCode);
            String featureLabel = featureDescription.getLabel();
            builder.addColumn(featureColumnId).withTitle(featureLabel).withDataType(DataTypeCode.REAL);
            featureColumnIds.add(featureColumnId);
            String rankColumnId = this.getRankColumnId(featureCode);
            String rankTitle = "Rank";
            builder.addColumn(rankColumnId).withTitle(rankTitle).withDataType(DataTypeCode.INTEGER);
            rankColumnIds.add(rankColumnId);
        }
        for (MaterialFeatureVectorSummary summary : fvSummary.getMaterialsSummary()) {
            this.addRow(builder, fvSummary.getExperiment(), summary, featureColumnIds, rankColumnIds);
        }
        return builder.getModel();
    }

    private void addRow(TypedTableModelBuilder<MaterialFeatureVectorSummary> builder, ExperimentReference experiment, MaterialFeatureVectorSummary summary, List<String> featureColumnIds, List<String> rankColumnIds) {
        builder.addRow((Serializable)summary);
        Material material = (Material)summary.getMaterial();
        builder.column("id").addString(material.getCode());
        builder.column("experiment_perm_id").addString(experiment != null ? experiment.getPermId() : null);
        if (material.getProperties() != null) {
            builder.columnGroup("MATERIAL_PROP-").addProperties((Collection)material.getProperties());
        }
        float[] featureSummaries = summary.getFeatureVectorSummary();
        int[] ranksValues = summary.getFeatureVectorRanks();
        for (int pos = 0; pos < featureSummaries.length; ++pos) {
            String featureColumnId = featureColumnIds.get(pos);
            builder.column(featureColumnId).addDouble(Double.valueOf(featureSummaries[pos]));
            String rankColumnId = rankColumnIds.get(pos);
            builder.column(rankColumnId).addInteger(Long.valueOf(ranksValues[pos]));
        }
    }

    private String getFeatureColumnId(String code) {
        return FEATURE_VALUE_PREFIX + code;
    }

    private String getRankColumnId(String code) {
        return "RANK" + code;
    }
}

