/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.screening.shared.IScreeningServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PlateMetadataProvider
extends AbstractTableModelProvider<WellMetadata> {
    static final String CONTENT_PROPERTY_PREFIX = "CONTENT_PROPERTY__";
    private final IScreeningServer server;
    private final String sessionToken;
    private final TechId plateId;

    public PlateMetadataProvider(IScreeningServer server, String sessionToken, TechId plateId) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.plateId = plateId;
    }

    public TypedTableModel<WellMetadata> createTableModel() {
        TypedTableModelBuilder builder = new TypedTableModelBuilder();
        PlateContent plateContent = this.server.getPlateContent(this.sessionToken, this.plateId);
        List<WellMetadata> wells = plateContent.getPlateMetadata().getWells();
        builder.addColumn("CODE");
        builder.addColumn("TYPE");
        for (WellMetadata wellMetadata : wells) {
            builder.addRow((Serializable)wellMetadata);
            Sample well = wellMetadata.getWellSample();
            builder.column("CODE").addString(well.getCode());
            builder.column("TYPE").addString(well.getSampleType().getCode());
            builder.columnGroup(CONTENT_PROPERTY_PREFIX).addProperties((Collection)well.getProperties());
        }
        return builder.getModel();
    }
}

