/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumn;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumnGroup;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.screening.shared.IScreeningServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.NamedFeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.grids.WellSearchGridColumnIds;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class WellContentProvider
extends AbstractTableModelProvider<WellContent> {
    static final String WELL_PROPERTY_ID_PREFIX = "WELL_PROPERTY-";
    static final String WELL_CONTENT_FEATURE_VECTOR_GROUP = "WELL_CONTENT_FEATURE_VECTOR-";
    private final IScreeningServer server;
    private final String sessionToken;
    private final WellSearchCriteria materialCriteria;

    public WellContentProvider(IScreeningServer server, String sessionToken, WellSearchCriteria materialCriteria) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.materialCriteria = materialCriteria;
    }

    protected TypedTableModel<WellContent> createTableModel() {
        TypedTableModelBuilder builder = new TypedTableModelBuilder();
        List<WellContent> wells = this.server.listPlateWells(this.sessionToken, this.materialCriteria);
        List<IEntityProperty> materialPropertyOrder = this.extractOrderedMaterialProperties(wells);
        this.sortByMaterialCodes(wells, materialPropertyOrder);
        this.initColumnItems((TypedTableModelBuilder<WellContent>)builder, materialPropertyOrder);
        for (WellContent well : wells) {
            this.addRow((TypedTableModelBuilder<WellContent>)builder, well, materialPropertyOrder);
        }
        return builder.getModel();
    }

    private void initColumnItems(TypedTableModelBuilder<WellContent> builder, List<IEntityProperty> materialPropertyOrder) {
        builder.addColumn("WELL_IMAGES").withDefaultWidth(500);
        this.addMaterialColumns(builder, materialPropertyOrder);
        builder.columnGroup(WELL_PROPERTY_ID_PREFIX);
        builder.addColumn("experiment");
        builder.addColumn("PLATE");
        builder.addColumn("WELL");
        builder.columnGroup(WELL_CONTENT_FEATURE_VECTOR_GROUP);
        builder.addColumn("file_format_type");
        builder.addColumn("IMAGE_DATA_SET");
        builder.addColumn("IMAGE_ANALYSIS_DATA_SET");
        builder.addColumn("ANALYSIS_PROCEDURE");
    }

    private void addMaterialColumns(TypedTableModelBuilder<WellContent> builder, List<IEntityProperty> materialPropertyOrder) {
        for (IEntityProperty materialProperty : materialPropertyOrder) {
            List<PropertyType> materialPropertyType = Collections.singletonList(materialProperty.getPropertyType());
            this.getMaterialColumnGroup(builder, materialProperty).addColumnsForPropertyTypes(materialPropertyType);
            List materialProperties = materialProperty.getMaterial().getProperties();
            List<PropertyType> propertyTypes = this.extractPropertyTypes(materialProperties);
            this.getMaterialPropsColumnGroup(builder, materialProperty).addColumnsForPropertyTypes(propertyTypes);
        }
    }

    private IColumnGroup getMaterialColumnGroup(TypedTableModelBuilder<WellContent> builder, IEntityProperty materialProperty) {
        return builder.columnGroup(WellSearchGridColumnIds.getWellMaterialColumnGroupPrefix(materialProperty));
    }

    private IColumnGroup getMaterialPropsColumnGroup(TypedTableModelBuilder<WellContent> builder, IEntityProperty materialProperty) {
        return builder.columnGroup(WellSearchGridColumnIds.getWellMaterialPropertyColumnGroupPrefix(materialProperty));
    }

    private void addRow(TypedTableModelBuilder<WellContent> builder, WellContent well, List<IEntityProperty> materialPropertyOrder) {
        builder.addRow((Serializable)well);
        builder.column("WELL_IMAGES").addString(well.tryGetImageDataset() == null ? "" : "[images]");
        this.addMaterialProperties(builder, well, materialPropertyOrder);
        this.addNonMaterialProperties(builder, well);
        builder.column("experiment").addString(well.getExperiment().toString());
        builder.column("PLATE").addString(well.getPlate().getCode());
        builder.column("WELL").addString(well.getWell().getCode());
        NamedFeatureVector featureVector = well.tryGetFeatureVectorValues();
        if (featureVector != null) {
            this.addFeatureColumns(builder, featureVector);
        }
        DatasetImagesReference imageDataset = well.tryGetImageDataset();
        builder.column("file_format_type").addString(imageDataset == null ? null : imageDataset.getDatasetReference().getFileTypeCode());
        builder.column("IMAGE_DATA_SET").addString(imageDataset == null ? null : imageDataset.getDatasetCode());
        DatasetReference dataset = well.tryGetFeatureVectorDataset();
        builder.column("IMAGE_ANALYSIS_DATA_SET").addString(dataset == null ? null : dataset.getCode());
        builder.column("ANALYSIS_PROCEDURE").addString(dataset == null ? null : dataset.getAnalysisProcedure());
    }

    private void addNonMaterialProperties(TypedTableModelBuilder<WellContent> builder, WellContent well) {
        List<IEntityProperty> wellProperties = well.getWellProperties();
        ArrayList<IEntityProperty> nonMaterialProperties = new ArrayList<IEntityProperty>();
        for (IEntityProperty property : wellProperties) {
            DataTypeCode propertyDataTypeCode = property.getPropertyType().getDataType().getCode();
            if (propertyDataTypeCode == DataTypeCode.MATERIAL) continue;
            nonMaterialProperties.add(property);
        }
        builder.columnGroup(WELL_PROPERTY_ID_PREFIX).addProperties(nonMaterialProperties);
    }

    private void addMaterialProperties(TypedTableModelBuilder<WellContent> builder, WellContent well, List<IEntityProperty> materialPropsOrder) {
        for (IEntityProperty materialTypeProperty : well.getMaterialTypeProperties()) {
            Material materialOrNull = materialTypeProperty.getMaterial();
            if (materialOrNull == null) continue;
            this.getMaterialColumnGroup(builder, materialTypeProperty).addProperties(Collections.singletonList(materialTypeProperty));
            List materialProperties = materialOrNull.getProperties();
            if (materialProperties == null) continue;
            this.getMaterialPropsColumnGroup(builder, materialTypeProperty).addProperties((Collection)materialOrNull.getProperties());
        }
    }

    private void addFeatureColumns(TypedTableModelBuilder<WellContent> builder, NamedFeatureVector featureVector) {
        FeatureValue[] values = featureVector.getValues();
        String[] labels = featureVector.getFeatureLabels();
        String[] codes = featureVector.getFeatureCodes();
        for (int i = 0; i < values.length; ++i) {
            IColumn column = builder.column(WELL_CONTENT_FEATURE_VECTOR_GROUP + codes[i]).withTitle(labels[i]);
            FeatureValue featureValue = values[i];
            if (featureValue.isFloat()) {
                column.addDouble(new Double(featureValue.asFloat()));
                continue;
            }
            column.addString(featureValue.tryAsVocabularyTerm());
        }
    }

    private List<PropertyType> extractPropertyTypes(List<IEntityProperty> materialProperties) {
        ArrayList<PropertyType> propertyTypes = new ArrayList<PropertyType>();
        if (materialProperties != null) {
            for (IEntityProperty prop : materialProperties) {
                propertyTypes.add(prop.getPropertyType());
            }
        }
        return propertyTypes;
    }

    private List<IEntityProperty> extractOrderedMaterialProperties(List<WellContent> wells) {
        TreeMap<String, IEntityProperty> orderedMaterialProps = new TreeMap<String, IEntityProperty>();
        for (WellContent well : wells) {
            for (IEntityProperty materialProperty : well.getMaterialTypeProperties()) {
                String propCode = materialProperty.getPropertyType().getCode();
                orderedMaterialProps.put(propCode, materialProperty);
            }
        }
        return new ArrayList<IEntityProperty>(orderedMaterialProps.values());
    }

    private void sortByMaterialCodes(List<WellContent> wells, final List<IEntityProperty> materialPropsOrder) {
        Collections.sort(wells, new Comparator<WellContent>(){

            @Override
            public int compare(WellContent o1, WellContent o2) {
                for (IEntityProperty materialProperty : materialPropsOrder) {
                    boolean o2HasMaterial;
                    String materialPropCode = materialProperty.getPropertyType().getCode();
                    boolean o1HasMaterial = WellContentProvider.this.hasMaterialTypeProperty(o1, materialPropCode);
                    if (o1HasMaterial == (o2HasMaterial = WellContentProvider.this.hasMaterialTypeProperty(o2, materialPropCode))) continue;
                    return o1HasMaterial ? -1 : 1;
                }
                return 0;
            }
        });
    }

    private boolean hasMaterialTypeProperty(WellContent well, String materialPropCode) {
        for (IEntityProperty materialProp : well.getMaterialTypeProperties()) {
            if (!materialProp.getPropertyType().getCode().equals(materialPropCode)) continue;
            return true;
        }
        return false;
    }
}

