/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.server.IASyncAction;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.KeyExtractorFactory;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServer;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

class LibraryRegistrationTask
implements IASyncAction {
    private static final String DELIM = " ";
    private final String sessionToken;
    private final List<NewMaterial> newGenesOrNull;
    private final List<NewMaterial> newOligosOrNull;
    private final List<NewSamplesWithTypes> newSamplesWithType;
    private final IGenericServer genericServer;
    private final ICommonServer commonServer;
    private final IDAOFactory daoFactory;

    public LibraryRegistrationTask(String sessionToken, List<NewMaterial> newGenesOrNull, List<NewMaterial> newOligosOrNull, List<NewSamplesWithTypes> newSamplesWithType, ICommonServer commonServer, IGenericServer server, IDAOFactory daoFactory) {
        this.sessionToken = sessionToken;
        this.newGenesOrNull = newGenesOrNull;
        this.newOligosOrNull = newOligosOrNull;
        this.newSamplesWithType = newSamplesWithType;
        this.commonServer = commonServer;
        this.genericServer = server;
        this.daoFactory = daoFactory;
    }

    private void registerOrUpdateSamples(Writer message) throws IOException {
        try {
            if (this.newSamplesWithType != null) {
                this.genericServer.registerOrUpdateSamples(this.sessionToken, this.newSamplesWithType);
                for (NewSamplesWithTypes s : this.newSamplesWithType) {
                    message.write("Successfuly saved " + s.getNewEntities().size() + " samples of type " + s.getEntityType() + ".\n");
                }
            }
        }
        catch (RuntimeException ex) {
            message.write("ERROR: Plates and wells could not be saved!\n");
            message.write(ex.getMessage());
            throw ex;
        }
    }

    private void registerOrUpdateMaterials(String materialTypeCode, List<NewMaterial> newMaterials) {
        List<NewMaterialsWithTypes> materialsWithTypes = LibraryRegistrationTask.createMaterialsWithTypes(materialTypeCode, newMaterials);
        this.genericServer.registerOrUpdateMaterials(this.sessionToken, materialsWithTypes);
    }

    @Private
    static List<NewMaterialsWithTypes> createMaterialsWithTypes(String materialTypeCode, List<NewMaterial> newMaterials) {
        MaterialType materialType = new MaterialType();
        materialType.setCode(materialTypeCode);
        NewMaterialsWithTypes materialsWithType = new NewMaterialsWithTypes(materialType, newMaterials);
        materialsWithType.setAllowUpdateIfExist(true);
        List<NewMaterialsWithTypes> materialsWithTypes = Arrays.asList(materialsWithType);
        return materialsWithTypes;
    }

    private void registerOrUpdateOligos(Writer message) throws IOException {
        try {
            if (this.newOligosOrNull != null) {
                this.registerOrUpdateMaterials("SIRNA", this.newOligosOrNull);
                message.write("Successfuly saved " + this.newOligosOrNull.size() + " siRNAs.\n");
            }
        }
        catch (RuntimeException ex) {
            message.write("ERROR: siRNAs could not be saved!\n");
            message.write(ex.getMessage());
            throw ex;
        }
    }

    private void registerOrUpdateGenes(Writer message) throws IOException {
        try {
            if (this.newGenesOrNull != null) {
                TableMap<String, Material> existingGenes = this.listExistingGenes();
                for (NewMaterial newGene : this.newGenesOrNull) {
                    Material existingGene = (Material)existingGenes.tryGet((Object)newGene.getCode());
                    if (existingGene == null) continue;
                    this.mergeGeneSymbols(existingGene, newGene);
                }
                this.registerOrUpdateMaterials("GENE", this.newGenesOrNull);
                message.write("Successfuly saved properties of " + this.newGenesOrNull.size() + " genes.\n");
            }
        }
        catch (RuntimeException ex) {
            message.write("ERROR: Genes could not be saved!\n");
            message.write(ex.getMessage());
            throw ex;
        }
    }

    private TableMap<String, Material> listExistingGenes() {
        EntityTypePE entityTypePE = this.daoFactory.getEntityTypeDAO(EntityKind.MATERIAL).tryToFindEntityTypeByCode("GENE");
        MaterialType materialType = MaterialTypeTranslator.translateSimple((EntityTypePE)entityTypePE);
        List materials = this.commonServer.listMaterials(this.sessionToken, ListMaterialCriteria.createFromMaterialType((MaterialType)materialType), true);
        return new TableMap((Iterable)materials, KeyExtractorFactory.createCodeKeyExtractor());
    }

    private void mergeGeneSymbols(Material existingMaterial, NewMaterial newMaterial) {
        IEntityProperty existingGeneProp = EntityHelper.tryFindProperty((Iterable)existingMaterial.getProperties(), (String)"GENE_SYMBOLS");
        if (existingGeneProp == null) {
            return;
        }
        String existingGene = existingGeneProp.getValue();
        IEntityProperty newGeneProp = EntityHelper.tryFindProperty((IEntityProperty[])newMaterial.getProperties(), (String)"GENE_SYMBOLS");
        if (newGeneProp == null) {
            return;
        }
        String mergedGeneSymbols = this.mergeGeneSymbols(existingGene, newGeneProp.getValue());
        newGeneProp.setValue(mergedGeneSymbols);
    }

    private String mergeGeneSymbols(String existingSymbols, String newSymbolString) {
        if (StringUtils.isBlank((String)newSymbolString) || newSymbolString.equals(existingSymbols)) {
            return existingSymbols;
        }
        String[] newSymbols = newSymbolString.split("\\s+");
        StringBuilder result = new StringBuilder(existingSymbols);
        for (String newSymbol : newSymbols) {
            boolean alreadyExisting;
            if (StringUtils.isBlank((String)newSymbol)) continue;
            boolean bl = alreadyExisting = existingSymbols.startsWith(newSymbol + DELIM) || existingSymbols.endsWith(DELIM + newSymbol) || existingSymbols.indexOf(DELIM + newSymbol + DELIM) > 0;
            if (alreadyExisting) continue;
            result.append(DELIM);
            result.append(newSymbol);
        }
        return result.toString();
    }

    public boolean doAction(Writer messageWriter) {
        try {
            this.registerOrUpdateGenes(messageWriter);
            this.registerOrUpdateOligos(messageWriter);
            this.registerOrUpdateSamples(messageWriter);
            return true;
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public String getName() {
        return "Library registration";
    }
}

