/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server;

import ch.systemsx.cisd.common.collection.IModifiable;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.IScreeningApiServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetImageRepresentationFormats;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentImageMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureInformation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorWithDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureVectorDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageRepresentationFormatSelectionCriterion;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellMaterialMapping;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellReferenceWithDatasets;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ScreeningServerJson
implements IScreeningApiServer {
    private IScreeningApiServer server;

    public ScreeningServerJson(IScreeningApiServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server was null");
        }
        this.server = server;
    }

    public int getMajorVersion() {
        return this.server.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.server.getMinorVersion();
    }

    @Override
    public String tryLoginScreening(String userId, String userPassword) throws IllegalArgumentException {
        return this.server.tryLoginScreening(userId, userPassword);
    }

    @Override
    public void logoutScreening(String sessionToken) throws IllegalArgumentException {
        this.server.logoutScreening(sessionToken);
    }

    @Override
    public List<Plate> listPlates(String sessionToken) throws IllegalArgumentException {
        return new PlateList((Collection<? extends Plate>)this.server.listPlates(sessionToken));
    }

    @Override
    public List<Plate> listPlates(String sessionToken, ExperimentIdentifier experiment) throws IllegalArgumentException {
        return new PlateList((Collection<? extends Plate>)this.server.listPlates(sessionToken, experiment));
    }

    @Override
    public List<PlateMetadata> getPlateMetadataList(String sessionToken, List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return new PlateMetadataList((Collection<? extends PlateMetadata>)this.server.getPlateMetadataList(sessionToken, plates));
    }

    @Override
    public List<ExperimentIdentifier> listExperiments(String sessionToken) {
        return new ExperimentIdentifierList((Collection<? extends ExperimentIdentifier>)this.server.listExperiments(sessionToken));
    }

    @Override
    public List<ExperimentIdentifier> listExperiments(String sessionToken, String userId) {
        return new ExperimentIdentifierList((Collection<? extends ExperimentIdentifier>)this.server.listExperiments(sessionToken, userId));
    }

    @Override
    public List<FeatureVectorDatasetReference> listFeatureVectorDatasets(String sessionToken, List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return new FeatureVectorDatasetReferenceList((Collection<? extends FeatureVectorDatasetReference>)this.server.listFeatureVectorDatasets(sessionToken, plates));
    }

    @Override
    public List<ImageDatasetReference> listImageDatasets(String sessionToken, List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return new ImageDatasetReferenceList((Collection<? extends ImageDatasetReference>)this.server.listImageDatasets(sessionToken, plates));
    }

    @Override
    public List<ImageDatasetReference> listRawImageDatasets(String sessionToken, List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return new ImageDatasetReferenceList((Collection<? extends ImageDatasetReference>)this.server.listRawImageDatasets(sessionToken, plates));
    }

    @Override
    public List<ImageDatasetReference> listSegmentationImageDatasets(String sessionToken, List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return new ImageDatasetReferenceList((Collection<? extends ImageDatasetReference>)this.server.listSegmentationImageDatasets(sessionToken, plates));
    }

    @Override
    public List<IDatasetIdentifier> getDatasetIdentifiers(String sessionToken, List<String> datasetCodes) {
        return new IDatasetIdentifierList((Collection<? extends IDatasetIdentifier>)this.server.getDatasetIdentifiers(sessionToken, datasetCodes));
    }

    @Override
    public List<PlateWellReferenceWithDatasets> listPlateWells(String sessionToken, ExperimentIdentifier experimentIdentifer, MaterialIdentifier materialIdentifier, boolean findDatasets) {
        return new PlateWellReferenceWithDatasetsList((Collection<? extends PlateWellReferenceWithDatasets>)this.server.listPlateWells(sessionToken, experimentIdentifer, materialIdentifier, findDatasets));
    }

    @Override
    public List<PlateWellReferenceWithDatasets> listPlateWells(String sessionToken, MaterialIdentifier materialIdentifier, boolean findDatasets) {
        return new PlateWellReferenceWithDatasetsList((Collection<? extends PlateWellReferenceWithDatasets>)this.server.listPlateWells(sessionToken, materialIdentifier, findDatasets));
    }

    @Override
    public List<WellIdentifier> listPlateWells(String sessionToken, PlateIdentifier plateIdentifier) {
        return new WellIdentifierList((Collection<? extends WellIdentifier>)this.server.listPlateWells(sessionToken, plateIdentifier));
    }

    @Override
    public Sample getWellSample(String sessionToken, WellIdentifier wellIdentifier) {
        return this.server.getWellSample(sessionToken, wellIdentifier);
    }

    @Override
    public Sample getPlateSample(String sessionToken, PlateIdentifier plateIdentifier) {
        return this.server.getPlateSample(sessionToken, plateIdentifier);
    }

    @Override
    public List<PlateWellMaterialMapping> listPlateMaterialMapping(String sessionToken, List<? extends PlateIdentifier> plates, MaterialTypeIdentifier materialTypeIdentifierOrNull) {
        return new PlateWellMaterialMappingList((Collection<? extends PlateWellMaterialMapping>)this.server.listPlateMaterialMapping(sessionToken, plates, materialTypeIdentifierOrNull));
    }

    @Override
    public ExperimentImageMetadata getExperimentImageMetadata(String sessionToken, ExperimentIdentifier experimentIdentifer) {
        return this.server.getExperimentImageMetadata(sessionToken, experimentIdentifer);
    }

    @Override
    public List<String> listAvailableFeatureCodes(String sessionToken, List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        return this.server.listAvailableFeatureCodes(sessionToken, featureDatasets);
    }

    @Override
    public List<FeatureInformation> listAvailableFeatures(String sessionToken, List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        return new FeatureInformationList((Collection<? extends FeatureInformation>)this.server.listAvailableFeatures(sessionToken, featureDatasets));
    }

    @Override
    public List<FeatureVectorDataset> loadFeatures(String sessionToken, List<FeatureVectorDatasetReference> featureDatasets, List<String> featureCodes) {
        return new FeatureVectorDatasetList((Collection<? extends FeatureVectorDataset>)this.server.loadFeatures(sessionToken, featureDatasets, featureCodes));
    }

    @Override
    public List<FeatureVectorWithDescription> loadFeaturesForDatasetWellReferences(String sessionToken, List<FeatureVectorDatasetWellReference> datasetWellReferences, List<String> featureCodes) {
        return new FeatureVectorWithDescriptionList((Collection<? extends FeatureVectorWithDescription>)this.server.loadFeaturesForDatasetWellReferences(sessionToken, datasetWellReferences, featureCodes));
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, boolean convertToPng) {
        return this.server.loadImagesBase64(sessionToken, imageReferences, convertToPng);
    }

    @Override
    public List<String> loadThumbnailImagesBase64(String sessionToken, List<PlateImageReference> imageReferences) {
        return this.server.loadThumbnailImagesBase64(sessionToken, imageReferences);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, ImageSize size) {
        return this.server.loadImagesBase64(sessionToken, imageReferences, size);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences) {
        return this.server.loadImagesBase64(sessionToken, imageReferences);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, LoadImageConfiguration configuration) {
        return this.server.loadImagesBase64(sessionToken, imageReferences, configuration);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, ImageRepresentationFormat format) {
        return this.server.loadImagesBase64(sessionToken, imageReferences, format);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, IImageRepresentationFormatSelectionCriterion ... criteria) {
        return this.server.loadImagesBase64(sessionToken, imageReferences, criteria);
    }

    @Override
    public List<ImageDatasetMetadata> listImageMetadata(String sessionToken, List<? extends IImageDatasetIdentifier> imageDatasets) {
        return new ImageDatasetMetadataList((Collection<? extends ImageDatasetMetadata>)this.server.listImageMetadata(sessionToken, imageDatasets));
    }

    @Override
    public List<DatasetImageRepresentationFormats> listAvailableImageRepresentationFormats(String sessionToken, List<? extends IDatasetIdentifier> imageDatasets) {
        return new DatasetImageRepresentationFormatsList((Collection<? extends DatasetImageRepresentationFormats>)this.server.listAvailableImageRepresentationFormats(sessionToken, imageDatasets));
    }

    @Override
    public List<String> loadPhysicalThumbnailsBase64(String sessionToken, List<PlateImageReference> imageReferences, ImageRepresentationFormat format) {
        return this.server.loadPhysicalThumbnailsBase64(sessionToken, imageReferences, format);
    }

    @Override
    public Map<String, LogicalImageInfo> getImageInfo(String sessionToken, List<String> datasetCodes) {
        return this.server.getImageInfo(sessionToken, datasetCodes);
    }

    @Override
    public Map<String, List<ImageResolution>> getImageResolutions(String sessionToken, List<String> datasetCodes) {
        Map<String, List<ImageResolution>> map = this.server.getImageResolutions(sessionToken, datasetCodes);
        for (Map.Entry<String, List<ImageResolution>> entry : map.entrySet()) {
            map.put(entry.getKey(), new ImageResolutionList((Collection<? extends ImageResolution>)entry.getValue()));
        }
        return map;
    }

    private static class ImageResolutionList
    extends ArrayList<ImageResolution>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public ImageResolutionList(Collection<? extends ImageResolution> c) {
            super(c);
        }
    }

    private static class DatasetImageRepresentationFormatsList
    extends ArrayList<DatasetImageRepresentationFormats>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public DatasetImageRepresentationFormatsList(Collection<? extends DatasetImageRepresentationFormats> c) {
            super(c);
        }
    }

    private static class ImageDatasetMetadataList
    extends ArrayList<ImageDatasetMetadata>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public ImageDatasetMetadataList(Collection<? extends ImageDatasetMetadata> c) {
            super(c);
        }
    }

    private static class FeatureVectorWithDescriptionList
    extends ArrayList<FeatureVectorWithDescription>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public FeatureVectorWithDescriptionList(Collection<? extends FeatureVectorWithDescription> c) {
            super(c);
        }
    }

    private static class FeatureVectorDatasetList
    extends ArrayList<FeatureVectorDataset>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public FeatureVectorDatasetList(Collection<? extends FeatureVectorDataset> c) {
            super(c);
        }
    }

    private static class FeatureInformationList
    extends ArrayList<FeatureInformation>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public FeatureInformationList(Collection<? extends FeatureInformation> c) {
            super(c);
        }
    }

    private static class PlateWellMaterialMappingList
    extends ArrayList<PlateWellMaterialMapping>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public PlateWellMaterialMappingList(Collection<? extends PlateWellMaterialMapping> c) {
            super(c);
        }
    }

    private static class WellIdentifierList
    extends ArrayList<WellIdentifier>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public WellIdentifierList(Collection<? extends WellIdentifier> c) {
            super(c);
        }
    }

    private static class PlateWellReferenceWithDatasetsList
    extends ArrayList<PlateWellReferenceWithDatasets>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public PlateWellReferenceWithDatasetsList(Collection<? extends PlateWellReferenceWithDatasets> c) {
            super(c);
        }
    }

    private static class IDatasetIdentifierList
    extends ArrayList<IDatasetIdentifier>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public IDatasetIdentifierList(Collection<? extends IDatasetIdentifier> c) {
            super(c);
        }
    }

    private static class ImageDatasetReferenceList
    extends ArrayList<ImageDatasetReference>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public ImageDatasetReferenceList(Collection<? extends ImageDatasetReference> c) {
            super(c);
        }
    }

    private static class ExperimentIdentifierList
    extends ArrayList<ExperimentIdentifier>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public ExperimentIdentifierList(Collection<? extends ExperimentIdentifier> c) {
            super(c);
        }
    }

    private static class PlateMetadataList
    extends ArrayList<PlateMetadata>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public PlateMetadataList(Collection<? extends PlateMetadata> c) {
            super(c);
        }
    }

    private static class PlateList
    extends ArrayList<Plate>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public PlateList(Collection<? extends Plate> c) {
            super(c);
        }
    }

    private static class FeatureVectorDatasetReferenceList
    extends ArrayList<FeatureVectorDatasetReference>
    implements IModifiable {
        private static final long serialVersionUID = 1L;

        public FeatureVectorDatasetReferenceList(Collection<? extends FeatureVectorDatasetReference> c) {
            super(c);
        }
    }
}

