/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromExperimentIdentifierString;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromExperimentPermId;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.IRolesProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.IUserProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import java.util.List;

public class ExperimentIdentifierPredicate
extends AbstractSpacePredicate<ExperimentIdentifier> {
    public String getCandidateDescription() {
        return "experiment";
    }

    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ExperimentIdentifier value) {
        if (value.getPermId() != null) {
            IProjectAuthorization pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser((IUserProvider)new UserProviderFromPersonPE(person)).withRoles((IRolesProvider)new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects((IObjectsProvider)new ProjectProviderFromExperimentPermId(value.getPermId())).build();
            if (pa.getObjectsWithoutAccess().isEmpty()) {
                return Status.OK;
            }
            ExperimentPE experimentOrNull = this.authorizationDataProvider.tryGetExperimentByPermId(value.getPermId());
            if (experimentOrNull == null) {
                return Status.createError((String)String.format("User '%s' does not have enough privileges.", person.getUserId()));
            }
            SpacePE space = experimentOrNull.getProject().getSpace();
            return this.evaluate(allowedRoles, person, space.getCode());
        }
        IProjectAuthorization pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser((IUserProvider)new UserProviderFromPersonPE(person)).withRoles((IRolesProvider)new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects((IObjectsProvider)new ProjectProviderFromExperimentIdentifierString(value.getAugmentedCode())).build();
        if (pa.getObjectsWithoutAccess().isEmpty()) {
            return Status.OK;
        }
        String spaceCode = SpaceCodeHelper.getSpaceCode((PersonPE)person, (String)value.getSpaceCode());
        return this.evaluate(allowedRoles, person, spaceCode);
    }
}

