/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromExperimentIdentifierString;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromExperimentPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;

public class ExperimentReferenceValidator
extends AbstractValidator<ExperimentReference> {
    private SimpleSpaceValidator spaceValidator = new SimpleSpaceValidator();

    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.spaceValidator.init(provider);
    }

    public boolean doValidation(PersonPE person, final ExperimentReference value) {
        if (value.getSpaceCode() != null) {
            boolean result = this.spaceValidator.doValidation(person, new ICodeHolder(){

                public String getCode() {
                    return value.getSpaceCode();
                }
            });
            if (result) {
                return result;
            }
            if (value.getProjectCode() != null && value.getCode() != null) {
                ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(value.getSpaceCode(), value.getProjectCode(), value.getCode());
                return this.isValidPA(person, (IObjectsProvider)new ProjectProviderFromExperimentIdentifierString(experimentIdentifier.toString()));
            }
            return false;
        }
        if (value.getPermId() != null) {
            ExperimentPE experimentPE = this.authorizationDataProvider.tryGetExperimentByPermId(value.getPermId());
            return this.isValid(person, experimentPE);
        }
        if (value.getId() != null) {
            ExperimentPE experimentPE = this.authorizationDataProvider.tryGetExperimentByTechId(new TechId(value.getId()));
            return this.isValid(person, experimentPE);
        }
        return false;
    }

    private boolean isValid(PersonPE person, ExperimentPE experimentPE) {
        if (experimentPE != null) {
            if (this.spaceValidator.doValidation(person, (ICodeHolder)experimentPE.getProject().getSpace())) {
                return true;
            }
            if (this.isValidPA(person, (IObjectsProvider)new ProjectProviderFromExperimentPE(experimentPE))) {
                return true;
            }
        }
        return false;
    }
}

