/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.List;
import org.springframework.dao.DataAccessException;

public final class ExperimentSearchCriteriaPredicate
implements IPredicate<WellSearchCriteria.ExperimentSearchCriteria> {
    private final IPredicate<TechId> experimentPredicate = new AbstractTechIdPredicate.ExperimentTechIdPredicate();
    private final ProjectIdentifierPredicate projectPredicate = new ProjectIdentifierPredicate();

    public final void init(IAuthorizationDataProvider provider) {
        this.experimentPredicate.init(provider);
        this.projectPredicate.init(provider);
    }

    public final Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, WellSearchCriteria.ExperimentSearchCriteria value) {
        assert (person != null) : "Unspecified person";
        assert (allowedRoles != null) : "Unspecified allowed roles";
        if (value != null) {
            try {
                WellSearchCriteria.SingleExperimentSearchCriteria experiment = value.tryGetExperiment();
                BasicProjectIdentifier project = value.tryGetProjectIdentifier();
                if (experiment != null) {
                    return this.experimentPredicate.evaluate(person, allowedRoles, (Object)experiment.getExperimentId());
                }
                if (project != null) {
                    ProjectIdentifier projectIdentifier = new ProjectIdentifier(project.getSpaceCode(), project.getProjectCode());
                    return this.projectPredicate.evaluate(person, allowedRoles, (Object)projectIdentifier);
                }
            }
            catch (DataAccessException ex) {
                throw new UserFailureException(ex.getMessage(), (Throwable)ex);
            }
        }
        return Status.OK;
    }
}

