/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.util.List;

public class PlateIdentifierPredicate
extends AbstractSpacePredicate<PlateIdentifier> {
    private final SampleIdentifierPredicate sampleIdentifierPredicate;

    public PlateIdentifierPredicate() {
        this(true);
    }

    public PlateIdentifierPredicate(boolean isReadAccess) {
        this.sampleIdentifierPredicate = new SampleIdentifierPredicate(isReadAccess);
    }

    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.sampleIdentifierPredicate.init(provider);
    }

    public String getCandidateDescription() {
        return "plate identifier";
    }

    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, PlateIdentifier value) {
        SampleIdentifier plateIdentifier;
        if (value.getPermId() != null) {
            SamplePE sample = this.authorizationDataProvider.tryGetSampleByPermId(value.getPermId());
            if (sample == null) {
                return Status.createError((String)String.format("User '%s' does not have enough privileges.", person.getUserId()));
            }
            plateIdentifier = sample.getSampleIdentifier();
        } else {
            plateIdentifier = SampleIdentifierFactory.parse((String)value.getAugmentedCode());
        }
        return this.performSamplePredicateEvaluation(person, allowedRoles, plateIdentifier);
    }

    private Status performSamplePredicateEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleIdentifier sampleIdentifier) {
        return this.sampleIdentifierPredicate.evaluate(person, allowedRoles, (Object)sampleIdentifier);
    }
}

