/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;

public class PlateValidator
extends AbstractValidator<Plate> {
    private SimpleSpaceValidator spaceValidator = new SimpleSpaceValidator();
    private ExperimentByIdentiferValidator experimentValidator = new ExperimentByIdentiferValidator();

    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.experimentValidator.init(provider);
    }

    public boolean doValidation(PersonPE person, final Plate value) {
        boolean result;
        if (value.tryGetSpaceCode() != null && (result = this.spaceValidator.doValidation(person, new ICodeHolder(){

            public String getCode() {
                return value.tryGetSpaceCode();
            }
        }))) {
            return result;
        }
        if (value.getExperimentIdentifier() != null) {
            return this.experimentValidator.doValidation(person, new IIdentifierHolder(){

                public String getIdentifier() {
                    return value.getExperimentIdentifier().getAugmentedCode();
                }
            });
        }
        return false;
    }
}

