/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromExperimentIdentifierString;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import java.util.Set;

public final class ScreeningExperimentValidator
extends AbstractValidator<ExperimentIdentifier> {
    public final boolean doValidation(PersonPE person, ExperimentIdentifier value) {
        String spaceCode = value.getSpaceCode();
        Set roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            if (roleAssignment.getRoleWithHierarchy().isInstanceLevel()) {
                return true;
            }
            SpacePE group = roleAssignment.getSpace();
            if (group == null || !group.getCode().equals(spaceCode)) continue;
            return true;
        }
        return this.isValidPA(person, (IObjectsProvider)new ProjectProviderFromExperimentIdentifierString(value.getAugmentedCode()));
    }
}

