/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleAccessPECollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.exception.UndefinedSpaceException;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@ShouldFlattenCollections(value=false)
public class ScreeningPlateListReadOnlyPredicate
extends AbstractPredicate<List<? extends PlateIdentifier>> {
    private IAuthorizationDataProvider provider;
    private SampleIdentifierCollectionPredicate identifierCollectionPredicate = new SampleIdentifierCollectionPredicate(true);
    private SampleAccessPECollectionPredicate accessPECollectionPredicate = new SampleAccessPECollectionPredicate(true);

    public void init(IAuthorizationDataProvider dataProvider) {
        this.provider = dataProvider;
        this.identifierCollectionPredicate.init(this.provider);
        this.accessPECollectionPredicate.init(this.provider);
    }

    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<? extends PlateIdentifier> plates) {
        Set accessPECollection;
        Status status;
        Status status2;
        ArrayList<SampleIdentifier> identifiers = new ArrayList<SampleIdentifier>();
        ArrayList<PermId> permIds = new ArrayList<PermId>();
        for (PlateIdentifier plateIdentifier : plates) {
            String spaceCodeOrNull = SpaceCodeHelper.tryGetSpaceCode((PersonPE)person, (String)plateIdentifier.tryGetSpaceCode());
            if (spaceCodeOrNull == null && plateIdentifier.getPermId() == null) {
                throw new UndefinedSpaceException();
            }
            if (spaceCodeOrNull != null) {
                SampleIdentifier identifier = SampleIdentifierFactory.parse((String)plateIdentifier.getAugmentedCode());
                identifiers.add(identifier);
            }
            if (plateIdentifier.getPermId() == null) continue;
            permIds.add(new PermId(plateIdentifier.getPermId()));
        }
        if (!identifiers.isEmpty() && (status2 = this.identifierCollectionPredicate.evaluate(person, allowedRoles, identifiers)).isError()) {
            return status2;
        }
        if (!permIds.isEmpty() && (status = this.accessPECollectionPredicate.evaluate(person, allowedRoles, (Object)(accessPECollection = this.provider.getSampleCollectionAccessDataByPermIds(permIds)))).isError()) {
            return status;
        }
        return Status.OK;
    }

    public String getCandidateDescription() {
        return "plate";
    }
}

