/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Set;

abstract class SpaceValidator<T>
extends AbstractValidator<T> {
    SpaceValidator() {
    }

    protected abstract String getSpace(T var1);

    public boolean doValidation(PersonPE person, T value) {
        String spaceCode = this.getSpace(value);
        return this.validateSpace(person, spaceCode);
    }

    private boolean validateSpace(PersonPE person, String spaceCode) {
        Set roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            if (roleAssignment.getRoleWithHierarchy().isInstanceLevel()) {
                return true;
            }
            SpacePE group = roleAssignment.getSpace();
            if (group == null || !group.getCode().equals(spaceCode)) continue;
            return true;
        }
        return false;
    }
}

