/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.migration;

import ch.systemsx.cisd.dbmigration.java.MigrationStepAdapter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class MigrationStepFrom120To121
extends MigrationStepAdapter {
    private static final String OLD_CONTAINER_TYPE = "HCS_ANALYSIS_WELL_FEATURES_CONTAINER";
    private static final String NEW_CONTAINER_TYPE = "HCS_ANALYSIS_CONTAINER_WELL_FEATURES";
    private static final RowMapper<Long> ID_ROW_MAPPER = new RowMapper<Long>(){

        public final Long mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getLong("id");
        }
    };
    private static final RowMapper<DataSetTypePropertyType> DSTPRT_ROW_MAPPER = new RowMapper<DataSetTypePropertyType>(){

        public final DataSetTypePropertyType mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new DataSetTypePropertyType(rs.getLong("id"), rs.getLong("prty_id"));
        }
    };

    private Long getDataSetTypeId(JdbcTemplate simpleJdbcTemplate, String code) {
        List list = simpleJdbcTemplate.query("SELECT id from data_set_types where code = ?", ID_ROW_MAPPER, new Object[]{code});
        return list.size() > 0 ? (Long)list.get(0) : null;
    }

    Map<Long, Long> getNewPropertiesToOldProperties(JdbcTemplate simpleJdbcTemplate, long newTypeId, long oldTypeId) {
        String sql = "select id, prty_id from data_set_type_property_types where dsty_id = ?";
        List newTypeProperties = simpleJdbcTemplate.query(sql, DSTPRT_ROW_MAPPER, new Object[]{newTypeId});
        List oldTypeProperties = simpleJdbcTemplate.query(sql, DSTPRT_ROW_MAPPER, new Object[]{oldTypeId});
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        for (DataSetTypePropertyType newT : newTypeProperties) {
            for (DataSetTypePropertyType oldT : oldTypeProperties) {
                if (!oldT.prty_id.equals(newT.prty_id)) continue;
                result.put(newT.id, oldT.id);
            }
        }
        return result;
    }

    public void performPreMigration(JdbcTemplate simpleJdbcTemplate, DataSource dataSource) throws DataAccessException {
        Long newTypeId = this.getDataSetTypeId(simpleJdbcTemplate, NEW_CONTAINER_TYPE);
        Long oldTypeId = this.getDataSetTypeId(simpleJdbcTemplate, OLD_CONTAINER_TYPE);
        if (newTypeId != null && oldTypeId != null) {
            Map<Long, Long> propertyTypesMap = this.getNewPropertiesToOldProperties(simpleJdbcTemplate, newTypeId, oldTypeId);
            this.moveDatasetsFromNewTypeToOld(simpleJdbcTemplate, newTypeId, oldTypeId);
            this.movePropertiesFromNewTypeToOld(simpleJdbcTemplate, propertyTypesMap);
            this.deleteNewType(simpleJdbcTemplate, newTypeId);
        }
    }

    private void deleteNewType(JdbcTemplate simpleJdbcTemplate, Long newTypeId) {
        simpleJdbcTemplate.update("delete from data_set_type_property_types where dsty_id = ?", new Object[]{newTypeId});
        simpleJdbcTemplate.update("delete from data_set_types where id = ?", new Object[]{newTypeId});
    }

    private void movePropertiesFromNewTypeToOld(JdbcTemplate simpleJdbcTemplate, Map<Long, Long> propertyTypesMap) {
        for (Map.Entry<Long, Long> entry : propertyTypesMap.entrySet()) {
            simpleJdbcTemplate.update("update data_set_properties set dstpt_id = ? where dstpt_id = ?", new Object[]{entry.getValue(), entry.getKey()});
        }
    }

    private void moveDatasetsFromNewTypeToOld(JdbcTemplate simpleJdbcTemplate, Long newTypeId, Long oldTypeId) {
        simpleJdbcTemplate.update("update data_all set dsty_id = ? where dsty_id = ?", new Object[]{oldTypeId, newTypeId});
    }

    private static class DataSetTypePropertyType {
        Long id;
        Long prty_id;

        public DataSetTypePropertyType(Long id, Long prty_id) {
            this.id = id;
            this.prty_id = prty_id;
        }
    }
}

