/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.FeatureVectorDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.HCSImageDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

abstract class AbstractContentLoader {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractContentLoader.class);
    protected final Session session;
    protected final IScreeningBusinessObjectFactory businessObjectFactory;
    protected final IDAOFactory daoFactory;
    private IScreeningQuery screeningDao = null;

    protected AbstractContentLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, IScreeningQuery screeningDaoOrNull) {
        this.session = session;
        this.businessObjectFactory = businessObjectFactory;
        this.daoFactory = daoFactory;
        this.screeningDao = screeningDaoOrNull;
    }

    protected IScreeningQuery getScreeningDAO() {
        if (this.screeningDao == null) {
            this.screeningDao = (IScreeningQuery)QueryTool.getManagedQuery(IScreeningQuery.class);
        }
        return this.screeningDao;
    }

    protected final ExperimentReference loadExperimentByPermId(String experimentPermId) {
        ExperimentPE experiment = this.daoFactory.getExperimentDAO().tryGetByPermID(experimentPermId);
        return this.createExperimentReference(experiment, "permId = " + experimentPermId);
    }

    protected final ExperimentReference loadExperimentByTechId(TechId experimentTechId) {
        ExperimentPE experiment = (ExperimentPE)this.daoFactory.getExperimentDAO().tryGetByTechId(experimentTechId, new String[0]);
        return this.createExperimentReference(experiment, "id = " + experimentTechId);
    }

    private ExperimentReference createExperimentReference(ExperimentPE experimentOrNull, String criteriaDesc) {
        if (experimentOrNull == null) {
            throw new UserFailureException("Unkown experiment for " + criteriaDesc + ".");
        }
        ProjectPE project = experimentOrNull.getProject();
        return new ExperimentReference(experimentOrNull.getId(), experimentOrNull.getPermId(), experimentOrNull.getCode(), experimentOrNull.getEntityType().getCode(), project.getCode(), project.getSpace().getCode());
    }

    protected final HCSImageDatasetLoader createImageDatasetsRetriever(Set<PlateIdentifier> plates) {
        return new HCSImageDatasetLoader(this.session, this.businessObjectFactory, null, plates, new String[0]);
    }

    protected final FeatureVectorDatasetLoader createFeatureVectorDatasetsRetriever(Set<PlateIdentifier> plates, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        return new FeatureVectorDatasetLoader(this.session, this.businessObjectFactory, null, plates, analysisProcedureCriteria);
    }

    protected final StopWatch createWatchAndStart() {
        StopWatch watch = new StopWatch();
        watch.start();
        return watch;
    }
}

