/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AnalysisSettings {
    public static final String KEY = "data-set-types-with-available-analysis-summary";
    private final Map<String, String> dataSetType2reportingPluginMap = new HashMap<String, String>();

    public AnalysisSettings(Properties properties) {
        String property = properties.getProperty(KEY);
        if (property != null) {
            String[] splittedProperty;
            for (String dataSetTypeSetting : splittedProperty = property.split(",")) {
                int indexOfColon = (dataSetTypeSetting = dataSetTypeSetting.trim()).indexOf(58);
                if (indexOfColon < 0) {
                    throw new ConfigurationFailureException("Invalid property 'data-set-types-with-available-analysis-summary': missing ':' in '" + dataSetTypeSetting + "'.");
                }
                String dataSetTypeCode = dataSetTypeSetting.substring(0, indexOfColon);
                String reportingPluginKey = dataSetTypeSetting.substring(indexOfColon + 1);
                this.dataSetType2reportingPluginMap.put(dataSetTypeCode, reportingPluginKey);
            }
        }
    }

    public boolean noAnalysisSettings() {
        return this.dataSetType2reportingPluginMap.isEmpty();
    }

    public String tryToGetReportingPluginKey(AbstractExternalData ds) {
        return this.dataSetType2reportingPluginMap.get(ds.getDataSetType().getCode());
    }
}

