/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.openbis.plugin.screening.server.logic.IExperimentMetadataLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.WidthAndHeightAndPermIdDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.WidthAndHeightDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class ExperimentMetadaLoader
implements IExperimentMetadataLoader {
    private final long experimentId;
    private final List<IImagingReadonlyQueryDAO> imagingQueries;

    public ExperimentMetadaLoader(long experimentId, List<IImagingReadonlyQueryDAO> imagingQueries) {
        this.experimentId = experimentId;
        this.imagingQueries = imagingQueries;
    }

    @Override
    public Geometry tryGetPlateGeometry() {
        WidthAndHeightDTO plateGeometry = this.getUniqueOrNull(new IExperimentMetadataQuery<WidthAndHeightDTO>(){

            @Override
            public List<WidthAndHeightDTO> select(IImagingReadonlyQueryDAO query) {
                return query.listPlateGeometriesForExperiment(ExperimentMetadaLoader.this.experimentId);
            }
        });
        return this.asGeometry(plateGeometry);
    }

    @Override
    public Geometry tryGetTileGeometry() {
        WidthAndHeightDTO tileGeometry = this.getUniqueOrNull(new IExperimentMetadataQuery<WidthAndHeightDTO>(){

            @Override
            public List<WidthAndHeightDTO> select(IImagingReadonlyQueryDAO query) {
                return query.listTileGeometriesForExperiment(ExperimentMetadaLoader.this.experimentId);
            }
        });
        return this.asGeometry(tileGeometry);
    }

    @Override
    public List<ImageChannel> getImageChannels() {
        List<ImgChannelDTO> channels = this.getMergedResult(new IExperimentMetadataQuery<ImgChannelDTO>(){

            @Override
            public List<ImgChannelDTO> select(IImagingReadonlyQueryDAO query) {
                return query.getChannelsByExperimentId(ExperimentMetadaLoader.this.experimentId);
            }
        });
        List<ImgChannelDTO> uniqueChannels = this.removeDuplicates(channels);
        return this.asImageChannels(uniqueChannels);
    }

    @Override
    public ImageSize tryGetOriginalImageSize() {
        List<WidthAndHeightAndPermIdDTO> imageSizes = this.getImageSizes(true);
        HashSet<ImageSize> distinctSizes = new HashSet<ImageSize>();
        for (WidthAndHeightAndPermIdDTO size : imageSizes) {
            distinctSizes.add(this.asImageSize(size));
        }
        return distinctSizes.size() == 1 ? (ImageSize)distinctSizes.iterator().next() : null;
    }

    @Override
    public List<ImageSize> getThumbnailImageSizes() {
        List<WidthAndHeightAndPermIdDTO> imageSizes = this.getImageSizes(false);
        HashMap<String, HashSet<ImageSize>> dataSet2SizesMap = new HashMap<String, HashSet<ImageSize>>();
        for (WidthAndHeightAndPermIdDTO size : imageSizes) {
            String dataSetCode = size.getPermID();
            HashSet<ImageSize> set = (HashSet<ImageSize>)dataSet2SizesMap.get(dataSetCode);
            if (set == null) {
                set = new HashSet<ImageSize>();
                dataSet2SizesMap.put(dataSetCode, set);
            }
            set.add(this.asImageSize(size));
        }
        if (dataSet2SizesMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList values = new ArrayList(dataSet2SizesMap.values());
        ArrayList<ImageSize> sizes = new ArrayList<ImageSize>((Collection)values.get(0));
        int n = values.size();
        for (int i = 1; i < n; ++i) {
            sizes.retainAll((Collection)values.get(i));
        }
        Collections.sort(sizes, new Comparator<ImageSize>(){

            @Override
            public int compare(ImageSize s1, ImageSize s2) {
                return s1.getWidth() * s1.getHeight() - s2.getWidth() * s2.getWidth();
            }
        });
        return sizes;
    }

    private List<WidthAndHeightAndPermIdDTO> getImageSizes(final boolean original) {
        return this.getMergedResult(new IExperimentMetadataQuery<WidthAndHeightAndPermIdDTO>(){

            @Override
            public List<WidthAndHeightAndPermIdDTO> select(IImagingReadonlyQueryDAO query) {
                return query.listImageSizesForExperiment(ExperimentMetadaLoader.this.experimentId, original);
            }
        });
    }

    private List<ImgChannelDTO> removeDuplicates(List<ImgChannelDTO> channels) {
        TreeMap<String, ImgChannelDTO> channelsByCode = new TreeMap<String, ImgChannelDTO>();
        for (ImgChannelDTO channel : channels) {
            channelsByCode.put(channel.getCode(), channel);
        }
        return new ArrayList<ImgChannelDTO>(channelsByCode.values());
    }

    private List<ImageChannel> asImageChannels(List<ImgChannelDTO> channels) {
        ArrayList<ImageChannel> translated = new ArrayList<ImageChannel>();
        for (ImgChannelDTO channel : channels) {
            translated.add(this.asImageChannel(channel));
        }
        return translated;
    }

    private ImageChannel asImageChannel(ImgChannelDTO channel) {
        return new ImageChannel(channel.getCode(), channel.getLabel(), channel.getDescription(), channel.getWavelength(), Collections.emptyList());
    }

    private Geometry asGeometry(WidthAndHeightDTO widthAndHeight) {
        if (widthAndHeight == null) {
            return null;
        }
        return Geometry.createFromRowColDimensions(widthAndHeight.getHeight(), widthAndHeight.getWidth());
    }

    private ImageSize asImageSize(WidthAndHeightAndPermIdDTO size) {
        return new ImageSize(size.getWidth(), size.getHeight());
    }

    private <T> T getUniqueOrNull(IExperimentMetadataQuery<T> experimentMetadataQuery) {
        List<T> mergedResults = this.getMergedResult(experimentMetadataQuery);
        return this.getUniqueOrNull(mergedResults);
    }

    private <T> List<T> getMergedResult(IExperimentMetadataQuery<T> experimentMetadataQuery) {
        ArrayList<T> allResults = new ArrayList<T>();
        for (IImagingReadonlyQueryDAO imagingQueryDAO : this.imagingQueries) {
            List<T> singleResult = experimentMetadataQuery.select(imagingQueryDAO);
            if (singleResult == null) continue;
            allResults.addAll(singleResult);
        }
        return allResults;
    }

    private <T> T getUniqueOrNull(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        T first = list.get(0);
        for (T element : list) {
            if (first.equals(element)) continue;
            return null;
        }
        return first;
    }

    static interface IExperimentMetadataQuery<T> {
        public List<T> select(IImagingReadonlyQueryDAO var1);
    }
}

