/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.AbstractContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ReplicateSequenceProvider;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.WellDataLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.WellReplicaSummaryCalculator;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.MaterialAllReplicasFeatureVectors;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.MaterialBiologicalReplicateFeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.MaterialIdFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.MaterialTechnicalReplicateFeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.WellExtendedData;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialBiologicalReplicateFeatureSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaFeatureSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaFeatureSummaryResult;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaSummaryAggregationType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSummarySettings;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MaterialFeatureVectorSummaryLoader
extends AbstractContentLoader {
    private final MaterialSummarySettings settings;
    private final WellDataLoader wellDataLoader;

    public static MaterialReplicaFeatureSummaryResult loadMaterialFeatureVectors(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria, MaterialSummarySettings settings) {
        MaterialAllReplicasFeatureVectors resultOrNull = new MaterialFeatureVectorSummaryLoader(session, businessObjectFactory, daoFactory, null, settings).tryLoadMaterialFeatureVectors(criteria);
        List<MaterialReplicaFeatureSummary> replicaRows = MaterialFeatureVectorSummaryLoader.convertToFeatureRows(resultOrNull);
        List<String> subgroupLabels = MaterialFeatureVectorSummaryLoader.tryGetSubgroupLabels(resultOrNull);
        int materialsInExperiment = resultOrNull != null ? resultOrNull.getGeneralSummary().getNumberOfMaterialsInExperiment() : 0;
        return new MaterialReplicaFeatureSummaryResult(subgroupLabels, replicaRows, materialsInExperiment);
    }

    static List<MaterialReplicaFeatureSummary> convertToFeatureRows(MaterialAllReplicasFeatureVectors backendResult) {
        ArrayList<MaterialReplicaFeatureSummary> replicaRows = new ArrayList<MaterialReplicaFeatureSummary>();
        if (backendResult == null) {
            return replicaRows;
        }
        MaterialIdFeatureVectorSummary generalSummary = backendResult.getGeneralSummary();
        float[] featureVectorDeviatons = generalSummary.tryGetFeatureVectorDeviations();
        float[] featureVectorSummaries = generalSummary.getFeatureVectorSummary();
        int[] featureVectorRanks = generalSummary.getFeatureVectorRanks();
        List<CodeAndLabel> featureDescriptions = backendResult.getFeatureDescriptions();
        int numFeatures = featureDescriptions.size();
        for (int i = 0; i < numFeatures; ++i) {
            MaterialReplicaFeatureSummary replicaRow = new MaterialReplicaFeatureSummary();
            replicaRows.add(replicaRow);
            double deviation = featureVectorDeviatons == null ? Double.NaN : (double)featureVectorDeviatons[i];
            replicaRow.setFeatureVectorDeviation(deviation);
            replicaRow.setFeatureVectorSummary(featureVectorSummaries[i]);
            replicaRow.setFeatureVectorRank(featureVectorRanks[i]);
            replicaRow.setFeatureDescription(featureDescriptions.get(i));
            float[] defaultFeatureValues = MaterialFeatureVectorSummaryLoader.extractFeatureValues(i, backendResult.getDirectTechnicalReplicates());
            if (defaultFeatureValues != null) {
                MaterialBiologicalReplicateFeatureSummary defaultReplica = new MaterialBiologicalReplicateFeatureSummary(defaultFeatureValues, 0.0f, MaterialReplicaSummaryAggregationType.MEDIAN);
                replicaRow.setDirectTechnicalReplicates(defaultReplica);
            }
            List<MaterialBiologicalReplicateFeatureVector> backendSubgroups = backendResult.getBiologicalReplicates();
            ArrayList<MaterialBiologicalReplicateFeatureSummary> subgroups = new ArrayList<MaterialBiologicalReplicateFeatureSummary>();
            for (int tmp = 0; tmp < backendSubgroups.size(); ++tmp) {
                MaterialBiologicalReplicateFeatureVector backendGroup = backendSubgroups.get(tmp);
                float[] aggregatedSummaries = backendGroup.getAggregatedSummary();
                float[] featureValues = MaterialFeatureVectorSummaryLoader.extractFeatureValues(i, backendGroup.getTechnicalReplicatesValues());
                MaterialBiologicalReplicateFeatureSummary subgroup = new MaterialBiologicalReplicateFeatureSummary(featureValues, aggregatedSummaries[i], backendGroup.getSummaryAggregationType());
                subgroups.add(subgroup);
            }
            replicaRow.setBiologicalRelicates(subgroups);
        }
        return replicaRows;
    }

    private static List<String> tryGetSubgroupLabels(MaterialAllReplicasFeatureVectors backendResultOrNull) {
        ArrayList<String> subgroupLabels = new ArrayList<String>();
        if (backendResultOrNull == null) {
            return subgroupLabels;
        }
        for (MaterialBiologicalReplicateFeatureVector backendSubgroup : backendResultOrNull.getBiologicalReplicates()) {
            subgroupLabels.add(backendSubgroup.getSubgroupLabel());
        }
        return subgroupLabels;
    }

    private static float[] extractFeatureValues(int i, List<MaterialTechnicalReplicateFeatureVector> replicas) {
        float[] result = new float[replicas.size()];
        for (int pos = 0; pos < result.length; ++pos) {
            float[] featureVector = replicas.get(pos).getFeatueVector();
            result[pos] = MaterialFeatureVectorSummaryLoader.getValueOrNaN(i, featureVector);
        }
        return result;
    }

    private static float getValueOrNaN(int idx, float[] values) {
        if (values != null && idx < values.length) {
            return values[idx];
        }
        return Float.NaN;
    }

    @Private
    MaterialFeatureVectorSummaryLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, IScreeningQuery screeningQuery, MaterialSummarySettings settings) {
        super(session, businessObjectFactory, daoFactory, screeningQuery);
        this.settings = settings;
        this.wellDataLoader = new WellDataLoader(session, businessObjectFactory, daoFactory, screeningQuery, settings);
    }

    private MaterialAllReplicasFeatureVectors tryLoadMaterialFeatureVectors(WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria) {
        WellDataLoader.MaterialIdSummariesAndFeatures summaries = this.wellDataLoader.tryCalculateExperimentFeatureVectorSummaries(criteria, true);
        if (summaries == null) {
            return null;
        }
        TechId materialId = criteria.getMaterialId();
        MaterialIdFeatureVectorSummary materialGeneralSummary = MaterialFeatureVectorSummaryLoader.tryFindMaterialSummary(materialId, summaries.getFeatureSummaries());
        if (materialGeneralSummary == null) {
            return null;
        }
        List<WellExtendedData> materialWellsData = this.wellDataLoader.tryLoadWellData(criteria);
        if (materialWellsData == null) {
            return null;
        }
        return this.createMaterialFeatureVectors(materialId, materialWellsData, materialGeneralSummary, summaries.getFeatureNames());
    }

    @Private
    MaterialAllReplicasFeatureVectors createMaterialFeatureVectors(TechId materialId, List<WellExtendedData> materialWellsData, MaterialIdFeatureVectorSummary materialGeneralSummary, List<CodeAndLabel> featureNames) {
        ReplicateSequenceProvider replicaSequences = new ReplicateSequenceProvider(materialWellsData, this.settings.getBiologicalReplicatePropertyTypeCodes());
        List<MaterialBiologicalReplicateFeatureVector> subgroups = this.createBiologicalReplicates(materialWellsData, replicaSequences);
        List<MaterialTechnicalReplicateFeatureVector> replicas = MaterialFeatureVectorSummaryLoader.filterDirectTechnicalReplicas(materialWellsData, replicaSequences);
        return new MaterialAllReplicasFeatureVectors(featureNames, materialGeneralSummary, subgroups, replicas);
    }

    private List<MaterialBiologicalReplicateFeatureVector> createBiologicalReplicates(List<WellExtendedData> materialWells, ReplicateSequenceProvider replicaSequences) {
        GroupByMap<Integer, WellExtendedData> biologicalReplicateMap = this.groupByBiologicalReplicate(materialWells, replicaSequences);
        ArrayList<MaterialBiologicalReplicateFeatureVector> subgroups = new ArrayList<MaterialBiologicalReplicateFeatureVector>();
        MaterialReplicaSummaryAggregationType aggregationType = this.settings.getAggregationType();
        for (Integer biologicalReplicateSeq : replicaSequences.getBiologicalReplicateSequences()) {
            List technicalReplicateWells = biologicalReplicateMap.getOrDie((Object)biologicalReplicateSeq);
            MaterialBiologicalReplicateFeatureVector subgroup = this.createBiologicalReplicate(technicalReplicateWells, replicaSequences, aggregationType);
            subgroups.add(subgroup);
        }
        return subgroups;
    }

    private MaterialBiologicalReplicateFeatureVector createBiologicalReplicate(List<WellExtendedData> technicalReplicateWells, ReplicateSequenceProvider replicaSequences, MaterialReplicaSummaryAggregationType aggregationType) {
        float[] aggregatedSummary = WellReplicaSummaryCalculator.calculateSummaryFeatureVector(technicalReplicateWells, aggregationType);
        List<MaterialTechnicalReplicateFeatureVector> replicas = MaterialFeatureVectorSummaryLoader.createTechnicalReplicates(technicalReplicateWells, replicaSequences);
        String subgroupLabel = this.getSubgroupLabel(technicalReplicateWells, replicaSequences);
        return new MaterialBiologicalReplicateFeatureVector(replicas, aggregatedSummary, aggregationType, subgroupLabel);
    }

    private String getSubgroupLabel(List<WellExtendedData> subgroupWellDataList, ReplicateSequenceProvider replicaSequences) {
        assert (subgroupWellDataList.size() > 0) : "empty subgroup";
        IEntityPropertiesHolder well = subgroupWellDataList.get(0);
        String label = replicaSequences.tryGetBiologicalReplicateLabel(well);
        assert (label != null) : "no biological replicates!";
        return label;
    }

    private static List<MaterialTechnicalReplicateFeatureVector> filterDirectTechnicalReplicas(List<WellExtendedData> materialWellDataList, final ReplicateSequenceProvider replicaSequences) {
        List directTechnicalReplicas = CollectionUtils.filter(materialWellDataList, (CollectionUtils.ICollectionFilter)new CollectionUtils.ICollectionFilter<WellExtendedData>(){

            public boolean isPresent(WellExtendedData element) {
                return !replicaSequences.isBiologicalReplicate(element);
            }
        });
        MaterialFeatureVectorSummaryLoader.sortByTechnicalReplicateSequence(directTechnicalReplicas, replicaSequences);
        return MaterialFeatureVectorSummaryLoader.createTechnicalReplicates(directTechnicalReplicas, replicaSequences);
    }

    private static List<MaterialTechnicalReplicateFeatureVector> createTechnicalReplicates(List<WellExtendedData> wells, ReplicateSequenceProvider replicaSequences) {
        ArrayList<MaterialTechnicalReplicateFeatureVector> replicas = new ArrayList<MaterialTechnicalReplicateFeatureVector>();
        for (WellExtendedData wellData : wells) {
            int replicaSequenceNumber = replicaSequences.getTechnicalReplicateSequence(wellData);
            MaterialTechnicalReplicateFeatureVector featureVector = new MaterialTechnicalReplicateFeatureVector(replicaSequenceNumber, wellData.getFeatureVector());
            replicas.add(featureVector);
        }
        return replicas;
    }

    private static void sortByTechnicalReplicateSequence(List<WellExtendedData> materialWellDataList, final ReplicateSequenceProvider replicaSequences) {
        Collections.sort(materialWellDataList, new Comparator<WellExtendedData>(){

            @Override
            public int compare(WellExtendedData w1, WellExtendedData w2) {
                Integer replicaSequenceNumber1 = replicaSequences.getTechnicalReplicateSequence(w1);
                Integer replicaSequenceNumber2 = replicaSequences.getTechnicalReplicateSequence(w2);
                return replicaSequenceNumber1.compareTo(replicaSequenceNumber2);
            }
        });
    }

    private GroupByMap<Integer, WellExtendedData> groupByBiologicalReplicate(List<WellExtendedData> materialWellDataList, final ReplicateSequenceProvider replicaSequences) {
        return GroupByMap.create(materialWellDataList, (IGroupKeyExtractor)new IGroupKeyExtractor<Integer, WellExtendedData>(){

            public Integer getKey(WellExtendedData wellData) {
                return replicaSequences.tryGetBiologicalReplicateSequence(wellData);
            }
        });
    }

    private static MaterialIdFeatureVectorSummary tryFindMaterialSummary(TechId materialId, List<MaterialIdFeatureVectorSummary> featureSummaries) {
        for (MaterialIdFeatureVectorSummary summary : featureSummaries) {
            if (!((Long)summary.getMaterial()).equals(materialId.getId())) continue;
            return summary;
        }
        return null;
    }
}

