/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.ExperimentReferenceQueryResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.AbstractContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.WellDataLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSimpleFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSummarySettings;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.time.StopWatch;

public class MaterialFeaturesFromAllExperimentsLoader
extends AbstractContentLoader {
    private static final Integer MAX_ANALYSIS_DATASETS_IN_BATCH = 100;
    private final WellDataLoader wellDataLoader;

    public static List<MaterialSimpleFeatureVectorSummary> loadMaterialFeatureVectorsFromAllAssays(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, TechId materialId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks, TechId projectTechIdOrNull, MaterialSummarySettings settings) {
        MaterialFeaturesFromAllExperimentsLoader loader = new MaterialFeaturesFromAllExperimentsLoader(session, businessObjectFactory, daoFactory, null, settings);
        List<ExperimentReference> experiments = loader.fetchExperiments(materialId, projectTechIdOrNull);
        return loader.loadMaterialFeatureVectorsFromAllAssays(materialId, analysisProcedureCriteria, computeRanks, experiments);
    }

    private List<ExperimentReference> fetchExperiments(TechId materialId, TechId projectTechIdOrNull) {
        IScreeningQuery dao = this.getScreeningDAO();
        List<ExperimentReferenceQueryResult> experimentRefs = projectTechIdOrNull == null ? dao.getExperimentsWithMaterial(materialId.getId()) : dao.getExperimentsWithMaterial(materialId.getId(), projectTechIdOrNull.getId());
        return MaterialFeaturesFromAllExperimentsLoader.asExperimentReferences(experimentRefs);
    }

    private static List<ExperimentReference> asExperimentReferences(List<ExperimentReferenceQueryResult> experiments) {
        Collection references = CollectionUtils.collect(experiments, (Transformer)new Transformer<ExperimentReferenceQueryResult, ExperimentReference>(){

            public ExperimentReference transform(ExperimentReferenceQueryResult experiment) {
                return MaterialFeaturesFromAllExperimentsLoader.createExperimentReference(experiment);
            }
        });
        return new LinkedList<ExperimentReference>(references);
    }

    private static ExperimentReference createExperimentReference(ExperimentReferenceQueryResult exp) {
        return new ExperimentReference(exp.exp_id, exp.exp_perm_id, exp.exp_code, exp.exp_type_code, exp.proj_code, exp.space_code);
    }

    private MaterialFeaturesFromAllExperimentsLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, IScreeningQuery screeningQuery, MaterialSummarySettings settings) {
        super(session, businessObjectFactory, daoFactory, screeningQuery);
        this.wellDataLoader = new WellDataLoader(session, businessObjectFactory, daoFactory, screeningQuery, settings);
    }

    private List<MaterialSimpleFeatureVectorSummary> loadMaterialFeatureVectorsFromAllAssays(TechId materialId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks, List<ExperimentReference> experiments) {
        ArrayList<MaterialSimpleFeatureVectorSummary> summaries = new ArrayList<MaterialSimpleFeatureVectorSummary>();
        StopWatch globalWatch = this.createWatchAndStart();
        ArrayList<ExperimentReference> experimentsBatch = new ArrayList<ExperimentReference>();
        long datasetsInBatch = 0L;
        for (int i = 0; i < experiments.size(); ++i) {
            ExperimentReference experiment = experiments.get(i);
            int datasetsNum = this.countAnalysisDatasets(experiment);
            operationLog.info((Object)String.format("Experiment %s contains %d analysis datasets", experiment, datasetsNum));
            if (datasetsNum == 0) {
                summaries.add(new MaterialSimpleFeatureVectorSummary(experiment));
            } else {
                datasetsInBatch += (long)datasetsNum;
                experimentsBatch.add(experiment);
            }
            if (datasetsInBatch < (long)MAX_ANALYSIS_DATASETS_IN_BATCH.intValue() && (i != experiments.size() - 1 || experimentsBatch.isEmpty())) continue;
            operationLog.info((Object)String.format("Processing %d experiments with %d datasets: %s", experimentsBatch.size(), datasetsInBatch, experimentsBatch));
            List<MaterialSimpleFeatureVectorSummary> batchSummaries = this.wellDataLoader.loadMaterialFeatureVectorsFromAllAssaysBatch(materialId, analysisProcedureCriteria, computeRanks, experimentsBatch);
            summaries.addAll(batchSummaries);
            experimentsBatch.clear();
            datasetsInBatch = 0L;
        }
        operationLog.info((Object)String.format("[%d msec] Fetching and calculating analysis summaries for %d experiments.", globalWatch.getTime(), summaries.size()));
        return summaries;
    }

    private int countAnalysisDatasets(ExperimentReference experiment) {
        IDatasetLister lister = this.businessObjectFactory.createDatasetLister(this.session);
        List datasets = lister.listByExperimentTechId(new TechId(experiment.getId()), true);
        return ScreeningUtils.filterImageAnalysisDatasets(datasets).size();
    }
}

