/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PlateDatasetLoader {
    protected final Session session;
    protected final IScreeningBusinessObjectFactory businessObjectFactory;
    private final Set<? extends PlateIdentifier> plates;
    private final String[] datasetTypeCodePatterns;
    private String homeSpaceOrNull;
    private List<Sample> samples;
    private List<AbstractExternalData> datasets;
    private HashMap<SampleIdentifier, Sample> samplesByIdentifier;
    private HashMap<Long, Sample> samplesById;
    private Set<Long> initialSampleIds;
    private boolean loaded = false;

    PlateDatasetLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, String homeSpaceOrNull, Set<? extends PlateIdentifier> plates, String ... datasetTypeCodes) {
        this.session = session;
        this.businessObjectFactory = businessObjectFactory;
        this.homeSpaceOrNull = homeSpaceOrNull != null ? "/" + homeSpaceOrNull + "/" : null;
        this.plates = plates;
        this.datasetTypeCodePatterns = datasetTypeCodes;
    }

    protected List<AbstractExternalData> getDatasets() {
        return this.datasets;
    }

    protected void load() {
        if (!this.loaded) {
            this.loadSamples();
            this.loadDatasets();
            this.loaded = true;
        }
    }

    private void loadSamples() {
        String[] sampleCodesArray = this.extractSampleCodes();
        String[] samplePermIdArray = this.extractPermIds();
        ListOrSearchSampleCriteria criteria = new ListOrSearchSampleCriteria(sampleCodesArray, samplePermIdArray);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        this.samples = sampleLister.list(criteria);
        this.initializeSampleMaps();
        this.filterSamplesByPlateIdentifiers();
    }

    private void loadDatasets() {
        IDatasetLister datasetLister = this.businessObjectFactory.createDatasetLister(this.session);
        this.datasets = datasetLister.listBySampleIds(this.initialSampleIds);
        this.datasets = ScreeningUtils.filterExternalDataByTypePattern(this.datasets, this.datasetTypeCodePatterns);
    }

    private void initializeSampleMaps() {
        this.samplesByIdentifier = new HashMap();
        this.samplesById = new HashMap();
        for (Sample sample : this.samples) {
            this.samplesByIdentifier.put(PlateDatasetLoader.createSampleIdentifier(sample), sample);
            this.samplesById.put(sample.getId(), sample);
        }
        this.initialSampleIds = new HashSet<Long>(this.samplesById.keySet());
    }

    private void filterSamplesByPlateIdentifiers() {
        HashSet<String> augmentedCodeSet = new HashSet<String>(this.plates.size());
        HashSet<String> permIdSet = new HashSet<String>(this.plates.size());
        for (PlateIdentifier plateIdentifier : this.plates) {
            if (plateIdentifier.getPermId() != null) {
                permIdSet.add(plateIdentifier.getPermId());
                continue;
            }
            if (SpaceCodeHelper.isHomeSpace((String)plateIdentifier.tryGetSpaceCode())) {
                if (this.homeSpaceOrNull == null) {
                    throw UserFailureException.fromTemplate((String)"Plate '%s' is in home space, but user has no home space defined.", (Object[])new Object[]{plateIdentifier});
                }
                augmentedCodeSet.add(this.homeSpaceOrNull + plateIdentifier.getAugmentedCode());
                continue;
            }
            augmentedCodeSet.add(plateIdentifier.getAugmentedCode());
        }
        Iterator<Sample> it = this.samples.iterator();
        while (it.hasNext()) {
            String augmentedCode;
            Sample sample = it.next();
            String sampleSpaceCodeOrNull = null == sample.getSpace() ? null : sample.getSpace().getCode();
            String string = augmentedCode = sampleSpaceCodeOrNull == null ? "/" + sample.getCode() : "/" + sampleSpaceCodeOrNull + "/" + sample.getCode();
            if (permIdSet.contains(sample.getPermId()) || augmentedCodeSet.contains(augmentedCode)) continue;
            it.remove();
            this.samplesByIdentifier.remove(PlateDatasetLoader.createSampleIdentifier(sample));
            this.samplesById.remove(sample.getId());
        }
    }

    protected PlateIdentifier createPlateIdentifier(AbstractExternalData dataSet) {
        return ScreeningUtils.createPlateIdentifier(this.getSample(dataSet));
    }

    protected static ExperimentIdentifier createExperimentIdentifier(AbstractExternalData parentDataset) {
        Space space;
        Sample sample;
        Experiment experiment = parentDataset.getExperiment();
        if (experiment == null) {
            return null;
        }
        String code = experiment.getCode();
        String permId = experiment.getPermId();
        String projectCode = null;
        String spaceCode = null;
        Project project = experiment.getProject();
        if (project != null) {
            projectCode = project.getCode();
            Space space2 = project.getSpace();
            if (space2 != null) {
                spaceCode = space2.getCode();
            }
        }
        if (spaceCode == null && (sample = parentDataset.getSample()) != null && (space = sample.getSpace()) != null) {
            spaceCode = space.getCode();
        }
        return new ExperimentIdentifier(code, projectCode, spaceCode, permId);
    }

    protected Geometry extractPlateGeometry(AbstractExternalData dataSet) {
        Sample sample = this.getSample(dataSet);
        List properties = sample.getProperties();
        for (IEntityProperty property : properties) {
            PropertyType propertyType = property.getPropertyType();
            if (!propertyType.getCode().equals("$PLATE_GEOMETRY")) continue;
            String code = property.getVocabularyTerm().getCode();
            try {
                return Geometry.createFromPlateGeometryString(code);
            }
            catch (IllegalArgumentException ex) {
                throw new UserFailureException("Invalid property $PLATE_GEOMETRY: " + code);
            }
        }
        throw new UserFailureException("Sample '" + sample.getIdentifier() + "' has no property " + "$PLATE_GEOMETRY");
    }

    protected Map<String, String> extractProperties(AbstractExternalData dataSet) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (dataSet.getProperties() != null) {
            for (IEntityProperty prop : dataSet.getProperties()) {
                String value = prop.tryGetAsString();
                if (value == null) continue;
                properties.put(prop.getPropertyType().getCode(), value);
            }
        }
        return properties;
    }

    private Sample getSample(AbstractExternalData dataset) {
        Sample sample = dataset.getSample();
        if (sample == null) {
            DataSetType dataSetType = dataset.getDataSetType();
            throw new IllegalStateException("dataset not connected to a sample: " + dataset.getCode() + (dataSetType == null ? "" : " [" + dataSetType.getCode() + "]"));
        }
        Sample result = this.samplesById.get(sample.getId());
        if (result == null) {
            ListOrSearchSampleCriteria criteria = new ListOrSearchSampleCriteria(Collections.singletonList(sample.getId()));
            ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
            this.samples = sampleLister.list(criteria);
            assert (this.samples.size() == 1);
            result = this.samples.get(0);
            this.samplesById.put(sample.getId(), result);
        }
        return result;
    }

    private String[] extractSampleCodes() {
        ArrayList<String> sampleCodes = new ArrayList<String>();
        for (PlateIdentifier plateIdentifier : this.plates) {
            if (plateIdentifier.getPlateCode() == null || plateIdentifier.getPermId() != null) continue;
            sampleCodes.add(plateIdentifier.getPlateCode());
        }
        String[] sampleCodesArray = new String[sampleCodes.size()];
        sampleCodes.toArray(sampleCodesArray);
        return sampleCodesArray;
    }

    private String[] extractPermIds() {
        ArrayList<String> samplePermIds = new ArrayList<String>();
        for (PlateIdentifier plateIdentifier : this.plates) {
            if (plateIdentifier.getPermId() == null) continue;
            samplePermIds.add(plateIdentifier.getPermId());
        }
        String[] sampleCodesArray = new String[samplePermIds.size()];
        samplePermIds.toArray(sampleCodesArray);
        return sampleCodesArray;
    }

    protected static String getDataStoreUrlFromDataStore(DataStore dataStore) {
        String datastoreUrl = dataStore.getHostUrl();
        if (datastoreUrl.endsWith("/")) {
            datastoreUrl = datastoreUrl.substring(0, datastoreUrl.length() - 1);
        }
        return datastoreUrl;
    }

    protected static SampleIdentifier createSampleIdentifier(Sample sample) {
        SampleOwnerIdentifier owner;
        Space spaceOrNull = sample.getSpace();
        Project project = sample.getProject();
        if (project != null) {
            Space projectSpace = project.getSpace();
            if (projectSpace == null) {
                throw new IllegalArgumentException("Missing project space of sample " + sample.getIdentifier());
            }
            owner = new SampleOwnerIdentifier(new ProjectIdentifier(projectSpace.getCode(), project.getCode()));
        } else if (spaceOrNull != null) {
            SpaceIdentifier space = new SpaceIdentifier(spaceOrNull.getCode());
            owner = new SampleOwnerIdentifier(space);
        } else {
            owner = new SampleOwnerIdentifier();
        }
        return SampleIdentifier.createOwnedBy((SampleOwnerIdentifier)owner, (String)sample.getCode());
    }
}

