/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SamplePropertyAccessValidator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.Translator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.ScreeningExperimentValidator;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.PlateGeometryContainer;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.WellContentQueryResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.FeatureVectorDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.IExperimentMetadataLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.PlateContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.WellContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentImageMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellMaterialMapping;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellReferenceWithDatasets;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.lang3.StringUtils;

@Friend(toClasses={WellContentQueryResult.class, PlateGeometryContainer.class})
public class ScreeningApiImpl {
    private final Session session;
    private final IScreeningBusinessObjectFactory businessObjectFactory;
    private final IDAOFactory daoFactory;
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public ScreeningApiImpl(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.session = session;
        this.businessObjectFactory = businessObjectFactory;
        this.daoFactory = daoFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    public List<FeatureVectorDatasetReference> listFeatureVectorDatasets(List<? extends PlateIdentifier> plates) {
        FeatureVectorDatasetLoader datasetRetriever = this.createDatasetRetriever(plates);
        List<FeatureVectorDatasetReference> result = datasetRetriever.getFeatureVectorDatasetReferences();
        return result;
    }

    public List<ImageDatasetReference> listImageDatasets(List<? extends PlateIdentifier> plates) {
        return this.createDatasetRetriever(plates).getImageDatasetReferences();
    }

    public List<ImageDatasetReference> listRawImageDatasets(List<? extends PlateIdentifier> plates) {
        return this.createDatasetRetriever(plates).getRawImageDatasetReferences();
    }

    public List<ImageDatasetReference> listSegmentationImageDatasets(List<? extends PlateIdentifier> plates) {
        return this.createDatasetRetriever(plates).getSegmentationImageDatasetReferences();
    }

    private FeatureVectorDatasetLoader createDatasetRetriever(List<? extends PlateIdentifier> plates) {
        return new FeatureVectorDatasetLoader(this.session, this.businessObjectFactory, this.session.tryGetHomeGroupCode(), new HashSet<PlateIdentifier>(plates));
    }

    public List<Plate> listPlates() {
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        ListSampleCriteria criteria = new ListSampleCriteria();
        criteria.setSampleType(this.loadPlateType());
        criteria.setIncludeSpace(true);
        criteria.setSpaceCode(null);
        criteria.setExcludeWithoutExperiment(true);
        List samples = sampleLister.list(new ListOrSearchSampleCriteria(criteria));
        return ScreeningApiImpl.asPlates(samples);
    }

    public List<Plate> listPlates(ExperimentIdentifier experiment) {
        TechId experimentId = this.getExperimentTechId(experiment);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        ListSampleCriteria criteria = ListSampleCriteria.createForExperiment((TechId)experimentId);
        List samples = sampleLister.list(new ListOrSearchSampleCriteria(criteria));
        return ScreeningApiImpl.asPlates(samples);
    }

    private static List<Plate> asPlates(List<Sample> samples) {
        ArrayList<Plate> plates = new ArrayList<Plate>();
        for (Sample sample : samples) {
            if (!"PLATE".equals(sample.getEntityType().getCode())) continue;
            plates.add(ScreeningApiImpl.asPlate(sample));
        }
        Collections.sort(plates, new Comparator<Plate>(){

            @Override
            public int compare(Plate o1, Plate o2) {
                return o1.getAugmentedCode().compareTo(o2.getAugmentedCode());
            }
        });
        return plates;
    }

    private static Plate asPlate(Sample sample) {
        Experiment experiment = sample.getExperiment();
        Project project = experiment.getProject();
        Space sampleSpace = sample.getSpace();
        Project sampleProject = sample.getProject();
        String sampleProjectCode = sampleProject == null ? null : sampleProject.getCode();
        String experimentSpaceCode = project.getSpace().getCode();
        String sampleSpaceCode = sampleSpace != null ? sampleSpace.getCode() : experimentSpaceCode;
        ExperimentIdentifier experimentId = new ExperimentIdentifier(experiment.getCode(), project.getCode(), experimentSpaceCode, experiment.getPermId());
        return new Plate(sample.getCode(), sampleSpaceCode, sampleProjectCode, sample.getPermId(), experimentId);
    }

    private SampleType loadPlateType() {
        ISampleTypeDAO sampleTypeDAO = this.daoFactory.getSampleTypeDAO();
        SampleTypePE plateTypePE = sampleTypeDAO.tryFindSampleTypeByCode("PLATE");
        if (plateTypePE == null) {
            throw new Error("The database has not been initialized properly for screening, sample type 'PLATE' not found.");
        }
        return SampleTypeTranslator.translate((SampleTypePE)plateTypePE, null, null);
    }

    public List<ExperimentIdentifier> listExperiments() {
        List experiments = this.daoFactory.getExperimentDAO().listExperiments();
        List<ExperimentIdentifier> experimentIds = ScreeningApiImpl.asExperimentIdentifiers(experiments);
        this.sortByAugmentedCode(experimentIds);
        return experimentIds;
    }

    private void sortByAugmentedCode(List<ExperimentIdentifier> experimentIds) {
        Collections.sort(experimentIds, new Comparator<ExperimentIdentifier>(){

            @Override
            public int compare(ExperimentIdentifier o1, ExperimentIdentifier o2) {
                return o1.getAugmentedCode().compareTo(o2.getAugmentedCode());
            }
        });
    }

    public List<ExperimentIdentifier> listExperiments(String userId) {
        PersonPE user = this.daoFactory.getPersonDAO().tryFindPersonByUserId(userId);
        if (user == null) {
            return Collections.emptyList();
        }
        List experiments = this.daoFactory.getExperimentDAO().listExperiments();
        List<ExperimentIdentifier> experimentIds = ScreeningApiImpl.asExperimentIdentifiers(experiments);
        this.filterForUser(user, experimentIds);
        this.sortByAugmentedCode(experimentIds);
        return experimentIds;
    }

    private void filterForUser(PersonPE user, List<ExperimentIdentifier> experimentIds) {
        ScreeningExperimentValidator validator = new ScreeningExperimentValidator();
        validator.init((IAuthorizationDataProvider)new AuthorizationDataProvider((IAuthorizationDAOFactory)this.daoFactory));
        Iterator<ExperimentIdentifier> it = experimentIds.iterator();
        while (it.hasNext()) {
            ExperimentIdentifier id = it.next();
            if (validator.doValidation(user, id)) continue;
            it.remove();
        }
    }

    private static List<ExperimentIdentifier> asExperimentIdentifiers(List<ExperimentPE> experiments) {
        ArrayList<ExperimentIdentifier> experimentIds = new ArrayList<ExperimentIdentifier>();
        for (ExperimentPE experiment : experiments) {
            experimentIds.add(ScreeningApiImpl.asExperimentIdentifier(experiment));
        }
        return experimentIds;
    }

    private static ExperimentIdentifier asExperimentIdentifier(ExperimentPE experiment) {
        ExperimentIdentifier experimentId = new ExperimentIdentifier(experiment.getCode(), experiment.getProject().getCode(), experiment.getProject().getSpace().getCode(), experiment.getPermId());
        return experimentId;
    }

    public List<IDatasetIdentifier> getDatasetIdentifiers(List<String> datasetCodes) {
        IDataBO externalDataBO = this.businessObjectFactory.createDataBO(this.session);
        ArrayList<IDatasetIdentifier> identifiers = new ArrayList<IDatasetIdentifier>();
        for (String datasetCode : datasetCodes) {
            identifiers.add(this.getDatasetIdentifier(externalDataBO, datasetCode));
        }
        return identifiers;
    }

    private IDatasetIdentifier getDatasetIdentifier(IDataBO dataBO, String datasetCode) {
        dataBO.loadByCode(datasetCode);
        DataPE dataSet = dataBO.getData();
        if (dataSet == null) {
            throw UserFailureException.fromTemplate((String)"Dataset '%s' does not exist", (Object[])new Object[]{datasetCode});
        }
        return new DatasetIdentifier(datasetCode, dataSet.getDataStore().getDownloadUrl());
    }

    public List<PlateWellReferenceWithDatasets> listPlateWells(ExperimentIdentifier experimentIdentifier, MaterialIdentifier materialIdentifier, boolean findDatasets) {
        MaterialPE materialOrNull = this.daoFactory.getMaterialDAO().tryFindMaterial(new ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier(materialIdentifier.getMaterialCode(), materialIdentifier.getMaterialTypeIdentifier().getMaterialTypeCode()));
        if (materialOrNull == null) {
            throw UserFailureException.fromTemplate((String)"Material '%s' does not exist", (Object[])new Object[]{materialIdentifier.getAugmentedCode()});
        }
        ExperimentPE experiment = this.getExperimentFromDB(experimentIdentifier);
        ExperimentIdentifier fullExperimentIdentifier = ScreeningApiImpl.asExperimentIdentifier(experiment);
        List<WellContent> wellContents = this.loadWellContentMetadata(materialOrNull, experiment);
        if (findDatasets) {
            Set<Plate> plates = ScreeningApiImpl.extractPlates(wellContents, fullExperimentIdentifier);
            FeatureVectorDatasetLoader datasetRetriever = new FeatureVectorDatasetLoader(this.session, this.businessObjectFactory, this.session.tryGetHomeGroupCode(), plates);
            List<ImageDatasetReference> imageDatasets = datasetRetriever.getImageDatasetReferences();
            List<FeatureVectorDatasetReference> featureVectorDatasets = datasetRetriever.getFeatureVectorDatasetReferences();
            return ScreeningApiImpl.asPlateWellReferences(fullExperimentIdentifier, wellContents, ScreeningApiImpl.createPlateToDatasetsMap(imageDatasets, featureVectorDatasets));
        }
        return ScreeningApiImpl.asPlateWellReferences(fullExperimentIdentifier, wellContents, Collections.emptyMap());
    }

    private List<WellContent> loadWellContentMetadata(MaterialPE materialOrNull, ExperimentPE experiment) {
        return WellContentLoader.loadOnlyMetadata(this.session, this.businessObjectFactory, this.daoFactory, new TechId(materialOrNull.getId()), new TechId(experiment.getId()));
    }

    private static Set<Plate> extractPlates(List<WellContent> wellContents, ExperimentIdentifier fullExperimentIdentifier) {
        HashSet<Plate> plates = new HashSet<Plate>(wellContents.size());
        for (WellContent wellContent : wellContents) {
            plates.add(ScreeningApiImpl.asPlate(fullExperimentIdentifier, wellContent));
        }
        return plates;
    }

    public List<PlateWellReferenceWithDatasets> listPlateWells(MaterialIdentifier materialIdentifier, boolean findDatasets) {
        MaterialPE materialOrNull = this.daoFactory.getMaterialDAO().tryFindMaterial(new ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier(materialIdentifier.getMaterialCode(), materialIdentifier.getMaterialTypeIdentifier().getMaterialTypeCode()));
        if (materialOrNull == null) {
            throw UserFailureException.fromTemplate((String)"Material '%s' does not exist", (Object[])new Object[]{materialIdentifier.getAugmentedCode()});
        }
        List<WellContent> wellContent = WellContentLoader.loadOnlyMetadata(this.session, this.businessObjectFactory, this.daoFactory, new TechId(materialOrNull.getId()));
        if (findDatasets) {
            HashSet<Plate> plates = new HashSet<Plate>(wellContent.size());
            for (WellContent w : wellContent) {
                plates.add(ScreeningApiImpl.asPlate(w));
            }
            FeatureVectorDatasetLoader datasetRetriever = new FeatureVectorDatasetLoader(this.session, this.businessObjectFactory, this.session.tryGetHomeGroupCode(), plates);
            List<ImageDatasetReference> imageDatasets = datasetRetriever.getImageDatasetReferences();
            List<FeatureVectorDatasetReference> featureVectorDatasets = datasetRetriever.getFeatureVectorDatasetReferences();
            return ScreeningApiImpl.asPlateWellReferences(wellContent, ScreeningApiImpl.createPlateToDatasetsMap(imageDatasets, featureVectorDatasets));
        }
        return ScreeningApiImpl.asPlateWellReferences(wellContent, Collections.emptyMap());
    }

    public List<WellIdentifier> listPlateWells(PlateIdentifier plateIdentifier) {
        TechId plateSampleId = this.getSampleTechId(plateIdentifier);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        ListSampleCriteria criteria = ListSampleCriteria.createForContainer((TechId)plateSampleId);
        List samples = sampleLister.list(new ListOrSearchSampleCriteria(criteria));
        return this.asWellIdentifiers(samples, plateIdentifier);
    }

    private TechId getSampleTechId(PlateIdentifier plateIdentifier) {
        return TechId.create((IIdHolder)this.getSample(plateIdentifier));
    }

    private Sample getSample(PlateIdentifier plateIdentifier) {
        Sample sample;
        if (plateIdentifier.getPermId() != null) {
            sample = this.loadSampleByPermId(plateIdentifier.getPermId(), false);
        } else {
            SampleIdentifier sampleIdentifier = ScreeningApiImpl.createSampleIdentifier(plateIdentifier);
            ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(this.session);
            sampleBO.loadBySampleIdentifier(sampleIdentifier);
            sample = SampleTranslator.translate((SamplePE)sampleBO.getSample(), (String)"", null, (IManagedPropertyEvaluatorFactory)this.managedPropertyEvaluatorFactory, (IValidator)new SamplePropertyAccessValidator(this.session, (IAuthorizationDAOFactory)this.businessObjectFactory.getDAOFactory()));
        }
        return sample;
    }

    public ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample getWellSample(WellIdentifier wellIdentifier, boolean enrichWithProperties) {
        Sample sample = this.loadSampleByPermId(wellIdentifier.getPermId(), enrichWithProperties);
        return Translator.translate((Sample)sample);
    }

    public ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample getPlateSample(PlateIdentifier plateIdentifier) {
        return Translator.translate((Sample)this.getSample(plateIdentifier));
    }

    private Sample loadSampleByPermId(String permId, boolean enrichWithProperties) {
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(this.session);
        sampleBO.loadBySamplePermId(permId);
        if (enrichWithProperties) {
            sampleBO.enrichWithProperties();
        }
        SamplePE samplePE = sampleBO.getSample();
        return this.translate(samplePE);
    }

    private Sample translate(SamplePE sample) {
        return SampleTranslator.translate((SamplePE)sample, (String)this.session.getBaseIndexURL(), null, (IManagedPropertyEvaluatorFactory)this.managedPropertyEvaluatorFactory, (IValidator)new SamplePropertyAccessValidator(this.session, (IAuthorizationDAOFactory)this.businessObjectFactory.getDAOFactory()));
    }

    private static SampleIdentifier createSampleIdentifier(PlateIdentifier plate) {
        SampleOwnerIdentifier owner;
        if (plate.getPlateCode() == null) {
            return null;
        }
        String spaceCodeOrNull = plate.tryGetSpaceCode();
        String projectCodeOrNull = plate.tryGetProjectCode();
        if (projectCodeOrNull != null) {
            ProjectIdentifier projectIdentifier = new ProjectIdentifier(spaceCodeOrNull, projectCodeOrNull);
            owner = new SampleOwnerIdentifier(projectIdentifier);
        } else if (spaceCodeOrNull != null) {
            SpaceIdentifier space = new SpaceIdentifier(spaceCodeOrNull);
            owner = new SampleOwnerIdentifier(space);
        } else {
            owner = new SampleOwnerIdentifier();
        }
        return SampleIdentifier.createOwnedBy((SampleOwnerIdentifier)owner, (String)plate.getPlateCode());
    }

    private List<WellIdentifier> asWellIdentifiers(List<Sample> samples, PlateIdentifier plateIdentifier) {
        ArrayList<WellIdentifier> wells = new ArrayList<WellIdentifier>();
        for (Sample sample : samples) {
            wells.add(ScreeningApiImpl.asWellIdentifier(sample, plateIdentifier));
        }
        Collections.sort(wells, new Comparator<WellIdentifier>(){

            @Override
            public int compare(WellIdentifier o1, WellIdentifier o2) {
                WellPosition p1 = o1.getWellPosition();
                WellPosition p2 = o2.getWellPosition();
                int result = Integer.valueOf(p1.getWellRow()).compareTo(p2.getWellRow());
                if (result == 0) {
                    result = Integer.valueOf(p1.getWellColumn()).compareTo(p2.getWellColumn());
                }
                return result;
            }
        });
        return wells;
    }

    private static WellIdentifier asWellIdentifier(Sample sample, PlateIdentifier plateIdentifier) {
        WellLocation location = ScreeningUtils.tryCreateLocationFromMatrixCoordinate(sample.getSubCode());
        if (location == null) {
            return null;
        }
        WellPosition position = new WellPosition(location.getRow(), location.getColumn());
        return new WellIdentifier(plateIdentifier, position, sample.getPermId());
    }

    public List<PlateWellMaterialMapping> listPlateMaterialMapping(List<? extends PlateIdentifier> plates, MaterialTypeIdentifier materialTypeIdentifierOrNull) {
        ArrayList<PlateWellMaterialMapping> result = new ArrayList<PlateWellMaterialMapping>(plates.size());
        IScreeningQuery query = this.createScreeningQuery();
        for (PlateIdentifier plateIdentifier : plates) {
            result.add(this.toPlateWellMaterialMapping(plateIdentifier, materialTypeIdentifierOrNull, this.getPlateGeometry(query, plateIdentifier), this.getPlateMapping(query, plateIdentifier, materialTypeIdentifierOrNull)));
        }
        return result;
    }

    private PlateWellMaterialMapping toPlateWellMaterialMapping(PlateIdentifier plateIdentifier, MaterialTypeIdentifier materialTypeIdentifierOrNull, PlateGeometryContainer plateGeometryContainer, DataIterator<WellContentQueryResult> wellContentList) {
        Geometry plateGeometry = Geometry.createFromPlateGeometryString(plateGeometryContainer.plate_geometry);
        PlateIdentifier finalPlateIdentifier = new PlateIdentifier(plateGeometryContainer.plate_code, plateGeometryContainer.space_code, plateGeometryContainer.perm_id);
        PlateWellMaterialMapping result = new PlateWellMaterialMapping(finalPlateIdentifier, plateGeometry, 1);
        if (materialTypeIdentifierOrNull != null) {
            for (WellContentQueryResult wellContent : wellContentList) {
                WellLocation location = ScreeningUtils.tryCreateLocationFromMatrixCoordinate(wellContent.well_code);
                String materialContentCode = wellContent.material_content_code;
                result.getMaterialsForWell(location.getRow(), location.getColumn()).add(new MaterialIdentifier(materialTypeIdentifierOrNull, materialContentCode));
            }
        } else {
            HashMap<String, MaterialTypeIdentifier> map = new HashMap<String, MaterialTypeIdentifier>();
            for (WellContentQueryResult wellContent : wellContentList) {
                MaterialTypeIdentifier typeId = (MaterialTypeIdentifier)map.get(wellContent.material_content_type_code);
                if (typeId == null) {
                    typeId = new MaterialTypeIdentifier(wellContent.material_content_type_code);
                    map.put(typeId.getMaterialTypeCode(), typeId);
                }
                WellLocation location = ScreeningUtils.tryCreateLocationFromMatrixCoordinate(wellContent.well_code);
                String materialContentCode = wellContent.material_content_code;
                result.getMaterialsForWell(location.getRow(), location.getColumn()).add(new MaterialIdentifier(typeId, materialContentCode));
            }
        }
        return result;
    }

    private PlateGeometryContainer getPlateGeometry(IScreeningQuery query, PlateIdentifier plate) {
        PlateGeometryContainer plateGeometryContainer;
        if (plate.getPermId() == null) {
            plateGeometryContainer = query.tryGetPlateGeometry(plate.tryGetSpaceCode(), plate.getPlateCode());
            if (plateGeometryContainer == null) {
                throw new IllegalArgumentException("No plate with code '" + plate.tryGetSpaceCode() + "/" + plate.getPlateCode() + "' found.");
            }
            plateGeometryContainer.space_code = plate.tryGetSpaceCode();
            plateGeometryContainer.plate_code = plate.getPlateCode();
        } else {
            plateGeometryContainer = query.tryGetPlateGeometry(plate.getPermId());
            if (plateGeometryContainer == null) {
                throw new IllegalArgumentException("No plate with perm id '" + plate.getPermId() + "' found.");
            }
            plateGeometryContainer.perm_id = plate.getPermId();
        }
        return plateGeometryContainer;
    }

    private DataIterator<WellContentQueryResult> getPlateMapping(IScreeningQuery query, PlateIdentifier plate, MaterialTypeIdentifier materialTypeIdentifierOrNull) {
        if (materialTypeIdentifierOrNull != null) {
            if (plate.getPermId() == null) {
                return query.getPlateMappingForMaterialType(plate.tryGetSpaceCode(), plate.getPlateCode(), materialTypeIdentifierOrNull.getMaterialTypeCode());
            }
            return query.getPlateMappingForMaterialType(plate.getPermId(), materialTypeIdentifierOrNull.getMaterialTypeCode());
        }
        if (plate.getPermId() == null) {
            return query.getPlateMapping(plate.tryGetSpaceCode(), plate.getPlateCode());
        }
        return query.getPlateMapping(plate.getPermId());
    }

    private IScreeningQuery createScreeningQuery() {
        return (IScreeningQuery)QueryTool.getManagedQuery(IScreeningQuery.class);
    }

    private ExperimentPE getExperimentFromDB(ExperimentIdentifier experimentIdentifierFromUser) {
        if (experimentIdentifierFromUser.getPermId() != null) {
            ExperimentPE experimentPE = this.daoFactory.getExperimentDAO().tryGetByPermID(experimentIdentifierFromUser.getPermId());
            if (experimentPE == null) {
                throw UserFailureException.fromTemplate((String)"Experiment '%s' not found", (Object[])new Object[]{experimentIdentifierFromUser.getPermId()});
            }
            return experimentPE;
        }
        String spaceCode = SpaceCodeHelper.getSpaceCode((String)this.session.tryGetHomeGroupCode(), (String)experimentIdentifierFromUser.getSpaceCode());
        if (StringUtils.isEmpty((CharSequence)spaceCode)) {
            throw new UserFailureException("Space code is empty but there are no experiments outside a space, use null to denote your home space.");
        }
        ProjectPE projectPE = this.daoFactory.getProjectDAO().tryFindProject(spaceCode, experimentIdentifierFromUser.getProjectCode());
        if (projectPE == null) {
            throw UserFailureException.fromTemplate((String)"Project '%s' in space '%s' not found", (Object[])new Object[]{experimentIdentifierFromUser.getProjectCode(), spaceCode});
        }
        ExperimentPE experimentPE = this.daoFactory.getExperimentDAO().tryFindByCodeAndProject(projectPE, experimentIdentifierFromUser.getExperimentCode());
        if (experimentPE == null) {
            throw UserFailureException.fromTemplate((String)"Experiment '%s' in project '%s', space '%s' not found", (Object[])new Object[]{experimentIdentifierFromUser.getExperimentCode(), experimentIdentifierFromUser.getProjectCode(), spaceCode});
        }
        return experimentPE;
    }

    private TechId getExperimentTechId(ExperimentIdentifier experimentIdentifierFromUser) {
        if (experimentIdentifierFromUser.getPermId() != null) {
            ExperimentPE experimentPE = this.daoFactory.getExperimentDAO().tryGetByPermID(experimentIdentifierFromUser.getPermId());
            if (experimentPE == null) {
                throw UserFailureException.fromTemplate((String)"Experiment '%s' not found", (Object[])new Object[]{experimentIdentifierFromUser.getPermId()});
            }
            return new TechId(experimentPE.getId());
        }
        String spaceCode = SpaceCodeHelper.getSpaceCode((String)this.session.tryGetHomeGroupCode(), (String)experimentIdentifierFromUser.getSpaceCode());
        if (StringUtils.isEmpty((CharSequence)spaceCode)) {
            throw new UserFailureException("Space code is empty but there are no experiments outside a space, use null to denote your home space.");
        }
        ProjectPE projectPE = this.daoFactory.getProjectDAO().tryFindProject(spaceCode, experimentIdentifierFromUser.getProjectCode());
        if (projectPE == null) {
            throw UserFailureException.fromTemplate((String)"Project '%s' in space '%s' not found", (Object[])new Object[]{experimentIdentifierFromUser.getProjectCode(), spaceCode});
        }
        ExperimentPE experimentPE = this.daoFactory.getExperimentDAO().tryFindByCodeAndProject(projectPE, experimentIdentifierFromUser.getExperimentCode());
        if (experimentPE == null) {
            throw UserFailureException.fromTemplate((String)"Experiment '%s' in project '%s', space '%s' not found", (Object[])new Object[]{experimentIdentifierFromUser.getExperimentCode(), experimentIdentifierFromUser.getProjectCode(), spaceCode});
        }
        return new TechId(experimentPE.getId());
    }

    private static Map<String, DatasetReferenceHolder> createPlateToDatasetsMap(List<ImageDatasetReference> imageDatasets, List<FeatureVectorDatasetReference> featureVectorDatasets) {
        DatasetReferenceHolder reference;
        HashMap<String, DatasetReferenceHolder> map = new HashMap<String, DatasetReferenceHolder>();
        for (ImageDatasetReference imageDatasetReference : imageDatasets) {
            reference = (DatasetReferenceHolder)map.get(imageDatasetReference.getPlate().getPermId());
            if (reference == null) {
                reference = new DatasetReferenceHolder();
                map.put(imageDatasetReference.getPlate().getPermId(), reference);
            }
            reference.imageDatasets.add(imageDatasetReference);
        }
        for (FeatureVectorDatasetReference featureVectorDatasetReference : featureVectorDatasets) {
            reference = (DatasetReferenceHolder)map.get(featureVectorDatasetReference.getPlate().getPermId());
            if (reference == null) {
                reference = new DatasetReferenceHolder();
                map.put(featureVectorDatasetReference.getPlate().getPermId(), reference);
            }
            reference.featureVectorDatasets.add(featureVectorDatasetReference);
        }
        return map;
    }

    private static Plate asPlate(ExperimentIdentifier experimentIdentifier, WellContent wellContent) {
        String projectCode = SamplePE.projectSamplesEnabled ? experimentIdentifier.getProjectCode() : null;
        return new Plate(wellContent.getPlate().getCode(), experimentIdentifier.getSpaceCode(), projectCode, wellContent.getPlate().getPermId(), experimentIdentifier);
    }

    private static Plate asPlate(WellContent wellContent) {
        String projectCode = SamplePE.projectSamplesEnabled ? wellContent.getExperiment().getProjectCode() : null;
        return new Plate(wellContent.getPlate().getCode(), wellContent.getExperiment().getSpaceCode(), projectCode, wellContent.getPlate().getPermId(), ScreeningApiImpl.asExperiment(wellContent));
    }

    private static ExperimentIdentifier asExperiment(WellContent wellContent) {
        return new ExperimentIdentifier(wellContent.getExperiment().getCode(), wellContent.getExperiment().getProjectCode(), wellContent.getExperiment().getSpaceCode(), wellContent.getExperiment().getPermId());
    }

    private static PlateWellReferenceWithDatasets asPlateWellReference(ExperimentIdentifier experimentIdentifier, WellContent wellContent, Map<String, DatasetReferenceHolder> plateToDatasetsMap) {
        Plate plate = ScreeningApiImpl.asPlate(experimentIdentifier, wellContent);
        WellLocation location = wellContent.tryGetLocation();
        WellPosition wellPosition = new WellPosition(location.getRow(), location.getColumn());
        DatasetReferenceHolder datasetReferences = plateToDatasetsMap.get(plate.getPermId());
        if (datasetReferences == null) {
            return new PlateWellReferenceWithDatasets(plate, wellPosition);
        }
        return new PlateWellReferenceWithDatasets(plate, wellPosition, datasetReferences.imageDatasets, datasetReferences.featureVectorDatasets);
    }

    private static List<PlateWellReferenceWithDatasets> asPlateWellReferences(ExperimentIdentifier experimentIdentifer, List<WellContent> wellContents, Map<String, DatasetReferenceHolder> plateToDatasetsMap) {
        ArrayList<PlateWellReferenceWithDatasets> plateWellReferences = new ArrayList<PlateWellReferenceWithDatasets>();
        for (WellContent wellContent : wellContents) {
            plateWellReferences.add(ScreeningApiImpl.asPlateWellReference(experimentIdentifer, wellContent, plateToDatasetsMap));
        }
        Collections.sort(plateWellReferences, new Comparator<PlateWellReferenceWithDatasets>(){

            @Override
            public int compare(PlateWellReferenceWithDatasets o1, PlateWellReferenceWithDatasets o2) {
                return (o1.getExperimentPlateIdentifier().getAugmentedCode() + ":" + o1.getWellPosition()).compareTo(o2.getExperimentPlateIdentifier().getAugmentedCode() + ":" + o2.getWellPosition());
            }
        });
        return plateWellReferences;
    }

    private static List<PlateWellReferenceWithDatasets> asPlateWellReferences(List<WellContent> wellContents, Map<String, DatasetReferenceHolder> plateToDatasetsMap) {
        ArrayList<PlateWellReferenceWithDatasets> plateWellReferences = new ArrayList<PlateWellReferenceWithDatasets>();
        for (WellContent wellContent : wellContents) {
            plateWellReferences.add(ScreeningApiImpl.asPlateWellReference(ScreeningApiImpl.asExperiment(wellContent), wellContent, plateToDatasetsMap));
        }
        Collections.sort(plateWellReferences, new Comparator<PlateWellReferenceWithDatasets>(){

            @Override
            public int compare(PlateWellReferenceWithDatasets o1, PlateWellReferenceWithDatasets o2) {
                return (o1.getExperimentPlateIdentifier().getAugmentedCode() + ":" + o1.getWellPosition()).compareTo(o2.getExperimentPlateIdentifier().getAugmentedCode() + ":" + o2.getWellPosition());
            }
        });
        return plateWellReferences;
    }

    public List<ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata> getPlateMetadata(List<? extends PlateIdentifier> plateIdentifiers) {
        ArrayList<TechId> techIds = new ArrayList<TechId>();
        for (PlateIdentifier plateIdentifier : plateIdentifiers) {
            TechId techId = this.getSampleTechId(plateIdentifier);
            if (techId == null) continue;
            techIds.add(techId);
        }
        List<PlateMetadata> plateMetadatas = PlateContentLoader.loadPlateMetadata(this.session, this.daoFactory.getSessionFactory().getCurrentSession(), this.businessObjectFactory, this.managedPropertyEvaluatorFactory, techIds);
        ArrayList<ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata> arrayList = new ArrayList<ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata>();
        HashMap<Long, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> materialsCache = new HashMap<Long, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material>();
        for (PlateMetadata plateMetaData : plateMetadatas) {
            arrayList.add(this.asApiPlateMetadata(plateMetaData, materialsCache));
        }
        return arrayList;
    }

    private ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata asApiPlateMetadata(PlateMetadata plateMetadata, Map<Long, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> materialsCache) {
        Sample plate = plateMetadata.getPlate();
        PlateIdentifier plateIdentifier = ScreeningUtils.createPlateIdentifier(plate);
        ArrayList<ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellMetadata> wells = new ArrayList<ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellMetadata>();
        if (plateMetadata.getWells() != null) {
            for (WellMetadata wellMetadata : plateMetadata.getWells()) {
                ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellMetadata well = this.asApiWell(plateIdentifier, wellMetadata, materialsCache);
                wells.add(well);
            }
        }
        Geometry geometry = Geometry.createFromRowColDimensions(plateMetadata.getRowsNum(), plateMetadata.getColsNum());
        Map properties = EntityHelper.convertToStringMap((List)plate.getProperties());
        return new ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata(plateIdentifier, geometry, properties, wells);
    }

    private ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellMetadata asApiWell(PlateIdentifier plateIdentifier, WellMetadata wellMetadata, Map<Long, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> materialsCache) {
        Sample well = wellMetadata.getWellSample();
        WellLocation location = wellMetadata.tryGetLocation();
        WellPosition wellPosition = new WellPosition(location.getRow(), location.getColumn());
        Map properties = EntityHelper.convertToStringMap((List)well.getProperties());
        Map<String, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> materialProperties = this.convertMaterialProperties(well.getProperties(), materialsCache);
        return new ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellMetadata(plateIdentifier, well.getCode(), well.getPermId(), well.getSampleType().getCode(), wellPosition, properties, materialProperties);
    }

    private Map<String, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> convertMaterialProperties(List<IEntityProperty> properties, Map<Long, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> materialsCache) {
        HashMap<String, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> result = new HashMap<String, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material>();
        if (properties != null) {
            for (IEntityProperty property : properties) {
                Material material = property.getMaterial();
                if (material == null) continue;
                ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material apiMaterial = materialsCache.get(material.getId());
                if (apiMaterial == null) {
                    apiMaterial = this.asApiMaterial(material, materialsCache);
                }
                String propCode = property.getPropertyType().getCode();
                result.put(propCode, apiMaterial);
            }
        }
        return result;
    }

    private ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material asApiMaterial(Material materialDto, Map<Long, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> materialsCache) {
        MaterialTypeIdentifier typeIdentifier = new MaterialTypeIdentifier(materialDto.getMaterialType().getCode());
        List originalProperties = materialDto.getProperties();
        Map properties = EntityHelper.convertToStringMap((List)originalProperties);
        Map<String, ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material> materialProperties = this.convertMaterialProperties(originalProperties, materialsCache);
        return new ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material(typeIdentifier, materialDto.getCode(), properties, materialProperties);
    }

    public ExperimentImageMetadata getExperimentImageMetadata(ExperimentIdentifier experimentIdentifer) {
        long experimentId = this.getExperimentTechId(experimentIdentifer).getId();
        List<String> dataStoreCodes = this.createScreeningQuery().listDataStoreCodesForExperiment(experimentId);
        IExperimentMetadataLoader loader = this.businessObjectFactory.createExperimentMetadataLoader(experimentId, dataStoreCodes);
        Geometry plateGeometry = loader.tryGetPlateGeometry();
        Geometry tileGeometry = loader.tryGetTileGeometry();
        List<ImageChannel> channels = loader.getImageChannels();
        ImageSize originalImageSize = loader.tryGetOriginalImageSize();
        List<ImageSize> thumbnailImageSizes = loader.getThumbnailImageSizes();
        return new ExperimentImageMetadata(experimentIdentifer, plateGeometry, tileGeometry, channels, originalImageSize, thumbnailImageSizes);
    }

    static class DatasetReferenceHolder {
        final List<ImageDatasetReference> imageDatasets = new ArrayList<ImageDatasetReference>();
        final List<FeatureVectorDatasetReference> featureVectorDatasets = new ArrayList<FeatureVectorDatasetReference>();

        DatasetReferenceHolder() {
        }
    }
}

